"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageQuote = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const lodash_1 = __importDefault(require("lodash"));
const types_1 = require("../../../../bchat/types");
const conversations_1 = require("../../../../state/ducks/conversations");
const conversations_2 = require("../../../../state/selectors/conversations");
const Quote_1 = require("./Quote");
const utils_1 = require("../../../../bchat/utils");
const data_1 = require("../../../../data/data");
const MessageQuote = (props) => {
    const selected = (0, react_redux_1.useSelector)(state => (0, conversations_2.getMessageQuoteProps)(state, props.messageId));
    const multiSelectMode = (0, react_redux_1.useSelector)(conversations_2.isMessageSelectionMode);
    const isMessageDetailViewMode = (0, react_redux_1.useSelector)(conversations_2.isMessageDetailView);
    const quote = selected ? selected.quote : undefined;
    const direction = selected ? selected.direction : undefined;
    const onQuoteClick = (0, react_1.useCallback)(async (event) => {
        event.preventDefault();
        event.stopPropagation();
        if (!quote) {
            window.log.warn('onQuoteClick: quote not valid');
            return;
        }
        if (isMessageDetailViewMode) {
            return;
        }
        const { referencedMessageNotFound, messageId: quotedMessageSentAt, sender: quoteAuthor, } = quote;
        if (referencedMessageNotFound || !quotedMessageSentAt || !quoteAuthor) {
            utils_1.ToastUtils.pushOriginalNotFound();
            return;
        }
        const collection = await (0, data_1.getMessagesBySentAt)(lodash_1.default.toNumber(quotedMessageSentAt));
        const foundInDb = collection.find((item) => {
            const messageAuthor = item.getSource();
            return Boolean(messageAuthor && quoteAuthor === messageAuthor);
        });
        if (!foundInDb) {
            utils_1.ToastUtils.pushOriginalNotFound();
            return;
        }
        void (0, conversations_1.openConversationToSpecificMessage)({
            conversationKey: foundInDb.get('conversationId'),
            messageIdToNavigateTo: foundInDb.get('id'),
            shouldHighlightMessage: true,
        });
    }, [quote, multiSelectMode, props.messageId]);
    if (!selected) {
        return null;
    }
    if (!quote || !quote.sender || !quote.messageId) {
        return null;
    }
    const shortenedPubkey = types_1.PubKey.shorten(quote.sender);
    const displayedPubkey = quote.authorProfileName ? shortenedPubkey : quote.sender;
    return (react_1.default.createElement(Quote_1.Quote, { onClick: onQuoteClick, text: quote.text || '', attachment: quote.attachment, isIncoming: direction === 'incoming', sender: displayedPubkey, authorProfileName: quote.authorProfileName, authorName: quote.authorName, isSharedContact: quote?.isSharedContact, referencedMessageNotFound: quote.referencedMessageNotFound || false, isFromMe: quote.isFromMe || false }));
};
exports.MessageQuote = MessageQuote;
