"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageReactBar = void 0;
const react_1 = __importStar(require("react"));
const styled_components_1 = __importStar(require("styled-components"));
const icon_1 = require("../../../icon");
const Reaction_1 = require("../../../../types/Reaction");
const storage_1 = require("../../../../util/storage");
const emoji_1 = require("../../../../util/emoji");
const lodash_1 = require("lodash");
const expand = (0, styled_components_1.keyframes) `
  from {
    width: 0;
  }
  to {
    width: 100%;
  }
`;
const rotateEmoji = (0, styled_components_1.keyframes) `
  from {
    transform: rotate(0deg);
  }
  to {
    transform: rotate(360deg);
  }
`;
const rotateEmojiAntiClock = (0, styled_components_1.keyframes) `
  from {
    transform: rotate(0deg);
  }
  to {
    transform: rotate(-360deg);
  }
`;
const StyledMessageReactBar = styled_components_1.default.div `
  box-shadow: 0 2px 16px 0 rgba(0, 0, 0, 0.2), 0 0px 20px 0 rgba(0, 0, 0, 0.19);
  padding: 6px 8px;
  white-space: nowrap;
  display: flex;
  align-items: center;
  flex-direction: ${props => (props.isIncoming ? 'row' : 'row-reverse')};
  border-radius: 24px;
  background: var(--color-emoji-panel-bg);
  font-size: 20px;
  animation: ${expand} 0.3s ease-in-out forwards; /* Add animation here */
  overflow: hidden;
  float: ${props => (props.isIncoming ? 'left' : 'right')};
  span {
    cursor: pointer;
  }
  .bchat-icon-button {
    margin-right: 0;
    border-color: transparent !important;
    box-shadow: none !important;
  }
`;
const ReactButton = styled_components_1.default.div `
  margin: 0 4px;
  animation: ${props => (props.isIncoming ? rotateEmoji : rotateEmojiAntiClock)} 0.4s linear forwards;
  cursor: pointer;

`;
const MessageReactBar = (props) => {
    const { action, additionalAction, isIncoming } = props;
    const [recentReactions, setRecentReactions] = (0, react_1.useState)();
    (0, react_1.useEffect)(() => {
        const reactions = new Reaction_1.RecentReactions((0, storage_1.getRecentReactions)());
        if (reactions && !(0, lodash_1.isEqual)(reactions, recentReactions)) {
            setRecentReactions(reactions);
        }
    }, [recentReactions]);
    if (!recentReactions) {
        return react_1.default.createElement(react_1.default.Fragment, null);
    }
    return (react_1.default.createElement(StyledMessageReactBar, { isIncoming: isIncoming },
        recentReactions &&
            recentReactions.items.map(emoji => (react_1.default.createElement(ReactButton, { isIncoming: isIncoming, key: emoji, role: 'img', "aria-label": emoji_1.nativeEmojiData?.ariaLabels ? emoji_1.nativeEmojiData.ariaLabels[emoji] : undefined, onClick: () => {
                    action(emoji);
                }, className: "recentButton" }, emoji))),
        react_1.default.createElement("span", null,
            react_1.default.createElement(icon_1.BchatIconButton, { iconColor: '#858598', iconSize: 20, iconType: "plusOuterFilled", onClick: e => additionalAction(e) }))));
};
exports.MessageReactBar = MessageReactBar;
