"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageReactions = exports.StyledMessageReactions = exports.popupYDefault = exports.popupXDefault = void 0;
const react_1 = __importStar(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
const lodash_1 = require("lodash");
const lodash_2 = __importDefault(require("lodash"));
const Flex_1 = require("../../../basic/Flex");
const ReactionPopup_1 = require("../reactions/ReactionPopup");
const Reaction_1 = require("../reactions/Reaction");
const icon_1 = require("../../../icon");
const useParamSelector_1 = require("../../../../hooks/useParamSelector");
const conversations_1 = require("../../../../state/selectors/conversations");
const react_redux_1 = require("react-redux");
exports.popupXDefault = -101;
exports.popupYDefault = -90;
const StyledMessageReactionsContainer = (0, styled_components_1.default)(Flex_1.Flex) `
  position: relative;
  height: 100%;

  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  // margin-top:3px;
  margin-bottom:${props => (props.inModal ? 'unset' : props.islastSeriesOfMsg ? '15px' : '6px')} ;
  ${ReactionPopup_1.StyledPopupContainer} {
    position: absolute;
    // top: ${props => `${props.y}px;`};
    // left: ${props => `${props.x}px;`};
    // left:${props => `${props.isIncoming ? 18 : -187}px;`}
    z-index: 2;
  
  }
`;
exports.StyledMessageReactions = (0, styled_components_1.default)(Flex_1.Flex) `
  ${props => props.inModal
    ? ''
    : `max-width: 375px;; 
     `}
     margin :-15px 20px 0 20px;
`;
const Reactions = (props) => {
    const { messageId, reactions, inModal, isIncoming, handlePopupReaction } = props;
    return (react_1.default.createElement(exports.StyledMessageReactions, { container: true, flexWrap: inModal ? 'nowrap' : 'wrap', alignItems: 'center', inModal: inModal, flexDirection: isIncoming ? 'row' : 'row-reverse', onMouseLeave: () => handlePopupReaction && handlePopupReaction('') }, reactions.map(([emoji, _]) => (react_1.default.createElement(Reaction_1.Reaction, { key: `${messageId}-${emoji}`, emoji: emoji, ...props })))));
};
const CompressedReactions = (props) => {
    const { messageId, reactions, inModal, handlePopupClick, isIncoming, handlePopupReaction, } = props;
    return (react_1.default.createElement(exports.StyledMessageReactions, { container: true, flexWrap: inModal ? 'nowrap' : 'wrap', alignItems: 'center', inModal: inModal, flexDirection: isIncoming ? 'row' : 'row-reverse', onMouseLeave: () => handlePopupReaction && handlePopupReaction('') },
        reactions.slice(0, 5).map(([emoji, _]) => (react_1.default.createElement(Reaction_1.Reaction, { key: `${messageId}-${emoji}`, emoji: emoji, ...props }))),
        react_1.default.createElement(icon_1.BchatIconButton, { iconType: 'chevron', iconSize: 20, iconColor: "#A7A7BA", btnRadius: "40px", btnBgColor: "var(--color-emoji-panel-bg)", iconRotation: isIncoming ? 270 : 90, onClick: handlePopupClick, margin: "0 3px" })));
};
const MessageReactions = (props) => {
    const { messageId, hasReactLimit = true, onClick, popupReaction, setPopupReaction, onPopupClick, inModal = false, onSelected, isIncoming, iscurrentReact, } = props;
    const [reactions, setReactions] = (0, react_1.useState)([]);
    const contentProps = (0, react_redux_1.useSelector)(state => (0, conversations_1.getMessageContentSelectorProps)(state, props.messageId));
    const islastSeriesOfMsg = contentProps?.lastMessageOfSeries;
    const [popupX, setPopupX] = (0, react_1.useState)(exports.popupXDefault);
    const [popupY, setPopupY] = (0, react_1.useState)(exports.popupYDefault);
    const msgProps = (0, useParamSelector_1.useMessageReactsPropsById)(messageId);
    if (!msgProps) {
        return react_1.default.createElement(react_1.default.Fragment, null);
    }
    const { conversationType, sortedReacts: reacts } = msgProps;
    const inGroup = conversationType === 'group';
    const reactLimit = 5;
    const reactionsProps = {
        messageId,
        reactions,
        inModal,
        inGroup,
        handlePopupX: setPopupX,
        handlePopupY: setPopupY,
        onClick,
        popupReaction,
        onSelected,
        handlePopupReaction: setPopupReaction,
        handlePopupClick: onPopupClick,
        isIncoming,
        iscurrentReact,
    };
    (0, react_1.useEffect)(() => {
        if (reacts && !(0, lodash_1.isEqual)(reactions, reacts)) {
            setReactions(reacts);
        }
        if (!(0, lodash_1.isEmpty)(reactions) && (0, lodash_1.isEmpty)(reacts)) {
            setReactions([]);
        }
    }, [reacts, reactions]);
    if (lodash_2.default.isEmpty(reacts)) {
        return react_1.default.createElement(react_1.default.Fragment, null);
    }
    return (react_1.default.createElement(StyledMessageReactionsContainer, { container: true, flexDirection: 'column', justifyContent: 'center', alignItems: inModal ? 'flex-start' : 'center', x: popupX, y: popupY, isIncoming: isIncoming, inModal: inModal, islastSeriesOfMsg: islastSeriesOfMsg }, reacts &&
        !lodash_2.default.isEmpty(reacts) &&
        (!hasReactLimit || reacts.length <= reactLimit ? (react_1.default.createElement(Reactions, { ...reactionsProps })) : (react_1.default.createElement(CompressedReactions, { ...reactionsProps })))));
};
exports.MessageReactions = MessageReactions;
