"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageText = void 0;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const conversations_1 = require("../../../../state/selectors/conversations");
const icon_1 = require("../../../icon");
const MessageBody_1 = require("./MessageBody");
const MessageText = (props) => {
    const selected = (0, react_redux_1.useSelector)(state => (0, conversations_1.getMessageTextProps)(state, props.messageId));
    const multiSelectMode = (0, react_redux_1.useSelector)(conversations_1.isMessageSelectionMode);
    const currentValueFromSettings = window.getSettingValue('font-size-setting') || "Small";
    function FontSizeChanger() {
        let size;
        if (currentValueFromSettings === "Small") {
            size = "14px";
        }
        else if (currentValueFromSettings === "Medium") {
            size = "16px";
        }
        else {
            size = "18px";
        }
        return size;
    }
    if (!selected) {
        return null;
    }
    const { text, direction, status, isDeleted, conversationType } = selected;
    const contents = isDeleted
        ? window.i18n('messageDeletedPlaceholder')
        : direction === 'incoming' && status === 'error'
            ? window.i18n('incomingError')
            : text;
    if (!contents) {
        return null;
    }
    return (react_1.default.createElement("div", { dir: "auto", className: (0, classnames_1.default)('module-message__text', `module-message__text--${direction}`, status === 'error' && direction === 'incoming' ? 'module-message__text--error' : null) },
        react_1.default.createElement("div", { style: { fontSize: FontSizeChanger() } },
            isDeleted && react_1.default.createElement(icon_1.BchatIcon, { iconType: "delete", iconSize: "small" }),
            react_1.default.createElement(MessageBody_1.MessageBody, { text: contents || '', disableLinks: multiSelectMode, disableJumbomoji: false, isGroup: conversationType === 'group' }),
            react_1.default.createElement("span", { className: 'spacer' }))));
};
exports.MessageText = MessageText;
