"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutgoingMessageStatus = void 0;
const electron_1 = require("electron");
const react_1 = __importDefault(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
const icon_1 = require("../../../icon");
const MessageStatusSendingContainer = styled_components_1.default.div `
  display: inline-block;
  // align-self: flex-end;
  margin-bottom: 2px;
  margin-inline-start: 5px;
  cursor: pointer;
`;
const MessageStatusSending = ({ dataTestId }) => {
    const imgsrc = 'images/bchat/messageLoading.gif';
    return (react_1.default.createElement(MessageStatusSendingContainer, { "data-testid": dataTestId, "data-testtype": "sending" },
        react_1.default.createElement("div", null,
            react_1.default.createElement("img", { src: imgsrc, style: { width: '18px', height: '18px', display: 'flex', } }))));
};
const MessageStatusSent = ({ dataTestId }) => {
    return (react_1.default.createElement(MessageStatusSendingContainer, { "data-testid": dataTestId, "data-testtype": "sent" },
        react_1.default.createElement(icon_1.BchatIcon, { iconColor: '#108D32', iconType: "circleCheck", iconSize: "medium" })));
};
const MessageStatusRead = ({ dataTestId }) => {
    return (react_1.default.createElement(MessageStatusSendingContainer, { "data-testid": dataTestId, "data-testtype": "read" },
        react_1.default.createElement(icon_1.BchatIcon, { iconColor: '#108D32', iconType: "doubleCheckCircleFilled", iconSize: "medium" })));
};
const MessageStatusError = ({ dataTestId }) => {
    const showDebugLog = () => {
        electron_1.ipcRenderer.send('show-debug-log');
    };
    return (react_1.default.createElement(MessageStatusSendingContainer, { "data-testid": dataTestId, "data-testtype": "failed", onClick: showDebugLog, title: window.i18n('sendFailed') },
        react_1.default.createElement(icon_1.BchatIcon, { iconColor: '#FF3E3E', iconType: "error", iconSize: "medium" })));
};
const OutgoingMessageStatus = (props) => {
    const { status, dataTestId } = props;
    switch (status) {
        case 'sending':
            return react_1.default.createElement(MessageStatusSending, { dataTestId: dataTestId });
        case 'sent':
            return react_1.default.createElement(MessageStatusSent, { dataTestId: dataTestId });
        case 'read':
            return react_1.default.createElement(MessageStatusRead, { dataTestId: dataTestId });
        case 'error':
            return react_1.default.createElement(MessageStatusError, { dataTestId: dataTestId });
        default:
            return null;
    }
};
exports.OutgoingMessageStatus = OutgoingMessageStatus;
