"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Quote = exports.QuoteReferenceWarning = exports.QuoteText = exports.QuoteIconContainer = exports.QuoteGenericFile = exports.QuoteImage = exports.QuoteIcon = void 0;
const react_1 = __importStar(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const MIME = __importStar(require("../../../../../ts/types/MIME"));
const GoogleChrome = __importStar(require("../../../../../ts/util/GoogleChrome"));
const react_redux_1 = require("react-redux");
const lodash_1 = require("lodash");
const useDisableDrag_1 = require("../../../../hooks/useDisableDrag");
const useEncryptedFileFetch_1 = require("../../../../hooks/useEncryptedFileFetch");
const types_1 = require("../../../../bchat/types");
const conversations_1 = require("../../../../state/selectors/conversations");
const ContactName_1 = require("../../ContactName");
const MessageBody_1 = require("./MessageBody");
const useParamSelector_1 = require("../../../../hooks/useParamSelector");
const styled_components_1 = __importDefault(require("styled-components"));
const icon_1 = require("../../../icon");
const Flex_1 = require("../../../basic/Flex");
function validateQuote(quote) {
    if (quote.text) {
        return true;
    }
    if (quote.attachment) {
        return true;
    }
    return false;
}
function getObjectUrl(thumbnail) {
    if (thumbnail && thumbnail.objectUrl) {
        return thumbnail.objectUrl;
    }
    return;
}
function getTypeLabel({ contentType, isVoiceMessage, fileName, }) {
    if (GoogleChrome.isVideoTypeSupported(contentType)) {
        return (react_1.default.createElement("span", null,
            react_1.default.createElement(icon_1.BchatIcon, { iconType: 'replyPlay', iconSize: 16 }),
            " ",
            fileName || window.i18n('video'),
            ' '));
    }
    if (GoogleChrome.isImageTypeSupported(contentType)) {
        return (react_1.default.createElement("span", null,
            react_1.default.createElement(icon_1.BchatIcon, { iconType: 'replyImage', fillRule: "evenodd", clipRule: "evenodd", iconSize: 16 }),
            ' ',
            fileName || window.i18n('photo'),
            ' '));
    }
    if (MIME.isAudio(contentType) && isVoiceMessage) {
        return (react_1.default.createElement("span", null,
            react_1.default.createElement(icon_1.BchatIcon, { iconType: 'microphone', iconSize: 16 }),
            " ",
            window.i18n('voiceMessage'),
            ' '));
    }
    if (MIME.isAudio(contentType)) {
        return (react_1.default.createElement("span", null,
            react_1.default.createElement(icon_1.BchatIcon, { iconType: 'replyMicrophone', iconSize: 16 }),
            " ",
            window.i18n('audio'),
            ' '));
    }
    return;
}
const QuoteIcon = (props) => {
    const { icon } = props;
    return (react_1.default.createElement("div", { className: "module-quote__icon-container" },
        react_1.default.createElement("div", { className: "module-quote__icon-container__inner" },
            react_1.default.createElement("div", { className: "module-quote__icon-container__circle-background" },
                react_1.default.createElement("div", { className: (0, classnames_1.default)('module-quote__icon-container__icon', `module-quote__icon-container__icon--${icon}`) })))));
};
exports.QuoteIcon = QuoteIcon;
const QuoteImage = (props) => {
    const { url, icon, contentType, handleImageErrorBound } = props;
    const disableDrag = (0, useDisableDrag_1.useDisableDrag)();
    const { loading, urlToLoad } = (0, useEncryptedFileFetch_1.useEncryptedFileFetch)(url, contentType, false);
    const srcData = !loading ? urlToLoad : '';
    const iconElement = icon ? (react_1.default.createElement("div", { className: "module-quote__icon-container__inner" },
        react_1.default.createElement("div", { className: (0, classnames_1.default)(`module-quote__icon-container__circle-background`, icon && 'module-quote__icon-container__circle-background-transparent') },
            react_1.default.createElement("div", { className: (0, classnames_1.default)('module-quote__icon-container__icon', `module-quote__icon-container__icon--${icon}`) })))) : null;
    return (react_1.default.createElement("div", { className: "module-quote__icon-container" },
        react_1.default.createElement("img", { src: srcData, alt: window.i18n('quoteThumbnailAlt'), onDragStart: disableDrag, onError: handleImageErrorBound }),
        iconElement));
};
exports.QuoteImage = QuoteImage;
const QuoteGenericFile = (props) => {
    const { attachment, isIncoming } = props;
    if (!attachment) {
        return null;
    }
    const { fileName, contentType } = attachment;
    const isGenericFile = !GoogleChrome.isVideoTypeSupported(contentType) &&
        !GoogleChrome.isImageTypeSupported(contentType) &&
        !MIME.isAudio(contentType);
    if (!isGenericFile) {
        return null;
    }
    return (react_1.default.createElement("div", { className: "module-quote__generic-file" },
        react_1.default.createElement("div", { className: "module-quote__generic-file__icon" }),
        react_1.default.createElement("div", { className: (0, classnames_1.default)('module-quote__generic-file__text', isIncoming ? 'module-quote__generic-file__text--incoming' : null) }, fileName)));
};
exports.QuoteGenericFile = QuoteGenericFile;
const QuoteIconContainer = (props) => {
    const { attachment, imageBroken, handleImageErrorBound } = props;
    if (!attachment) {
        return null;
    }
    const { contentType, thumbnail } = attachment;
    const objectUrl = getObjectUrl(thumbnail);
    if (GoogleChrome.isVideoTypeSupported(contentType)) {
        return objectUrl && !imageBroken ? (react_1.default.createElement(exports.QuoteImage, { url: objectUrl, contentType: MIME.IMAGE_JPEG, icon: "play", handleImageErrorBound: lodash_1.noop })) : (react_1.default.createElement(exports.QuoteIcon, { icon: "movie" }));
    }
    if (GoogleChrome.isImageTypeSupported(contentType)) {
        return objectUrl && !imageBroken ? (react_1.default.createElement(exports.QuoteImage, { url: objectUrl, contentType: contentType, handleImageErrorBound: handleImageErrorBound })) : (react_1.default.createElement(exports.QuoteIcon, { icon: "image" }));
    }
    if (MIME.isAudio(contentType)) {
        return react_1.default.createElement(exports.QuoteIcon, { icon: "microphone" });
    }
    if (contentType === 'application/pdf') {
        return react_1.default.createElement(exports.QuoteIcon, { icon: "file" });
    }
    return null;
};
exports.QuoteIconContainer = QuoteIconContainer;
const QuoteText = (props) => {
    const { text, attachment, isIncoming } = props;
    const convoId = (0, react_redux_1.useSelector)(conversations_1.getSelectedConversationKey);
    const isGroup = (0, useParamSelector_1.useIsPrivate)(convoId);
    if (text) {
        return (react_1.default.createElement("div", { dir: "auto", className: (0, classnames_1.default)('module-quote__primary__text', isIncoming ? 'module-quote__primary__text--incoming' : null) },
            react_1.default.createElement(MessageBody_1.MessageBody, { text: text, disableLinks: true, disableJumbomoji: true, isGroup: isGroup })));
    }
    if (!attachment) {
        return null;
    }
    const { contentType, isVoiceMessage, fileName } = attachment;
    const typeLabel = getTypeLabel({ contentType, isVoiceMessage, fileName });
    if (typeLabel) {
        return (react_1.default.createElement("div", { className: (0, classnames_1.default)('module-quote__primary__type-label', isIncoming ? 'module-quote__primary__type-label--incoming' : null) }, typeLabel));
    }
    return null;
};
exports.QuoteText = QuoteText;
const QuoteAuthor = (props) => {
    const { authorProfileName, author, authorName, isFromMe, isIncoming } = props;
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('module-quote__primary__author', isIncoming ? 'module-quote__primary__author--incoming' : null) }, isFromMe ? (window.i18n('you')) : (react_1.default.createElement(ContactName_1.ContactName, { pubkey: types_1.PubKey.shorten(author), name: authorName, profileName: authorProfileName, compact: true, shouldShowPubkey: Boolean(props.showPubkeyForAuthor) }))));
};
const QuoteReferenceWarning = (props) => {
    const { isIncoming, referencedMessageNotFound } = props;
    if (!referencedMessageNotFound) {
        return null;
    }
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('module-quote__reference-warning', isIncoming ? 'module-quote__reference-warning--incoming' : null) },
        react_1.default.createElement("div", { className: (0, classnames_1.default)('module-quote__reference-warning__icon', isIncoming ? 'module-quote__reference-warning__icon--incoming' : null) }),
        react_1.default.createElement("div", { className: (0, classnames_1.default)('module-quote__reference-warning__text', isIncoming ? 'module-quote__reference-warning__text--incoming' : null) }, window.i18n('originalMessageNotFound'))));
};
exports.QuoteReferenceWarning = QuoteReferenceWarning;
const Quote = (props) => {
    const [imageBroken, setImageBroken] = (0, react_1.useState)(false);
    const handleImageErrorBound = () => {
        setImageBroken(true);
    };
    const isPublic = (0, react_redux_1.useSelector)(conversations_1.isPublicGroupConversation);
    if (!validateQuote(props)) {
        return null;
    }
    const { isIncoming, referencedMessageNotFound, attachment, text, isSharedContact, onClick, } = props;
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('module-quote-container') },
        react_1.default.createElement("div", { onClick: onClick, role: "button", className: (0, classnames_1.default)('module-quote', isIncoming ? 'module-quote--incoming' : 'module-quote--outgoing', !onClick ? 'module-quote--no-click' : null, referencedMessageNotFound ? 'module-quote--with-reference-warning' : null) },
            react_1.default.createElement("div", null,
                react_1.default.createElement(VerticalLine, { isIncoming: isIncoming })),
            react_1.default.createElement("div", { className: "module-quote__primary" },
                react_1.default.createElement(QuoteAuthor, { authorName: props.authorName, author: props.sender, authorProfileName: props.authorProfileName, isFromMe: props.isFromMe, isIncoming: props.isIncoming, showPubkeyForAuthor: isPublic }),
                react_1.default.createElement(exports.QuoteGenericFile, { ...props }),
                react_1.default.createElement(Flex_1.Flex, { container: true, width: '261px' },
                    isSharedContact && (react_1.default.createElement("span", { className: 'module-quote__primary__icon' },
                        react_1.default.createElement(icon_1.BchatIcon, { iconType: 'avatarOutline', iconSize: 11, strokeColor: isIncoming ? 'var(--color-text)' : '#F0F0F0', iconColor: isIncoming ? 'var(--color-text)' : '#F0F0F0', strokeWidth: '1px' }))),
                    react_1.default.createElement(exports.QuoteText, { isIncoming: isIncoming, text: text, attachment: attachment }))),
            react_1.default.createElement(exports.QuoteIconContainer, { attachment: attachment, handleImageErrorBound: handleImageErrorBound, imageBroken: imageBroken })),
        react_1.default.createElement(exports.QuoteReferenceWarning, { isIncoming: isIncoming, referencedMessageNotFound: referencedMessageNotFound })));
};
exports.Quote = Quote;
const VerticalLine = styled_components_1.default.div `
  width: 5px;
  background-color: ${props => props.isIncoming ? 'var(--color-untrusted-vertical-bar)' : '#F0F0F0'};
  height: 100%;
  border-radius: 10px;
`;
