"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageDateBreak = void 0;
const moment_1 = __importDefault(require("moment"));
const react_1 = __importDefault(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
const DateBreakContainer = styled_components_1.default.div `
  display: flex;
  justify-content: center;

  // width: 90%;
  // height: 1px;
  // margin: 25px auto;
  // background: #2e333d;
`;
const DateBreakText = styled_components_1.default.div `
  margin-top: 0.3rem;
  margin-bottom: 0.3rem;
  // letter-spacing: 0.6px;
  // font-size: 0.8rem;
  // font-weight: bold;
  // text-align: center;
  color: var(--color-chat-timestamp);
  background-color: var(--message-bubbles-received-background-color);
  border-radius: 40px;
  display: flex;
  justify-content: center;
  align-items: center;
  padding: 5px 20px; 

  height: 40px;
  // margin-top: -20px;
  border-radius: 22px;

  font-size: 14px;
  font-weight: 400;
`;
const MessageDateBreak = (props) => {
    const { timestamp, messageId } = props;
    const calendarFormat = {
        sameDay: '[Today]',
        nextDay: '[Tomorrow]',
        nextWeek: 'dddd',
        lastDay: '[Yesterday]',
        lastWeek: '[Last] dddd',
        sameElse: 'DD/MM/YYYY',
    };
    const text = (0, moment_1.default)(timestamp).calendar(undefined, calendarFormat);
    return (react_1.default.createElement(DateBreakContainer, { id: `date-break-${messageId}` },
        react_1.default.createElement(DateBreakText, null, text)));
};
exports.MessageDateBreak = MessageDateBreak;
