"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FontSizeChanger = exports.VerticalLine = exports.GroupInvitation = void 0;
const react_1 = __importStar(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const messageInteractions_1 = require("../../../../interactions/messageInteractions");
const ReadableMessage_1 = require("./ReadableMessage");
const Flex_1 = require("../../../basic/Flex");
const styled_components_1 = __importDefault(require("styled-components"));
const Text_1 = require("../../../basic/Text");
const react_redux_1 = require("react-redux");
const BchatJoinableDefaultRooms_1 = require("../../../leftpane/overlay/BchatJoinableDefaultRooms");
const conversations_1 = require("../../../../state/selectors/conversations");
const moment_1 = __importDefault(require("moment"));
const MessageContent_1 = require("../message-content/MessageContent");
const IncomingMsgTailIcon_1 = __importDefault(require("../../../icon/IncomingMsgTailIcon"));
const OutgoingMsgTailIcon_1 = __importDefault(require("../../../icon/OutgoingMsgTailIcon"));
const BchatMessagesListContainer_1 = require("../../BchatMessagesListContainer");
const GroupInvitation = (props) => {
    const { messageId, receivedAt, isUnread, serverName, acceptUrl } = props;
    const [flashGreen, setFlashGreen] = (0, react_1.useState)(false);
    const [didScroll, setDidScroll] = (0, react_1.useState)(false);
    const scrollToLoadedMessage = (0, react_1.useContext)(BchatMessagesListContainer_1.ScrollToLoadedMessageContext);
    const joinableRooms = (0, react_redux_1.useSelector)((state) => state.defaultRooms);
    const contentProps = (0, react_redux_1.useSelector)(state => (0, conversations_1.getMessageContentSelectorProps)(state, props.messageId));
    const quotedMessageToAnimate = (0, react_redux_1.useSelector)(conversations_1.getQuotedMessageToAnimate);
    const shouldHighlightMessage = (0, react_redux_1.useSelector)(conversations_1.getShouldHighlightMessage);
    const isQuotedMessageToAnimate = quotedMessageToAnimate === props.messageId;
    (0, react_1.useLayoutEffect)(() => {
        if (isQuotedMessageToAnimate) {
            if (!flashGreen && !didScroll) {
                scrollToLoadedMessage(props.messageId, 'quote-or-search-result');
                setDidScroll(true);
                if (shouldHighlightMessage) {
                    setFlashGreen(true);
                }
            }
            return;
        }
        if (flashGreen) {
            setFlashGreen(false);
        }
        if (didScroll) {
            setDidScroll(false);
        }
        return;
    });
    if (!serverName) {
        return null;
    }
    const socialGrp = joinableRooms.rooms.filter((item) => props.serverName === item.name);
    const isIncoming = contentProps?.direction === 'incoming';
    const classes = [`group-invitation ${flashGreen && 'flash-green-once'}`];
    if (contentProps?.direction === 'outgoing') {
        classes.push('invitation-outgoing');
    }
    const socialGroupInvitation = window.i18n('socialGroupInvitation');
    const selected = (0, react_redux_1.useSelector)(state => (0, conversations_1.getMessageStatusProps)(state, props.messageId));
    if (!selected) {
        return null;
    }
    const recentEmojiBtnVisible = () => props.onRecentEmojiBtnVisible && props.onRecentEmojiBtnVisible();
    return (react_1.default.createElement(ReadableMessage_1.ReadableMessage, { messageId: messageId, receivedAt: receivedAt, isUnread: isUnread, key: `readable-message-${messageId}` },
        react_1.default.createElement("div", { className: (0, classnames_1.default)(`group-invitation-container group-invitation-container-${contentProps?.direction}`), id: `msg-${props.messageId}`, onMouseEnter: () => {
                recentEmojiBtnVisible();
            } },
            react_1.default.createElement("div", { style: { position: 'relative' } },
                contentProps?.lastMessageOfSeries && isIncoming && (react_1.default.createElement(MessageContent_1.StyledSvgWrapper, null,
                    react_1.default.createElement(IncomingMsgTailIcon_1.default, null))),
                react_1.default.createElement("div", { className: (0, classnames_1.default)(`inviteWrapper-${contentProps?.direction}`) },
                    react_1.default.createElement("div", { className: (0, classnames_1.default)(classes), onClick: () => {
                            (0, messageInteractions_1.acceptOpenGroupInvitation)(acceptUrl, serverName);
                        } },
                        react_1.default.createElement("div", { className: "group-details" },
                            react_1.default.createElement(Flex_1.Flex, { container: true },
                                react_1.default.createElement(exports.VerticalLine, { direcrion: contentProps?.direction }),
                                react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column", cursor: "pointer" },
                                    react_1.default.createElement("span", { className: "group-name", style: { fontSize: `${(0, exports.FontSizeChanger)(18)}px` } }, serverName),
                                    react_1.default.createElement("span", { className: "group-type", style: { fontSize: `${(0, exports.FontSizeChanger)(14)}px` } }, socialGroupInvitation))),
                            react_1.default.createElement(BchatJoinableDefaultRooms_1.BchatJoinableRoomAvatar, { completeUrl: socialGrp[0]?.completeUrl, name: socialGrp[0]?.name, roomId: socialGrp[0]?.id, base64Data: socialGrp[0]?.base64Data, onClick: () => {
                                    (0, messageInteractions_1.acceptOpenGroupInvitation)(acceptUrl, props.serverName);
                                }, direction: contentProps?.direction })),
                        react_1.default.createElement(Text_1.SpacerSM, null),
                        react_1.default.createElement("span", { className: "group-address", style: { fontSize: `${(0, exports.FontSizeChanger)(14)}px` } }, props.url),
                        react_1.default.createElement("div", { className: (0, classnames_1.default)('timeStamp', `timeStamp-${contentProps?.direction}`) }, (0, moment_1.default)(contentProps?.timestamp).format('hh:mm A')))),
                contentProps?.lastMessageOfSeries && !isIncoming && (react_1.default.createElement(MessageContent_1.StyledSvgWrapper, { style: { right: 0 } },
                    react_1.default.createElement(OutgoingMsgTailIcon_1.default, null)))))));
};
exports.GroupInvitation = GroupInvitation;
exports.VerticalLine = styled_components_1.default.div `
  width: 5px;
  background-color: ${props => props.direcrion === 'incoming' ? 'var(--color-untrusted-vertical-bar)' : ' #f0f0f0'};
  height: 60px;
  border-radius: 10px;
  margin-right: 10px;
`;
const FontSizeChanger = (fontSize) => {
    const currentValueFromSettings = window.getSettingValue('font-size-setting') || 'Small';
    let size;
    if (currentValueFromSettings === 'Small') {
        size = fontSize;
    }
    else if (currentValueFromSettings === 'Medium') {
        size = fontSize + 2;
    }
    else {
        size = fontSize + 4;
    }
    return size;
};
exports.FontSizeChanger = FontSizeChanger;
