"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageMoreInfoModal = void 0;
const react_1 = __importDefault(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const moment_1 = __importDefault(require("moment"));
const Message_1 = require("./Message");
const Avatar_1 = require("../../../avatar/Avatar");
const ContactName_1 = require("../../ContactName");
const BchatWrapperModal_1 = require("../../../BchatWrapperModal");
const react_redux_1 = require("react-redux");
const modalDialog_1 = require("../../../../state/ducks/modalDialog");
const Text_1 = require("../../../basic/Text");
const conversations_1 = require("../../../../state/selectors/conversations");
const AvatarItem = (props) => {
    const { pubkey } = props;
    return react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.L, pubkey: pubkey });
};
const ContactsItem = (props) => {
    const { contacts } = props;
    if (!contacts || !contacts.length) {
        return null;
    }
    return (react_1.default.createElement("div", { className: "module-message-detail__contact-container" }, contacts.map(contact => (react_1.default.createElement(ContactItem, { key: contact.pubkey, contact: contact })))));
};
const ContactItem = (props) => {
    const { contact } = props;
    const errors = contact.errors || [];
    const statusComponent = !contact.isOutgoingKeyError ? (react_1.default.createElement("div", { className: (0, classnames_1.default)('module-message-detail__contact__status-icon', `module-message-detail__contact__status-icon--${contact.status}`) })) : null;
    return (react_1.default.createElement("div", { key: contact.pubkey, className: "module-message-detail__contact" },
        react_1.default.createElement(AvatarItem, { pubkey: contact.pubkey }),
        react_1.default.createElement("div", { className: "module-message-detail__contact__text" },
            react_1.default.createElement("div", { className: "module-message-detail__contact__name" },
                react_1.default.createElement(ContactName_1.ContactName, { pubkey: contact.pubkey, name: contact.name, profileName: contact.profileName, shouldShowPubkey: true })),
            errors.map((error, index) => (react_1.default.createElement("div", { key: index, className: "module-message-detail__contact__error" }, error.message)))),
        statusComponent));
};
const MessageMoreInfoModal = (props) => {
    const { i18n } = window;
    const dispatch = (0, react_redux_1.useDispatch)();
    const { errors, receivedAt, sentAt, direction, messageId, contacts } = props;
    const contactlist = contacts.length ? [contacts[0]] : contacts;
    const messagesProps = (0, react_redux_1.useSelector)(conversations_1.getSortedMessagesTypesOfSelectedConversation);
    const sharedContactMessage = messagesProps.find((item) => item.message.props.messageId === messageId);
    const isSharedContact = sharedContactMessage?.message.messageType === "shared-contact";
    const contactInfo = isSharedContact
        ? {
            name: sharedContactMessage.message.props.name,
            address: sharedContactMessage.message.props.address
        }
        : null;
    if (!props) {
        return null;
    }
    return (react_1.default.createElement("div", { className: "message-detail-wrapper" },
        react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { title: 'More Info', onClose: () => { dispatch((0, modalDialog_1.updateMessageMoreInfoModal)(null)); }, showExitIcon: false, showHeader: true, headerReverse: false, okButton: {
                text: 'Close',
                onClickOkHandler: () => { dispatch((0, modalDialog_1.updateMessageMoreInfoModal)(null)); },
                disabled: false,
            } },
            react_1.default.createElement(Text_1.SpacerSM, null),
            react_1.default.createElement("div", { className: "module-message-detail" },
                react_1.default.createElement("div", null,
                    react_1.default.createElement(Message_1.Message, { messageId: messageId, isDetailView: true, address: contactInfo?.address, name: contactInfo?.name })),
                react_1.default.createElement(Text_1.SpacerSM, null),
                react_1.default.createElement("table", { className: "module-message-detail__info" },
                    react_1.default.createElement("tbody", null,
                        (errors || []).map((error, index) => (react_1.default.createElement("tr", { key: index },
                            react_1.default.createElement("td", { className: "module-message-detail__label" }, i18n('error')),
                            react_1.default.createElement("td", null,
                                ' ',
                                react_1.default.createElement("span", { className: "error-message" }, error.message),
                                ' ')))),
                        react_1.default.createElement("tr", null,
                            react_1.default.createElement("td", { className: "module-message-detail__label" }, i18n('send')),
                            react_1.default.createElement("td", { className: "module-message-detail__label", style: { paddingLeft: '10px' } }, (0, moment_1.default)(sentAt).format('LLLL'))),
                        receivedAt ? (react_1.default.createElement("tr", null,
                            react_1.default.createElement("td", { className: "module-message-detail__label" }, i18n('received')),
                            react_1.default.createElement("td", { className: "module-message-detail__label", style: { paddingLeft: '10px' } }, (0, moment_1.default)(receivedAt).format('LLLL')))) : null)),
                react_1.default.createElement(Text_1.SpacerSM, null),
                props.contacts.length ? (react_1.default.createElement("div", { className: 'module-message-detail__direction_label' },
                    " ",
                    direction === 'incoming' ? i18n('from') : i18n('to'))) : null,
                react_1.default.createElement(Text_1.SpacerXS, null),
                react_1.default.createElement(ContactsItem, { contacts: contactlist })))));
};
exports.MessageMoreInfoModal = MessageMoreInfoModal;
