"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PaymentMessage = void 0;
const react_1 = __importStar(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const ReadableMessage_1 = require("./ReadableMessage");
const icon_1 = require("../../../icon");
const common_1 = require("electron/common");
const react_redux_1 = require("react-redux");
const conversations_1 = require("../../../../state/selectors/conversations");
const Flex_1 = require("../../../basic/Flex");
const moment_1 = __importDefault(require("moment"));
const MessageContent_1 = require("../message-content/MessageContent");
const IncomingMsgTailIcon_1 = __importDefault(require("../../../icon/IncomingMsgTailIcon"));
const OutgoingMsgTailIcon_1 = __importDefault(require("../../../icon/OutgoingMsgTailIcon"));
const BchatMessagesListContainer_1 = require("../../BchatMessagesListContainer");
const PaymentMessage = (props) => {
    const { messageId, receivedAt, isUnread, direction, amount, txnId } = props;
    const [flashGreen, setFlashGreen] = (0, react_1.useState)(false);
    const [didScroll, setDidScroll] = (0, react_1.useState)(false);
    const scrollToLoadedMessage = (0, react_1.useContext)(BchatMessagesListContainer_1.ScrollToLoadedMessageContext);
    const quotedMessageToAnimate = (0, react_redux_1.useSelector)(conversations_1.getQuotedMessageToAnimate);
    const shouldHighlightMessage = (0, react_redux_1.useSelector)(conversations_1.getShouldHighlightMessage);
    const isQuotedMessageToAnimate = quotedMessageToAnimate === props.messageId;
    const classes = [`payment ${flashGreen && 'flash-green-once'}`];
    const currentValueFromSettings = window.getSettingValue('font-size-setting') || 'Small';
    const contentProps = (0, react_redux_1.useSelector)(state => (0, conversations_1.getMessageContentSelectorProps)(state, props.messageId));
    const isIncoming = direction === 'incoming';
    (0, react_1.useLayoutEffect)(() => {
        if (isQuotedMessageToAnimate) {
            if (!flashGreen && !didScroll) {
                scrollToLoadedMessage(props.messageId, 'quote-or-search-result');
                setDidScroll(true);
                if (shouldHighlightMessage) {
                    setFlashGreen(true);
                }
            }
            return;
        }
        if (flashGreen) {
            setFlashGreen(false);
        }
        if (didScroll) {
            setDidScroll(false);
        }
        return;
    });
    if (!amount) {
        return null;
    }
    if (props.direction === 'outgoing') {
        classes.push('invitation-outgoing');
    }
    const recentEmojiBtnVisible = () => props.onRecentEmojiBtnVisible && props.onRecentEmojiBtnVisible();
    function openToExplore(traxId) {
        if (window.networkType === 'mainnet') {
            void common_1.shell.openExternal(`http://explorer.beldex.io/tx/${traxId}`);
        }
        else {
            void common_1.shell.openExternal(`http://154.26.139.105/tx/${traxId}`);
        }
    }
    function FontSizeChanger(fontSize) {
        let size;
        if (currentValueFromSettings === 'Small') {
            size = fontSize;
        }
        else if (currentValueFromSettings === 'Medium') {
            size = fontSize + 2;
        }
        else {
            size = fontSize + 4;
        }
        return size;
    }
    function HindTxt() {
        const iconColor = 'var(--color-text)';
        if (props.messageId === '1234-567-7890') {
            return (react_1.default.createElement(Flex_1.Flex, { container: true, alignItems: "center" },
                react_1.default.createElement("span", { className: "txn-status" }, "Initiating transaction"),
                react_1.default.createElement(icon_1.BchatIcon, { rotateDuration: 2, iconColor: iconColor, iconType: "loading", iconSize: "tiny" })));
        }
        else if (props.direction === 'outgoing') {
            return (react_1.default.createElement(Flex_1.Flex, { container: true, alignItems: "center" },
                react_1.default.createElement("span", { className: "txn-status" }, "Sent Successfully!"),
                react_1.default.createElement(icon_1.BchatIcon, { iconColor: '#f0f0f0', iconType: "circleWithTick", iconSize: 16 })));
        }
        else {
            return (react_1.default.createElement(Flex_1.Flex, { container: true, alignItems: "center", color: "#108D32" },
                react_1.default.createElement("span", { className: "txn-status", style: { color: '#108D32' } }, "Received Successfully!"),
                react_1.default.createElement(icon_1.BchatIcon, { iconColor: '#108D32', iconType: "circleWithTick", iconSize: 16 })));
        }
    }
    return (react_1.default.createElement(ReadableMessage_1.ReadableMessage, { messageId: messageId, receivedAt: receivedAt, isUnread: isUnread, key: `readable-message-${messageId}` },
        react_1.default.createElement("div", { className: (0, classnames_1.default)(`group-invitation-container group-invitation-container-${direction}`), id: `msg-${props.messageId}`, onMouseEnter: () => {
                recentEmojiBtnVisible();
            } },
            react_1.default.createElement("div", { style: { position: 'relative' } },
                contentProps?.lastMessageOfSeries && isIncoming && (react_1.default.createElement(MessageContent_1.StyledSvgWrapper, null,
                    react_1.default.createElement(IncomingMsgTailIcon_1.default, null))),
                react_1.default.createElement("div", { className: (0, classnames_1.default)(`payment-Wrapper-${direction}`) },
                    react_1.default.createElement("div", { className: (0, classnames_1.default)(classes), onClick: () => (txnId ? openToExplore(txnId) : ''), style: { cursor: txnId ? 'pointer' : 'unset' } },
                        react_1.default.createElement("div", { className: direction === 'outgoing' ? 'contents' : 'contents-incoming' },
                            react_1.default.createElement("div", null,
                                react_1.default.createElement(icon_1.BchatIcon, { iconType: 'borderWithBeldex', iconSize: 34 })),
                            react_1.default.createElement("div", { className: "amount", style: { fontSize: `${FontSizeChanger(24)}px` } },
                                amount,
                                " BDX")),
                        react_1.default.createElement("div", { className: props.direction === 'outgoing' ? 'hint-out' : 'hintTxt', style: { fontSize: `${FontSizeChanger(12)}px` } },
                            react_1.default.createElement(HindTxt, null)),
                        react_1.default.createElement("div", { className: (0, classnames_1.default)('timeStamp', `timeStamp-${direction}`) }, (0, moment_1.default)(contentProps?.timestamp).format('hh:mm A')))),
                contentProps?.lastMessageOfSeries && !isIncoming && (react_1.default.createElement(MessageContent_1.StyledSvgWrapper, { style: { right: 0 } },
                    react_1.default.createElement(OutgoingMsgTailIcon_1.default, null)))))));
};
exports.PaymentMessage = PaymentMessage;
