"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SharedContactCardMessage = void 0;
const react_1 = __importStar(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const conversations_1 = require("../../../../state/ducks/conversations");
const ReadableMessage_1 = require("./ReadableMessage");
const Flex_1 = require("../../../basic/Flex");
const react_redux_1 = require("react-redux");
const conversations_2 = require("../../../../state/selectors/conversations");
const moment_1 = __importDefault(require("moment"));
const MessageContent_1 = require("../message-content/MessageContent");
const IncomingMsgTailIcon_1 = __importDefault(require("../../../icon/IncomingMsgTailIcon"));
const OutgoingMsgTailIcon_1 = __importDefault(require("../../../icon/OutgoingMsgTailIcon"));
const BchatMessagesListContainer_1 = require("../../BchatMessagesListContainer");
const GroupInvitation_1 = require("./GroupInvitation");
const Avatar_1 = require("../../../avatar/Avatar");
const styled_components_1 = __importDefault(require("styled-components"));
const icon_1 = require("../../../icon");
const MessageQuote_1 = require("../message-content/MessageQuote");
const conversations_3 = require("../../../../bchat/conversations");
const conversation_1 = require("../../../../models/conversation");
const modalDialog_1 = require("../../../../state/ducks/modalDialog");
const BchatButton_1 = require("../../../basic/BchatButton");
const useParamSelector_1 = require("../../../../hooks/useParamSelector");
const theme_1 = require("../../../../state/selectors/theme");
const Text_1 = require("../../../basic/Text");
const SharedContactCardMessage = (props) => {
    const { messageId, receivedAt, isUnread, address, name, isDetailView, onRecentEmojiBtnVisible, } = props;
    const dispatch = (0, react_redux_1.useDispatch)();
    const [flashGreen, setFlashGreen] = (0, react_1.useState)(false);
    const [didScroll, setDidScroll] = (0, react_1.useState)(false);
    const scrollToLoadedMessage = (0, react_1.useContext)(BchatMessagesListContainer_1.ScrollToLoadedMessageContext);
    const contentProps = (0, react_redux_1.useSelector)(state => (0, conversations_2.getMessageContentSelectorProps)(state, props.messageId));
    const quotedMessageToAnimate = (0, react_redux_1.useSelector)(conversations_2.getQuotedMessageToAnimate);
    const shouldHighlightMessage = (0, react_redux_1.useSelector)(conversations_2.getShouldHighlightMessage);
    const isDarkAndMoreInfo = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark' && isDetailView && contentProps?.direction === 'incoming';
    const isQuotedMessageToAnimate = quotedMessageToAnimate === props.messageId;
    const sharedContactNameList = JSON.parse(name || '[]');
    const sharedContactAddressList = JSON.parse(address || '[]');
    const validUserName = sharedContactNameList[0].length === 66
        ? sharedContactNameList[0].slice(0, 17) + '...'
        : sharedContactNameList[0];
    const userName = sharedContactNameList.length > 1
        ? `${validUserName} and ${sharedContactNameList.length - 1} other${sharedContactNameList.length > 2 ? 's' : ''}`
        : validUserName ?? '';
    (0, react_1.useLayoutEffect)(() => {
        if (isQuotedMessageToAnimate) {
            if (!flashGreen && !didScroll) {
                scrollToLoadedMessage(props.messageId, 'quote-or-search-result');
                setDidScroll(true);
                if (shouldHighlightMessage) {
                    setFlashGreen(true);
                }
            }
            return;
        }
        if (flashGreen) {
            setFlashGreen(false);
        }
        if (didScroll) {
            setDidScroll(false);
        }
        return;
    });
    const isIncoming = contentProps?.direction === 'incoming';
    const viewContactBtnText = sharedContactNameList.length >= 2 ? 'viewAll' : 'viewMessage';
    const strokeColor = contentProps?.direction == 'outgoing' ? '#F0F0F0' : 'var(--color-text)';
    const classes = [`group-invitation ${flashGreen && 'flash-green-once'}`];
    if (contentProps?.direction === 'outgoing') {
        classes.push('invitation-outgoing');
    }
    const selected = (0, react_redux_1.useSelector)(state => (0, conversations_2.getMessageStatusProps)(state, props.messageId));
    if (!address) {
        return null;
    }
    if (!selected) {
        return null;
    }
    function formatAddress(address) {
        if (!address || address.length <= 16)
            return address;
        return `${address.slice(0, 10)}.......${address.slice(-8)}`;
    }
    const openConverstation = async (pubKey) => {
        await (0, conversations_3.getConversationController)().getOrCreateAndWait(pubKey, conversation_1.ConversationTypeEnum.PRIVATE);
        await (0, conversations_1.openConversationWithMessages)({ conversationKey: pubKey, messageId: null });
    };
    const shortAddress = formatAddress(sharedContactAddressList[0]);
    const recentEmojiBtnVisible = () => onRecentEmojiBtnVisible && onRecentEmojiBtnVisible();
    const updatePanel = async () => {
        if (sharedContactNameList.length > 1) {
            dispatch((0, conversations_1.updateViewContactPanel)({
                isIncoming: isIncoming,
                names: sharedContactNameList,
                addresses: sharedContactAddressList,
            }));
        }
        else {
            if (contentProps?.direction == 'outgoing') {
                return openConverstation(sharedContactAddressList[0]);
            }
            return dispatch((0, modalDialog_1.updateConfirmModal)({
                bchatIcon: 'avatar',
                iconSize: 31,
                iconShow: true,
                title: 'Start chat now?',
                message: 'Do you want to chat with this contact now?',
                onClickOk: () => openConverstation(sharedContactAddressList[0]),
                okText: 'Start Chatting',
                okTheme: BchatButton_1.BchatButtonColor.Primary,
            }));
        }
    };
    return (react_1.default.createElement(ReadableMessage_1.ReadableMessage, { messageId: messageId, receivedAt: receivedAt, isUnread: isUnread, key: `readable-message-${messageId}` },
        react_1.default.createElement("div", { className: (0, classnames_1.default)(`group-invitation-container group-invitation-container-${contentProps?.direction}`), id: `msg-${props.messageId}`, onMouseEnter: () => {
                recentEmojiBtnVisible();
            } },
            react_1.default.createElement("div", { style: { position: 'relative' } },
                contentProps?.lastMessageOfSeries && isIncoming && !isDetailView && (react_1.default.createElement(MessageContent_1.StyledSvgWrapper, null,
                    react_1.default.createElement(IncomingMsgTailIcon_1.default, null))),
                react_1.default.createElement("div", { className: (0, classnames_1.default)(`inviteWrapper-${contentProps?.direction}`) },
                    react_1.default.createElement(SharedContactWrapper, { className: (0, classnames_1.default)(classes), isDarkAndMoreInfo: isDarkAndMoreInfo },
                        react_1.default.createElement(ContactMessageWrapper, null,
                            react_1.default.createElement(MessageQuote_1.MessageQuote, { messageId: props.messageId }),
                            react_1.default.createElement("div", { className: "group-details" },
                                react_1.default.createElement(Flex_1.Flex, { container: true },
                                    react_1.default.createElement(GroupInvitation_1.VerticalLine, { direcrion: contentProps?.direction }),
                                    react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column", justifyContent: "center" },
                                        react_1.default.createElement(UserNameWrapper, { className: "group-name", style: { fontSize: `${(0, GroupInvitation_1.FontSizeChanger)(18)}px` } },
                                            react_1.default.createElement(icon_1.BchatIcon, { iconType: 'avatarOutline', iconSize: 13, strokeWidth: '1px', strokeColor: strokeColor, iconColor: strokeColor }),
                                            userName),
                                        react_1.default.createElement("span", { className: "group-type", style: { fontSize: `${(0, GroupInvitation_1.FontSizeChanger)(14)}px`, marginTop: '5px' } }, shortAddress))),
                                react_1.default.createElement(CustomizedAvatar, { address: sharedContactAddressList })),
                            react_1.default.createElement(Text_1.SpacerSM, null),
                            !isDetailView && (react_1.default.createElement("div", { className: (0, classnames_1.default)('timeStamp', `timeStamp-${contentProps?.direction}`) }, (0, moment_1.default)(contentProps?.timestamp).format('hh:mm A')))),
                        react_1.default.createElement("div", { className: "view-Contact", onClick: updatePanel },
                            react_1.default.createElement("div", null, window.i18n(viewContactBtnText))))),
                contentProps?.lastMessageOfSeries && !isIncoming && !isDetailView && (react_1.default.createElement(MessageContent_1.StyledSvgWrapper, { style: { right: 0 } },
                    react_1.default.createElement(OutgoingMsgTailIcon_1.default, null)))))));
};
exports.SharedContactCardMessage = SharedContactCardMessage;
const CustomizedAvatar = ({ address = [] }) => {
    if (address.length === 0)
        return null;
    const isBnsHolder = address.map(addr => (0, useParamSelector_1.useConversationBnsHolder)(addr));
    const [first, second] = address;
    return (react_1.default.createElement(Wrapper, { className: "grouped-avatar" }, address.length === 1 ? (react_1.default.createElement(Avatar_1.Avatar, { pubkey: first, size: Avatar_1.AvatarSize.L, isBnsHolder: isBnsHolder[0] })) : (react_1.default.createElement("div", { className: "inner-wrapper" },
        react_1.default.createElement(Avatar_1.Avatar, { pubkey: first, size: Avatar_1.AvatarSize.S, isBnsHolder: isBnsHolder[0] }),
        react_1.default.createElement(Avatar_1.Avatar, { pubkey: second, size: Avatar_1.AvatarSize.S, isBnsHolder: isBnsHolder[1] })))));
};
const Wrapper = styled_components_1.default.div `
  position: relative;
  margin-left: 10px;

  .inner-wrapper {
    display: flex;
    position: relative;

    .bns-verify-wrapper:first-child {
      z-index: 1;
      box-shadow: 1px 1px 2px 0px var(--color-chatHeader);
      position: absolute;
      right: 9px;
      bottom: 10px;
      border-radius: 14px;
    }
  }
`;
const SharedContactWrapper = styled_components_1.default.div `
  padding: 0;
  background-color: ${props => (props.isDarkAndMoreInfo ? '#202329' : '')};
  cursor: unset !important;
  .group-details {
    cursor: unset !important;
  }
`;
const ContactMessageWrapper = styled_components_1.default.div `
  padding: 15px;
  padding-bottom: 6px;
`;
const UserNameWrapper = styled_components_1.default.div `
    word-break: break-all;
    text-transform: capitalize;
    svg{
    margin-right:5px;
    }

`;
