"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CallNotification = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const conversations_1 = require("../../../../../state/selectors/conversations");
const icon_1 = require("../../../../icon");
const ReadableMessage_1 = require("../ReadableMessage");
const classnames_1 = __importDefault(require("classnames"));
const MessageContentWithStatus_1 = require("../../message-content/MessageContentWithStatus");
const Text_1 = require("../../../../basic/Text");
const moment_1 = __importDefault(require("moment"));
const Flex_1 = require("../../../../basic/Flex");
const GroupInvitation_1 = require("../GroupInvitation");
const IncomingMsgTailIcon_1 = __importDefault(require("../../../../icon/IncomingMsgTailIcon"));
const MessageContent_1 = require("../../message-content/MessageContent");
const OutgoingMsgTailIcon_1 = __importDefault(require("../../../../icon/OutgoingMsgTailIcon"));
const styled_components_1 = __importDefault(require("styled-components"));
const style = {
    'missed-call': {
        notificationTextKey: 'callMissed',
        iconType: 'callMissed',
        iconColor: '#FF3E3E',
        bgColor: 'transparent',
    },
    'started-call': {
        notificationTextKey: 'startedACall',
        iconType: 'callOutgoing',
        iconColor: '#FFFFFF',
        bgColor: 'transparent',
    },
    'answered-a-call': {
        notificationTextKey: 'answeredACall',
        iconType: 'callIncoming',
        iconColor: '#108D32',
        bgColor: 'transparent',
    },
};
const StyledDiv = styled_components_1.default.div `
 margin-top:5px;
`;
const CallNotification = (props) => {
    const { messageId, receivedAt, isUnread, notificationType } = props;
    const contentProps = (0, react_redux_1.useSelector)(state => (0, conversations_1.getMessageContentSelectorProps)(state, messageId));
    const direction = contentProps?.direction;
    const timestamp = contentProps?.timestamp;
    const styleItem = style[notificationType];
    const notificationText = window.i18n(styleItem.notificationTextKey);
    const isIncoming = direction === 'incoming';
    if (!window.i18n(styleItem.notificationTextKey)) {
        throw new Error(`invalid i18n key ${styleItem.notificationTextKey}`);
    }
    const iconType = styleItem.iconType;
    const iconColor = styleItem.iconColor;
    return (react_1.default.createElement(ReadableMessage_1.ReadableMessage, { messageId: messageId, receivedAt: receivedAt, isUnread: isUnread, key: `readable-message-${messageId}` },
        react_1.default.createElement(StyledDiv, null,
            react_1.default.createElement(MessageContentWithStatus_1.StyledMessageContentContainer, { direction: direction === 'incoming' ? 'left' : 'right' },
                react_1.default.createElement("div", { className: (0, classnames_1.default)('module-message', `module-message--${direction}`), role: "button", style: direction === 'incoming' ? { paddingLeft: '15px' } : { paddingRight: '15px' } },
                    react_1.default.createElement("div", { style: { position: 'relative' } },
                        contentProps?.lastMessageOfSeries && isIncoming && (react_1.default.createElement(MessageContent_1.StyledSvgWrapper, { className: 'incomingTail' },
                            react_1.default.createElement(IncomingMsgTailIcon_1.default, null))),
                        react_1.default.createElement("div", { className: (0, classnames_1.default)('module-message__container', `module-message__container--${direction}`, `module-message__container--${direction}--opaque`), style: { padding: '10px' } },
                            react_1.default.createElement(Flex_1.Flex, { container: true, className: "call-notify-content-wrapper", justifyContent: "center", alignItems: "center" },
                                react_1.default.createElement(GroupInvitation_1.VerticalLine, { direcrion: contentProps?.direction }),
                                react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column", width: "120px" },
                                    react_1.default.createElement("span", { className: "group-name", style: { fontSize: `${(0, GroupInvitation_1.FontSizeChanger)(16)}px`, fontWeight: 600, color: direction == 'outgoing' ? '#F0F0F0' : 'var(--color-text)' } }, notificationText),
                                    react_1.default.createElement("span", { className: "group-type", style: { fontSize: `${(0, GroupInvitation_1.FontSizeChanger)(14)}px` } })),
                                react_1.default.createElement("div", { className: "icon-wrapper" },
                                    react_1.default.createElement(icon_1.BchatIcon, { iconType: iconType, iconSize: 24, iconColor: iconColor }))),
                            react_1.default.createElement(Text_1.SpacerSM, null),
                            react_1.default.createElement("div", { className: "timeStamp", style: { marginTop: 0 } }, (0, moment_1.default)(timestamp).format('hh:mm A'))),
                        contentProps?.lastMessageOfSeries && !isIncoming && (react_1.default.createElement(MessageContent_1.StyledSvgWrapper, { style: { right: 0 }, className: 'outgoingTail' },
                            react_1.default.createElement(OutgoingMsgTailIcon_1.default, null)))))))));
};
exports.CallNotification = CallNotification;
