"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Reaction = void 0;
const react_1 = __importStar(require("react"));
const utils_1 = require("../../../../bchat/utils");
const abbreviateNumber_1 = require("../../../../util/abbreviateNumber");
const emoji_1 = require("../../../../util/emoji");
const styled_components_1 = __importDefault(require("styled-components"));
const react_use_1 = require("react-use");
const MessageReactions_1 = require("../message-content/MessageReactions");
const ReactionPopup_1 = require("./ReactionPopup");
const reactions_1 = require("../../../../util/reactions");
const StyledReaction = styled_components_1.default.button `
  display: flex;
  justify-content: ${props => (props.showCount ? 'flex-start' : 'center')};
  align-items: center;

  // background-color: var(--color-received-message-background);
  // border-width: 1px;
  // border-style: solid;
  // border-color: ${props => (props.selected ? 'var(--color-accent)' : 'transparent')};
  // border-radius: 11px;
    box-sizing: border-box;
   
    border: unset;
    font-size:19px;
    padding: 2px 10px;

    border-radius: 17px;
    border:${props => (!props.inModal || props.iscurrentReact ? '0.5px solid #858598' : '')};
    background:${props => (props.inModal && props.iscurrentReact) || !props.inModal
    ? 'var(--color-emoji-panel-bg)'
    : ''};
    margin-right:7px;
    // width:;
    
    min-width:${props => (props.inModal ? '70px' : 'unset')};
    max-width: ${props => (props.inModal ? '100px' : 'unset')};

  span:nth-child(2) {
    font-size: var(--font-size-sm);
    color: #A7A7BA;
    text-align: center;
    font-weight: 600;

  }
`;
const StyledReactionContainer = styled_components_1.default.div `
  position: relative;
`;
const Reaction = (props) => {
    const { emoji, messageId, reactions, inModal, inGroup, handlePopupX, handlePopupY, onClick, popupReaction, onSelected, handlePopupReaction, handlePopupClick, iscurrentReact, } = props;
    const reactionsMap = (reactions && Object.fromEntries(reactions)) || {};
    const senders = reactionsMap[emoji].senders ? Object.keys(reactionsMap[emoji].senders) : [];
    const count = reactionsMap[emoji].count;
    const showCount = count !== undefined && count > 1;
    const reactionRef = (0, react_1.useRef)(null);
    const { docX, elW } = (0, react_use_1.useMouse)(reactionRef);
    const gutterWidth = 380;
    const tooltipMidPoint = 108;
    const me = utils_1.UserUtils.getOurPubKeyStrFromCache();
    const isBlindedMe = senders &&
        senders.length > 0 &&
        senders.filter(sender => sender.startsWith('bd') && (0, reactions_1.isUsAnySogsFromCache)(sender)).length > 0;
    const selected = () => {
        if (onSelected) {
            return onSelected(emoji);
        }
        return senders && senders.length > 0 && (senders.includes(me) || isBlindedMe);
    };
    const handleReactionClick = () => {
        onClick(emoji);
    };
    return (react_1.default.createElement(StyledReactionContainer, { ref: reactionRef },
        react_1.default.createElement(StyledReaction, { showCount: showCount, selected: selected(), inModal: inModal, onClick: () => {
                handleReactionClick();
            }, className: "emoji-reacts", iscurrentReact: iscurrentReact === emoji, onMouseEnter: () => {
                const { innerWidth: windowWidth } = window;
                if (handlePopupReaction) {
                    if (docX + tooltipMidPoint > windowWidth) {
                        handlePopupX(Math.abs(MessageReactions_1.popupXDefault) * 1.5 * -1);
                    }
                    else if (docX - elW <= gutterWidth + tooltipMidPoint) {
                        const offset = -12.5;
                        handlePopupX(offset);
                    }
                    else {
                        handlePopupX(MessageReactions_1.popupXDefault);
                    }
                    handlePopupReaction(emoji);
                }
            } },
            react_1.default.createElement("span", { role: 'img', "aria-label": emoji_1.nativeEmojiData?.ariaLabels ? emoji_1.nativeEmojiData.ariaLabels[emoji] : undefined }, emoji),
            showCount && react_1.default.createElement("span", null, `\u00A0\u00A0${(0, abbreviateNumber_1.abbreviateNumber)(count)}`)),
        popupReaction && popupReaction === emoji && (react_1.default.createElement(ReactionPopup_1.ReactionPopup, { messageId: messageId, emoji: popupReaction, senders: Object.keys(reactionsMap[popupReaction].senders), onClick: () => {
                if (inGroup) {
                    if (handlePopupReaction) {
                        handlePopupReaction('');
                    }
                    handlePopupX(MessageReactions_1.popupXDefault);
                    handlePopupY(MessageReactions_1.popupYDefault);
                    if (handlePopupClick) {
                        handlePopupClick();
                    }
                }
            } }))));
};
exports.Reaction = Reaction;
