"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AboutBnsDialog = void 0;
const react_1 = __importDefault(require("react"));
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const AboutBnsDialog = () => {
    function closeDialog() {
        window.inboxStore?.dispatch((0, modalDialog_1.updateAboutBnsModal)(null));
        window.inboxStore?.dispatch((0, modalDialog_1.editProfileModal)({}));
    }
    return (react_1.default.createElement("div", { className: "about-bns" },
        react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { showHeader: true, onClose: closeDialog, showExitIcon: false, isloading: false, title: "About BNS", okButton: {
                text: window.i18n('close'),
                onClickOkHandler: closeDialog,
            } },
            react_1.default.createElement("section", null,
                react_1.default.createElement("article", null,
                    react_1.default.createElement("div", { className: "about-bns-header" }, "BNS: Your Decentralized Identity in the Beldex Ecosystem ?"),
                    react_1.default.createElement("div", { className: "about-bns-txt" }, "BNS (Beldex Name Service) is your gateway to a seamless experience within the Beldex ecosystem. With BNS, you can create a unique, easy-to-remember name that links to your various Beldex identities."),
                    react_1.default.createElement("div", { className: "about-bns-header" }, "Key Benefits:"),
                    react_1.default.createElement("ul", null,
                        react_1.default.createElement("li", { className: "about-bns-txt" }, "Unified Identity: Connect your BChat ID, Beldex Wallet Address, and BelNet ID to a single BNS name. This simplifies your interactions across the Beldex ecosystem."),
                        react_1.default.createElement("li", { className: "about-bns-txt" }, "Ease of Use: Say goodbye to complicated alphanumeric strings. With your BNS name, messaging and transactions become straightforward and user-friendly."),
                        react_1.default.createElement("li", { className: "about-bns-txt" }, "Badge of Trust: Link your BChat ID to your BNS name and complete the verification process to earn a BNS badge. This badge adds a layer of trust and recognition within the community.")),
                    react_1.default.createElement("div", { className: "about-bns-txt-bold" },
                        react_1.default.createElement("span", null, "Pricing:"),
                        " Users can register their BNS names for 1, 2, 5, and 10 years for as low as ",
                        react_1.default.createElement("span", null, "650 BDX, 1000 BDX, 2000 BDX,"),
                        " and ",
                        react_1.default.createElement("span", null, "4000 BDX"),
                        "respectively."),
                    react_1.default.createElement("div", { className: "about-bns-txt" }, "Using BNS names enhances your privacy, security, and convenience. Whether you\u2019re sending a message, making a transaction, or using decentralized services, your BNS name ensures a consistent and simplified experience."),
                    react_1.default.createElement("div", { className: "about-bns-txt", style: { marginBottom: '0px' } }, "Get started with your BNS name today and enjoy the benefits of a decentralized identity across all your Beldex services!"))))));
};
exports.AboutBnsDialog = AboutBnsDialog;
