"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BanOrUnBanUserDialog = void 0;
const react_1 = __importStar(require("react"));
const types_1 = require("../../bchat/types");
const utils_1 = require("../../bchat/utils");
const Flex_1 = require("../basic/Flex");
const react_redux_1 = require("react-redux");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const Text_1 = require("../basic/Text");
const ConversationController_1 = require("../../bchat/conversations/ConversationController");
const opengroupV2_1 = require("../../bchat/apis/open_group_api/opengroupV2");
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const BchatButton_1 = require("../basic/BchatButton");
const useFocusMount_1 = require("../../hooks/useFocusMount");
const useParamSelector_1 = require("../../hooks/useParamSelector");
const BchatIcon_1 = require("../icon/BchatIcon");
async function banOrUnBanUserCall(convo, textValue, banType, deleteAll) {
    const pubkey = types_1.PubKey.from(textValue);
    if (!pubkey) {
        window.log.info(`invalid pubkey for ${banType} user:${textValue}`);
        utils_1.ToastUtils.pushInvalidBchatId();
        return false;
    }
    try {
        const roomInfos = convo.toOpenGroupV2();
        const isChangeApplied = banType === 'ban'
            ? await opengroupV2_1.ApiV2.banUser(pubkey, roomInfos, deleteAll)
            : await opengroupV2_1.ApiV2.unbanUser(pubkey, roomInfos);
        if (!isChangeApplied) {
            window?.log?.warn(`failed to ${banType} user: ${isChangeApplied}`);
            banType === 'ban' ? utils_1.ToastUtils.pushUserBanFailure() : utils_1.ToastUtils.pushUserUnbanSuccess();
            return false;
        }
        window?.log?.info(`${pubkey.key} user ${banType}ned successfully...`);
        banType === 'ban' ? utils_1.ToastUtils.pushUserBanSuccess() : utils_1.ToastUtils.pushUserUnbanSuccess();
        return true;
    }
    catch (e) {
        window?.log?.error(`Got error while ${banType}ning user:`, e);
        return false;
    }
}
const BanOrUnBanUserDialog = (props) => {
    const { conversationId, banType, pubkey } = props;
    const { i18n } = window;
    const isBan = banType === 'ban';
    const dispatch = (0, react_redux_1.useDispatch)();
    const convo = (0, ConversationController_1.getConversationController)().get(conversationId);
    const inputRef = (0, react_1.useRef)(null);
    (0, useFocusMount_1.useFocusMount)(inputRef, true);
    const wasGivenAPubkey = Boolean(pubkey?.length);
    const [inputBoxValue, setInputBoxValue] = (0, react_1.useState)('');
    const [inProgress, setInProgress] = (0, react_1.useState)(false);
    const [banUser, setBanUser] = (0, react_1.useState)(true);
    const sourceConvoProps = (0, useParamSelector_1.useConversationPropsById)(pubkey);
    const inputTextToDisplay = wasGivenAPubkey && sourceConvoProps
        ? `${sourceConvoProps.profileName} ${types_1.PubKey.shorten(sourceConvoProps.id)}`
        : undefined;
    const banOrUnBanUser = async (deleteAll = false) => {
        const castedPubkey = pubkey?.length ? pubkey : inputBoxValue;
        window?.log?.info(`asked to ${banType} user: ${castedPubkey}, banAndDeleteAll:${deleteAll}`);
        setInProgress(true);
        const isBanned = await banOrUnBanUserCall(convo, castedPubkey, banType, deleteAll);
        if (isBanned) {
            setInputBoxValue('');
            dispatch((0, modalDialog_1.updateBanOrUnbanUserModal)(null));
        }
        setInProgress(false);
    };
    const chatName = convo.get('name');
    const title = `${isBan ? window.i18n('banUser') : window.i18n('unbanUser')}`;
    const onPubkeyBoxChanges = (e) => {
        setInputBoxValue(e.target.value?.trim() || '');
    };
    const startBanAndDeleteAllSequence = async () => {
        await banOrUnBanUser(true);
    };
    const buttonText = isBan ? i18n('banUser') : i18n('unbanUser');
    return (react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { showHeader: false, isloading: inProgress, okButton: {
            text: window.i18n('ok'),
            color: BchatButton_1.BchatButtonColor.Primary,
            onClickOkHandler: banUser ? banOrUnBanUser : startBanAndDeleteAllSequence,
        }, cancelButton: {
            status: true,
            text: window.i18n('cancel'),
            onClickCancelHandler: () => {
                dispatch((0, modalDialog_1.updateBanOrUnbanUserModal)(null));
            },
        } },
        react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column", alignItems: "center" },
            react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row", width: "500px", style: { marginTop: '30px' } },
                react_1.default.createElement("div", { className: "banUnbanPopup" },
                    react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: isBan ? 'banUser' : 'unBanUser', iconSize: 30, iconColor: isBan ? '#FF3E3E' : 'var(--color-icon)', fillRule: "evenodd", clipRule: "evenodd" })),
                react_1.default.createElement("div", { style: { textAlign: 'left' } },
                    react_1.default.createElement("div", { className: "banUser-title" }, title),
                    react_1.default.createElement("div", { className: "banUser-message" }, chatName))),
            react_1.default.createElement("div", { className: "banUser-box", style: { width: '100%', padding: '20px 5px' } },
                react_1.default.createElement("div", { className: "inputBox" },
                    react_1.default.createElement("input", { style: { backgroundColor: 'var(--color-hop-bg)' }, ref: inputRef, type: "text", placeholder: i18n('enterBchatID'), dir: "auto", onChange: onPubkeyBoxChanges, disabled: inProgress || wasGivenAPubkey, value: wasGivenAPubkey ? inputTextToDisplay : inputBoxValue })),
                isBan && react_1.default.createElement(Text_1.SpacerLG, null),
                react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "space-between" }, isBan && (react_1.default.createElement(react_1.default.Fragment, null,
                    react_1.default.createElement(BchatButton_1.BchatButton, { buttonType: BchatButton_1.BchatButtonType.Default, buttonColor: banUser ? BchatButton_1.BchatButtonColor.Danger : BchatButton_1.BchatButtonColor.Enable, onClick: () => {
                            setBanUser(true);
                        }, text: buttonText, disabled: inProgress, style: {
                            width: '230px',
                            height: '60px',
                            borderRadius: '16px',
                            fontSize: '20px',
                        }, iconType: banUser ? 'dot' : null, iconSize: 10 }),
                    react_1.default.createElement(BchatButton_1.BchatButton, { buttonType: BchatButton_1.BchatButtonType.Default, buttonColor: !banUser ? BchatButton_1.BchatButtonColor.Danger : BchatButton_1.BchatButtonColor.Enable, onClick: () => {
                            setBanUser(false);
                        }, text: i18n('banUserAndDeleteAll'), disabled: inProgress, style: {
                            width: '230px',
                            height: '60px',
                            borderRadius: '16px',
                            fontSize: '20px',
                        }, iconType: !banUser ? 'dot' : null, iconSize: 10 }))))))));
};
exports.BanOrUnBanUserDialog = BanOrUnBanUserDialog;
