"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatModal = void 0;
const react_1 = __importDefault(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const icon_1 = require("../icon");
class BchatModal extends react_1.default.PureComponent {
    static defaultProps = {
        showExitIcon: true,
        showHeader: true,
        headerReverse: false,
    };
    node;
    constructor(props) {
        super(props);
        this.state = {
            isVisible: true,
        };
        this.close = this.close.bind(this);
        this.onKeyUp = this.onKeyUp.bind(this);
        this.node = null;
    }
    componentDidMount() {
        window.addEventListener('keyup', this.onKeyUp);
        document.addEventListener('mousedown', this.handleClick, false);
    }
    componentWillUnmount() {
        window.removeEventListener('keyup', this.onKeyUp);
        document.removeEventListener('mousedown', this.handleClick, false);
    }
    handleClick = (e) => {
        if (this.node && this.node.contains(e.target)) {
            return;
        }
        this.close();
    };
    render() {
        const { title, headerIconButtons, showExitIcon, showHeader, headerReverse } = this.props;
        const { isVisible } = this.state;
        return isVisible ? (react_1.default.createElement("div", { ref: node => (this.node = node), className: 'bchat-modal' },
            showHeader ? (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement("div", { className: (0, classnames_1.default)('bchat-modal__header', headerReverse && 'reverse') },
                    react_1.default.createElement("div", { className: "bchat-modal__header__close" }, showExitIcon ? (react_1.default.createElement(icon_1.BchatIconButton, { iconType: "exit", iconSize: "small", onClick: this.close, dataTestId: "modal-close-button" })) : null),
                    react_1.default.createElement("div", { className: "bchat-modal__header__title" }, title),
                    react_1.default.createElement("div", { className: "bchat-modal__header__icons" }, headerIconButtons
                        ? headerIconButtons.map((iconItem) => {
                            return (react_1.default.createElement(icon_1.BchatIconButton, { key: iconItem.iconType, iconType: iconItem.iconType, iconSize: 'large', iconRotation: iconItem.iconRotation, onClick: iconItem.onClick }));
                        })
                        : null)))) : null,
            react_1.default.createElement("div", { className: "bchatl-modal__body" }, this.props.children))) : null;
    }
    close() {
        this.setState({
            isVisible: false,
        });
        document.removeEventListener('mousedown', this.handleClick, false);
        if (this.props.onClose) {
            this.props.onClose();
        }
    }
    onKeyUp(event) {
        switch (event.key) {
            case 'Esc':
            case 'Escape':
                this.close();
                break;
            default:
        }
    }
}
exports.BchatModal = BchatModal;
