"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatPasswordDialog = void 0;
const react_1 = __importDefault(require("react"));
const util_1 = require("../../util");
const utils_1 = require("../../bchat/utils");
const data_1 = require("../../data/data");
const auto_bind_1 = __importDefault(require("auto-bind"));
const modalDialog_1 = require("../../state/ducks/modalDialog");
const BchatButton_1 = require("../basic/BchatButton");
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const passwordUtils_1 = require("../../util/passwordUtils");
const BchatInput_1 = require("../basic/BchatInput");
class BchatPasswordDialog extends react_1.default.Component {
    passportInput = null;
    constructor(props) {
        super(props);
        this.state = {
            error: null,
            currentPasswordEntered: '',
            currentPasswordConfirmEntered: '',
            currentPasswordRetypeEntered: '',
        };
        (0, auto_bind_1.default)(this);
    }
    componentDidMount() {
        setTimeout(() => {
            this.passportInput && this.passportInput.focus();
        }, 1);
    }
    render() {
        const { passwordAction } = this.props;
        const placeholders = passwordAction === 'change'
            ? [
                window.i18n('currentPassword'),
                window.i18n('enterPassword'),
                window.i18n('confirmPassword'),
            ]
            : [window.i18n('removePasswordDisc'), window.i18n('confirmPassword')];
        const localizedKeyAction = passwordAction === 'change'
            ? 'changePassword'
            : passwordAction === 'remove'
                ? 'removePassword'
                : 'setPassword';
        const btnName = localizedKeyAction === 'removePassword' ? window.i18n('remove') : window.i18n('save');
        const btnColor = localizedKeyAction === 'removePassword' ? BchatButton_1.BchatButtonColor.Danger : BchatButton_1.BchatButtonColor.Primary;
        return (react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { title: window.i18n(localizedKeyAction), onClose: this.closeDialog, okButton: {
                text: btnName,
                color: btnColor,
                onClickOkHandler: this.setPassword
            }, cancelButton: { status: true, text: window.i18n('cancel'), onClickCancelHandler: this.closeDialog } },
            react_1.default.createElement("div", { className: "bchat-modal-setPassword" },
                react_1.default.createElement("div", { style: { marginBottom: '10px' } },
                    react_1.default.createElement(BchatInput_1.BchatInput, { type: "password", inputDataTestId: "password-input", value: this.state.currentPasswordEntered, autoFocus: false, placeholder: placeholders[0], enableShowHide: true, onValueChanged: this.onPasswordInput, maxLength: 13 })),
                passwordAction !== 'remove' && (react_1.default.createElement("div", { style: { marginBottom: '10px' } },
                    react_1.default.createElement(BchatInput_1.BchatInput, { type: "password", inputDataTestId: "password-input-confirm", value: this.state.currentPasswordConfirmEntered, autoFocus: false, placeholder: placeholders[1], enableShowHide: true, onValueChanged: this.onPasswordConfirmInput, maxLength: 13 }))),
                passwordAction === 'change' && (react_1.default.createElement("div", { style: { marginBottom: '10px' } },
                    react_1.default.createElement(BchatInput_1.BchatInput, { type: "password", inputDataTestId: "password-input-reconfirm", value: this.state.currentPasswordRetypeEntered, autoFocus: false, placeholder: placeholders[2], enableShowHide: true, onValueChanged: this.onPasswordRetypeInput, maxLength: 13 }))))));
    }
    async validatePasswordHash(password) {
        const hash = await (0, data_1.getPasswordHash)();
        if (hash && !(0, passwordUtils_1.matchesHash)(password, hash)) {
            return false;
        }
        return true;
    }
    validatePassword(firstPassword) {
        const errorFirstInput = (0, passwordUtils_1.validatePassword)(firstPassword);
        if (errorFirstInput !== null) {
            utils_1.ToastUtils.pushToastError('validatePassword', errorFirstInput);
            this.setState({
                error: errorFirstInput,
            });
            return false;
        }
        return true;
    }
    async handleActionSet(enteredPassword, enteredPasswordConfirm) {
        if (!this.validatePassword(enteredPassword)) {
            return;
        }
        if (enteredPassword !== enteredPasswordConfirm) {
            utils_1.ToastUtils.pushToastError('setPasswordInvalid', window.i18n('setPasswordInvalid'));
            this.setState({
                error: window.i18n('setPasswordInvalid'),
            });
            return;
        }
        await window.setPassword(enteredPassword, null);
        utils_1.ToastUtils.pushToastSuccess('setPasswordSuccessToast', window.i18n('setPasswordTitle'), window.i18n('setPasswordToastDescription'), 'lock');
        this.props.onOk();
        this.closeDialog();
    }
    async handleActionChange(oldPassword, newPassword, newConfirmedPassword) {
        if (!this.validatePassword(newPassword)) {
            return;
        }
        if ((oldPassword === newPassword) || (oldPassword === newConfirmedPassword)) {
            utils_1.ToastUtils.pushToastError('oldPasswordAndNewPasswordSame', window.i18n('oldPasswordAndNewPasswordSame'));
            this.setState({
                error: window.i18n('oldPasswordAndNewPasswordSame'),
            });
            return;
        }
        if (newPassword !== newConfirmedPassword) {
            utils_1.ToastUtils.pushToastError('passwordsDoNotMatch', window.i18n('passwordsDoNotMatch'));
            this.setState({
                error: window.i18n('passwordsDoNotMatch'),
            });
            return;
        }
        const isValidWithStoredInDB = Boolean(await this.validatePasswordHash(oldPassword));
        if (!isValidWithStoredInDB) {
            utils_1.ToastUtils.pushToastError('changePasswordInvalid', window.i18n('changePasswordInvalid'));
            this.setState({
                error: window.i18n('changePasswordInvalid'),
            });
            return;
        }
        await window.setPassword(newPassword, oldPassword);
        utils_1.ToastUtils.pushToastSuccess('setPasswordSuccessToast', window.i18n('changePasswordTitle'), window.i18n('changePasswordToastDescription'), 'lock');
        this.props.onOk();
        this.closeDialog();
    }
    async handleActionRemove(oldPassword) {
        const isValidWithStoredInDB = Boolean(await this.validatePasswordHash(oldPassword));
        if (!isValidWithStoredInDB) {
            utils_1.ToastUtils.pushToastError('removePasswordInvalid', window.i18n('removePasswordInvalid'));
            this.setState({
                error: window.i18n('removePasswordInvalid'),
            });
            return;
        }
        await window.setPassword(null, oldPassword);
        utils_1.ToastUtils.pushToastSuccess('setPasswordSuccessToast', window.i18n('removePasswordTitle'), window.i18n('removePasswordToastDescription'));
        this.props.onOk();
        this.closeDialog();
    }
    async setPassword() {
        const { passwordAction } = this.props;
        const { currentPasswordEntered, currentPasswordConfirmEntered, currentPasswordRetypeEntered, } = this.state;
        const firstPasswordEntered = (currentPasswordEntered || '').trim();
        const secondPasswordEntered = (currentPasswordConfirmEntered || '').trim();
        const thirdPasswordEntered = (currentPasswordRetypeEntered || '').trim();
        switch (passwordAction) {
            case 'set': {
                await this.handleActionSet(firstPasswordEntered, secondPasswordEntered);
                return;
            }
            case 'change': {
                await this.handleActionChange(firstPasswordEntered, secondPasswordEntered, thirdPasswordEntered);
                return;
            }
            case 'remove': {
                await this.handleActionRemove(firstPasswordEntered);
                return;
            }
            default:
                throw (0, util_1.missingCaseError)(passwordAction);
        }
    }
    closeDialog() {
        window.inboxStore?.dispatch((0, modalDialog_1.bchatPassword)(null));
    }
    async onPasswordInput(currentPasswordEntered) {
        this.setState({ currentPasswordEntered });
    }
    async onPasswordConfirmInput(currentPasswordConfirmEntered) {
        this.setState({ currentPasswordConfirmEntered });
    }
    async onPasswordRetypeInput(currentPasswordRetypeEntered) {
        this.setState({ currentPasswordRetypeEntered });
    }
}
exports.BchatPasswordDialog = BchatPasswordDialog;
