"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatWalletPasswordModal = void 0;
const react_1 = __importStar(require("react"));
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const BchatButton_1 = require("../basic/BchatButton");
const react_redux_1 = require("react-redux");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const utils_1 = require("../../bchat/utils");
const react_use_1 = require("react-use");
const walletConfig_1 = require("../../state/ducks/walletConfig");
const BchatWalletHelper_1 = require("../../wallet/BchatWalletHelper");
const data_1 = require("../../data/data");
const wallet_rpc_1 = require("../../wallet/wallet-rpc");
const settings_key_1 = require("../../data/settings-key");
const BchatWalletPassword_1 = require("../wallet/BchatWalletPassword");
const search_1 = require("../../state/ducks/search");
const section_1 = require("../../state/ducks/section");
const walletConfig_2 = require("../../state/ducks/walletConfig");
const daemon_rpc_1 = require("../../wallet/daemon-rpc");
const walletConfig_3 = require("../../state/selectors/walletConfig");
const BchatWalletPasswordModal = (props) => {
    const dispatch = (0, react_redux_1.useDispatch)();
    const userId = (0, react_redux_1.useSelector)((state) => state.user.ourNumber);
    const [password, setPassword] = (0, react_1.useState)('');
    const [loading, setLoading] = (0, react_1.useState)(false);
    const UserDetails = (0, react_redux_1.useSelector)((state) => state.conversations.conversationLookup);
    const getSyncStatus = window.getSettingValue('syncStatus');
    let currentHeight;
    let daemonHeight;
    const currentDaemon = window.getSettingValue(settings_key_1.walletSettingsKey.settingsCurrentDeamon);
    if (currentDaemon?.type === 'Local') {
        currentHeight = (0, react_redux_1.useSelector)((state) => state.daemon.height);
        daemonHeight = Number((0, react_redux_1.useSelector)(walletConfig_3.getHeight));
    }
    else {
        currentHeight = Number((0, react_redux_1.useSelector)(walletConfig_3.getHeight));
        daemonHeight = (0, react_redux_1.useSelector)((state) => state.daemon.height);
    }
    let pct = currentHeight == 0 || daemonHeight == 0 ? 0 : ((100 * currentHeight) / daemonHeight).toFixed(0);
    let percentage = pct == 100 && currentHeight < daemonHeight ? 99 : pct;
    const sync = daemonHeight > 0 && percentage < 99;
    const onClickClose = () => {
        dispatch((0, modalDialog_1.updateBchatWalletPasswordModal)(null));
    };
    (0, react_1.useEffect)(() => {
        (0, BchatWalletHelper_1.deamonvalidation)();
        startWalletRpc();
    }, []);
    async function startWalletRpc() {
        await wallet_rpc_1.wallet.startWallet('settings');
    }
    async function submitForChat() {
        if (!password) {
            return utils_1.ToastUtils.pushToastError('passwordFieldEmpty', window.i18n('passwordFieldEmpty'));
        }
        let userDetails = await (0, data_1.getConversationById)(utils_1.UserUtils.getOurPubKeyStrFromCache());
        let profileName = userDetails?.attributes.walletUserName;
        if (!profileName) {
            profileName = UserDetails?.userId?.profileName;
        }
        if (!getSyncStatus && wallet_rpc_1.wallet.wallet_state.password_hash === wallet_rpc_1.wallet.passwordEncrypt(password)) {
            showSyncBar();
            return;
        }
        let openWallet = await wallet_rpc_1.wallet.openWallet(profileName, password);
        if (openWallet.hasOwnProperty('error')) {
            return utils_1.ToastUtils.pushToastError('walletInvalidPassword', openWallet.error?.message);
        }
        else {
            await wallet_rpc_1.wallet.startHeartbeat('inChat');
            daemon_rpc_1.daemon.daemonHeartbeat();
            showSyncBar();
            return;
        }
    }
    function showSyncBar() {
        let data = true;
        dispatch((0, walletConfig_1.updatewalletSyncBarShowInChat)(data));
        onClickClose();
        const currentDaemon = window.getSettingValue(settings_key_1.walletSettingsKey.settingsCurrentDeamon);
        return utils_1.ToastUtils.pushToastInfo('connectedDaemon', `Connected to ${currentDaemon.host}`);
    }
    (0, react_use_1.useKey)((event) => {
        if (event.key === 'Enter') {
            props.from !== 'wallet' ? submitForChat() : submitForWallet();
        }
        return event.key === 'Enter';
    });
    function backToChat() {
        dispatch((0, search_1.clearSearch)());
        dispatch((0, section_1.setOverlayMode)(undefined));
        dispatch((0, section_1.showLeftPaneSection)(0));
        dispatch((0, modalDialog_1.updateBchatWalletPasswordModal)(null));
    }
    async function submitForWallet() {
        if (!password) {
            return utils_1.ToastUtils.pushToastError('passwordFieldEmpty', window.i18n('passwordFieldEmpty'));
        }
        let userDetails = await (0, data_1.getConversationById)(utils_1.UserUtils.getOurPubKeyStrFromCache());
        let profileName = userDetails?.attributes.walletUserName;
        if (!profileName) {
            profileName = UserDetails[userId].profileName;
        }
        setLoading(true);
        let openWallet = await wallet_rpc_1.wallet.openWallet(profileName, password);
        if (openWallet.hasOwnProperty('error')) {
            setLoading(false);
            return utils_1.ToastUtils.pushToastError('walletInvalidPassword', openWallet.error?.message);
        }
        else {
            wallet_rpc_1.wallet.startHeartbeat('wallet');
            let emptyAddress = '';
            dispatch((0, walletConfig_2.updateSendAddress)(emptyAddress));
            let False = false;
            dispatch((0, walletConfig_2.updateWalletPasswordPopUpFlag)(False));
            dispatch((0, modalDialog_1.updateBchatWalletPasswordModal)(null));
            daemon_rpc_1.daemon.daemonHeartbeat();
        }
    }
    return (react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { title: '', onClose: () => {
            props.from === 'wallet' ? backToChat() : onClickClose();
        }, buttonSizeLg: true, showExitIcon: false, showHeader: props.from === 'wallet' ? false : true, headerReverse: props.from === 'wallet' ? false : true, additionalClassName: "walletPassword", isloading: loading, okButton: {
            text: !sync ? 'Continue' : 'Close',
            onClickOkHandler: () => {
                !sync ? (props.from === 'wallet' ? submitForWallet() : submitForChat()) : backToChat();
            },
            color: !sync ? BchatButton_1.BchatButtonColor.Primary : BchatButton_1.BchatButtonColor.Secondary,
            disabled: false,
        }, cancelButton: !sync && {
            text: 'Cancel',
            status: true,
            color: BchatButton_1.BchatButtonColor.Secondary,
            onClickCancelHandler: () => {
                props.from === 'wallet' ? backToChat() : onClickClose();
            },
        } },
        react_1.default.createElement(BchatWalletPassword_1.WalletPassword, { from: props.from, onClickClose: backToChat, password: password, onChangePassword: (e) => setPassword(e) })));
};
exports.BchatWalletPasswordModal = BchatWalletPasswordModal;
