"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.copyBchatID = exports.EditProfileDialog = exports.QRView = void 0;
const react_1 = __importDefault(require("react"));
const react_qr_svg_1 = require("react-qr-svg");
const Avatar_1 = require("../avatar/Avatar");
const utils_1 = require("../../bchat/utils");
const conversation_1 = require("../../models/conversation");
const conversations_1 = require("../../bchat/conversations");
const auto_bind_1 = __importDefault(require("auto-bind"));
const modalDialog_1 = require("../../state/ducks/modalDialog");
const conversationInteractions_1 = require("../../interactions/conversationInteractions");
const icon_1 = require("../icon");
const RegistrationStages_1 = require("../registration/RegistrationStages");
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const VisualAttachment_1 = require("../../types/attachments/VisualAttachment");
const String_1 = require("../../bchat/utils/String");
const storage_1 = require("../../util/storage");
const ActionsPanel_1 = require("../leftpane/ActionsPanel");
const CopyIconButton_1 = require("../icon/CopyIconButton");
const Text_1 = require("../basic/Text");
const QRView = ({ bchatID }) => {
    return (react_1.default.createElement("div", { className: "qr-image" },
        react_1.default.createElement(react_qr_svg_1.QRCode, { value: bchatID, bgColor: "#FFFFFF", fgColor: "#1B1B1B", level: "M" })));
};
exports.QRView = QRView;
class EditProfileDialog extends react_1.default.Component {
    convo;
    constructor(props) {
        super(props);
        (0, auto_bind_1.default)(this);
        this.convo = (0, conversations_1.getConversationController)().get(utils_1.UserUtils.getOurPubKeyStrFromCache());
        this.state = {
            profileName: this.convo.getProfileName() || '',
            setProfileName: this.convo.getProfileName() || '',
            oldAvatarPath: this.convo.getAvatarPath() || '',
            newAvatarObjectUrl: null,
            mode: 'default',
            loading: false,
        };
    }
    componentDidMount() {
        window.addEventListener('keyup', this.onKeyUp);
    }
    componentWillUnmount() {
        window.removeEventListener('keyup', this.onKeyUp);
    }
    render() {
        const i18n = window.i18n;
        const viewDefault = this.state.mode === 'default';
        const viewEdit = this.state.mode === 'edit';
        const viewQR = this.state.mode === 'qr';
        const bchatID = utils_1.UserUtils.getOurPubKeyStrFromCache();
        const isBnsHolder = this.convo?.attributes?.isBnsHolder;
        const backButton = viewEdit || viewQR
            ? [
                {
                    iconType: 'chevron',
                    iconRotation: 90,
                    onClick: () => {
                        this.setState({ mode: 'default' });
                    },
                },
            ]
            : undefined;
        return (react_1.default.createElement("div", { style: { backgroundColor: 'red' } },
            react_1.default.createElement("div", { className: isBnsHolder ? 'edit-profile-dialog bns_enable_modal ' : 'edit-profile-dialog', "data-testid": "edit-profile-dialog", style: { backgroundColor: "blue" } },
                react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { title: i18n('editProfileModalTitle'), onClose: this.closeDialog, showHeader: false, headerIconButtons: backButton, showExitIcon: true, isloading: this.state.loading, okButton: {
                        text: this.state.mode == 'qr' ? 'Show ID' : 'Show QR',
                        iconSize: 26,
                        iconType: this.state.mode == 'qr' ? 'KeyboardBackspaceArrow' : 'qr_code',
                        onClickOkHandler: this.qrStatusUpdate
                    }, buttons: react_1.default.createElement("button", { style: {
                            width: '40%',
                            margin: 'auto 0',
                            backgroundColor: '#2E333D',
                            fontWeight: 600,
                            border: 'none',
                            borderRadius: '12px',
                            fontSize: "16px",
                            height: '60px',
                            fontFamily: "Poppins"
                        }, onClick: () => {
                            this.qrStatusUpdate();
                        } },
                        react_1.default.createElement("span", { style: { marginRight: '5px' } },
                            react_1.default.createElement(icon_1.BchatIcon, { iconType: 'qr_code', iconSize: 26 })),
                        'Show QR') },
                    react_1.default.createElement("div", { className: "profileHeader" },
                        react_1.default.createElement("div", { className: "profileClose" },
                            react_1.default.createElement(icon_1.BchatIconButton, { iconType: "exit", iconSize: "large", onClick: this.closeDialog, dataTestId: "modal-close-button" }))),
                    (viewDefault || viewQR) && this.renderDefaultView(),
                    viewEdit && this.renderEditView(),
                    this.renderBnsVerified(isBnsHolder),
                    react_1.default.createElement("div", { className: "bchat-id-section" }, !viewQR ? this.renderAddressView({ bchatID }) : this.renderQrView({ bchatID }))))));
    }
    renderProfileHeader() {
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement("div", { className: "avatar-center", style: { marginLeft: "25px" } },
                react_1.default.createElement("div", { className: "avatar-center-inner" },
                    this.renderAvatar(),
                    react_1.default.createElement("div", { className: "image-upload-section", role: "button", "data-testid": "image-upload-section" }),
                    react_1.default.createElement("div", { "data-tip": "Edit", "data-place": "right", "data-offset": "{'top':15,'left':10}", className: 'camera', onClick: this.fireInputEvent, role: "button", "data-testid": "image-upload-section" },
                        react_1.default.createElement(icon_1.BchatIcon, { iconType: "camera", iconSize: 16 }),
                        react_1.default.createElement(ActionsPanel_1.BchatToolTip, { place: "top", effect: "solid" }))))));
    }
    async fireInputEvent() {
        const scaledAvatarUrl = await (0, VisualAttachment_1.pickFileForAvatar)();
        if (scaledAvatarUrl) {
            this.setState({
                newAvatarObjectUrl: scaledAvatarUrl,
                mode: 'edit',
                loading: false,
            });
            this.onClickOK();
        }
    }
    renderDefaultView() {
        const name = this.state.setProfileName || this.state.profileName;
        return (react_1.default.createElement(react_1.default.Fragment, null,
            this.renderProfileHeader(),
            react_1.default.createElement("div", { className: "profile-name-uneditable" },
                react_1.default.createElement("div", { style: {
                        display: 'flex',
                        width: '86%',
                        justifyContent: 'center',
                    } },
                    react_1.default.createElement("p", { "data-testid": "your-profile-name" }, name),
                    react_1.default.createElement(icon_1.BchatIconButton, { iconType: "pencil", iconSize: "medium", iconColor: "#128b17", onClick: () => {
                            this.setState({ mode: 'edit' });
                        }, dataTestId: "edit-profile-icon" })))));
    }
    renderEditView() {
        const placeholderText = window.i18n('displayName');
        return (react_1.default.createElement(react_1.default.Fragment, null,
            this.renderProfileHeader(),
            react_1.default.createElement("div", { className: "profile-name" },
                react_1.default.createElement("div", { className: "inputBox" },
                    react_1.default.createElement("input", { type: "text", className: "profile-name-input", value: this.state.profileName, placeholder: placeholderText, onChange: this.onNameEdited, maxLength: RegistrationStages_1.MAX_USERNAME_LENGTH - 1, tabIndex: 0, required: true, "aria-required": true, "data-testid": "profile-name-input" })),
                react_1.default.createElement("div", { className: "saveIcon" },
                    react_1.default.createElement(icon_1.BchatIconButton, { iconType: "save_tick", iconSize: "small", onClick: this.onClickOK })))));
    }
    renderBnsVerified(isBnsHolder) {
        const i18n = window.i18n;
        return (react_1.default.createElement("div", { className: "link_bns_wrapper" }, !isBnsHolder ? (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement("button", { className: "link_bns_Btn", onClick: () => {
                    window.inboxStore?.dispatch((0, modalDialog_1.editProfileModal)(null));
                    window.inboxStore?.dispatch((0, modalDialog_1.bnsLinkModal)({}));
                } },
                react_1.default.createElement("span", null,
                    react_1.default.createElement(icon_1.BchatIcon, { iconType: 'bnslogo', iconSize: 26, iconColor: 'var(--color-text-opposite)' })),
                i18n('linkYourBns')),
            react_1.default.createElement("div", { className: "hintTxt", style: { cursor: 'pointer' }, role: 'button', onClick: () => window.inboxStore?.dispatch((0, modalDialog_1.updateAboutBnsModal)({})) },
                react_1.default.createElement("span", null,
                    " ",
                    i18n('readMoreAboutBNS'),
                    " "),
                react_1.default.createElement(Text_1.SpacerXS, null),
                react_1.default.createElement(icon_1.BchatIcon, { iconType: "infoCircle", iconSize: 12, iconColor: "#A7A7BA" })))) : (react_1.default.createElement("div", { className: "bnsVerfiedTxt" },
            react_1.default.createElement("span", { style: { marginRight: '5px' } },
                " ",
                i18n('bnsVerified')),
            react_1.default.createElement(icon_1.BchatIcon, { iconType: "circleWithTick", iconSize: 14, iconColor: "#0BB70F" })))));
    }
    renderAddressView(props) {
        let walletAddress = localStorage.getItem('userAddress');
        return (react_1.default.createElement("div", null,
            react_1.default.createElement("div", { className: "bchat-id-section-display", style: { marginBottom: "10px" } },
                react_1.default.createElement("div", { className: "profile-value" },
                    react_1.default.createElement("div", { style: { marginTop: '10px', color: 'var(--color-text)' } }, window.i18n('BchatID')),
                    react_1.default.createElement("p", { style: { margin: '10px 0px', fontWeight: '400' } }, props.bchatID)),
                react_1.default.createElement("div", { className: "bchat-id-section-display-icon", "data-tip": "Copy", "data-place": "right", "data-offset": "{'top':17}", onClick: () => copyBchatID(props.bchatID) },
                    react_1.default.createElement(CopyIconButton_1.CopyIconButton, { content: props.bchatID, iconSize: 18 }))),
            react_1.default.createElement("div", { className: "bchat-id-section-display", style: { marginBottom: '15px' } },
                react_1.default.createElement("div", { className: "profile-value", style: { color: 'var(--color-text)' } },
                    react_1.default.createElement("div", { style: { marginTop: '10px', } }, window.i18n('beldexAddress')),
                    react_1.default.createElement("p", { style: { margin: '10px 0px', fontWeight: '400', color: '#2F8FFF' } }, walletAddress)),
                react_1.default.createElement("div", { className: "bchat-id-section-display-icon", "data-tip": "Copy", "data-place": "right", "data-offset": "{'top':17}", onClick: () => copyBchatID(walletAddress) },
                    react_1.default.createElement(CopyIconButton_1.CopyIconButton, { content: walletAddress ? walletAddress : '', iconSize: 18 }))),
            react_1.default.createElement(ActionsPanel_1.BchatToolTip, { effect: "solid" })));
    }
    qrStatusUpdate() {
        const mode = this.state.mode == 'qr' ? 'default' : 'qr';
        this.setState(state => ({ ...state, mode: mode }));
    }
    renderQrView(props) {
        return (react_1.default.createElement("div", { className: "qr-box-view" },
            react_1.default.createElement(exports.QRView, { bchatID: props.bchatID }),
            react_1.default.createElement("p", null, window.i18n('scanQr'))));
    }
    renderAvatar() {
        const { oldAvatarPath, newAvatarObjectUrl, profileName } = this.state;
        return (react_1.default.createElement(Avatar_1.Avatar, { forcedAvatarPath: newAvatarObjectUrl || oldAvatarPath, forcedName: profileName, size: Avatar_1.AvatarSize.XL, pubkey: this.convo.id, isBnsHolder: this.convo?.attributes?.isBnsHolder }));
    }
    onNameEdited(event) {
        const newName = (0, String_1.sanitizeBchatUsername)(event.target.value);
        this.setState({
            profileName: newName,
        });
    }
    onKeyUp(event) {
        switch (event.key) {
            case 'Enter':
                if (this.state.mode === 'edit') {
                    this.onClickOK();
                }
                break;
            case 'Esc':
            case 'Escape':
                this.closeDialog();
                break;
            default:
        }
    }
    onClickOK() {
        const { newAvatarObjectUrl, profileName, setProfileName } = this.state;
        const newName = profileName.trim() ? profileName.trim() : setProfileName;
        this.setState({
            loading: true,
        }, async () => {
            await commitProfileEdits(setProfileName, newName, newAvatarObjectUrl);
            this.setState({
                loading: false,
                mode: 'default',
                setProfileName: newName,
                profileName: newName,
            });
        });
    }
    closeDialog() {
        window.removeEventListener('keyup', this.onKeyUp);
        window.inboxStore?.dispatch((0, modalDialog_1.editProfileModal)(null));
    }
}
exports.EditProfileDialog = EditProfileDialog;
async function commitProfileEdits(oldName, newName, scaledAvatarUrl) {
    const ourNumber = utils_1.UserUtils.getOurPubKeyStrFromCache();
    const conversation = await (0, conversations_1.getConversationController)().getOrCreateAndWait(ourNumber, conversation_1.ConversationTypeEnum.PRIVATE);
    if (scaledAvatarUrl?.length) {
        try {
            const blobContent = await (await fetch(scaledAvatarUrl)).blob();
            if (!blobContent || !blobContent.size) {
                throw new Error('Failed to fetch blob content from scaled avatar');
            }
            await (0, conversationInteractions_1.uploadOurAvatar)(await blobContent.arrayBuffer());
        }
        catch (error) {
            if (error.message && error.message.length) {
                utils_1.ToastUtils.pushToastError('edit-profile', error.message);
            }
            window.log.error('showEditProfileDialog Error ensuring that image is properly sized:', error && error.stack ? error.stack : error);
        }
    }
    if (oldName === newName) {
        console.log('same profile name');
        return;
    }
    await conversation.setBchatProfile({
        displayName: newName,
    });
    await conversation.commit();
    await (0, storage_1.setLastProfileUpdateTimestamp)(Date.now());
    await utils_1.SyncUtils.forceSyncConfigurationNowIfNeeded(true);
}
function copyBchatID(bchatID) {
    window.clipboard.writeText(bchatID);
    utils_1.ToastUtils.pushCopiedToClipBoard();
}
exports.copyBchatID = copyBchatID;
