"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RemoveModeratorsDialog = void 0;
const react_1 = __importStar(require("react"));
const opengroupV2_1 = require("../../bchat/apis/open_group_api/opengroupV2");
const conversations_1 = require("../../bchat/conversations");
const types_1 = require("../../bchat/types");
const utils_1 = require("../../bchat/utils");
const Flex_1 = require("../basic/Flex");
const lodash_1 = __importDefault(require("lodash"));
const modalDialog_1 = require("../../state/ducks/modalDialog");
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const BchatButton_1 = require("../basic/BchatButton");
const MemberListItem_1 = require("../MemberListItem");
const react_redux_1 = require("react-redux");
const useParamSelector_1 = require("../../hooks/useParamSelector");
async function removeMods(convoId, modsToRemove) {
    if (modsToRemove.length === 0) {
        window?.log?.info('No moderators removed. Nothing todo');
        return false;
    }
    window?.log?.info(`asked to remove moderators: ${modsToRemove}`);
    try {
        let res;
        const convo = (0, conversations_1.getConversationController)().get(convoId);
        const roomInfos = convo.toOpenGroupV2();
        const modsToRemovePubkey = lodash_1.default.compact(modsToRemove.map(m => types_1.PubKey.from(m)));
        res = await Promise.all(modsToRemovePubkey.map(async (m) => {
            return opengroupV2_1.ApiV2.removeModerator(m, roomInfos);
        }));
        res = res.every(r => !!r);
        if (!res) {
            window?.log?.warn('failed to remove moderators:', res);
            utils_1.ToastUtils.pushFailedToRemoveFromModerator();
            return false;
        }
        else {
            window?.log?.info(`${modsToRemove} removed from moderators...`);
            utils_1.ToastUtils.pushUserRemovedFromModerators();
            return true;
        }
    }
    catch (e) {
        window?.log?.error('Got error while removing moderator:', e);
        return false;
    }
}
const RemoveModeratorsDialog = (props) => {
    const { conversationId } = props;
    const [removingInProgress, setRemovingInProgress] = (0, react_1.useState)(false);
    const [modsToRemove, setModsToRemove] = (0, react_1.useState)([]);
    const { i18n } = window;
    const dispatch = (0, react_redux_1.useDispatch)();
    const closeDialog = () => {
        dispatch((0, modalDialog_1.updateRemoveModeratorsModal)(null));
    };
    const removeModsCall = async () => {
        if (modsToRemove.length) {
            setRemovingInProgress(true);
            const removed = await removeMods(conversationId, modsToRemove);
            setRemovingInProgress(false);
            if (removed) {
                closeDialog();
            }
        }
    };
    const convoProps = (0, useParamSelector_1.useConversationPropsById)(conversationId);
    if (!convoProps || !convoProps.isPublic || !convoProps.weAreAdmin) {
        throw new Error('RemoveModeratorsDialog: convoProps invalid');
    }
    const existingMods = convoProps.groupAdmins || [];
    const hasMods = existingMods.length !== 0;
    const title = `${i18n('removeModerators')}`;
    return (react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { title: title, isloading: removingInProgress, okButton: {
            text: i18n('remove'),
            onClickOkHandler: removeModsCall,
            disabled: removingInProgress || !modsToRemove.length,
            color: BchatButton_1.BchatButtonColor.Primary,
        }, cancelButton: {
            status: true,
            text: i18n('cancel'),
            disabled: removingInProgress,
            color: BchatButton_1.BchatButtonColor.Secondary,
            onClickCancelHandler: closeDialog,
        } },
        react_1.default.createElement("div", { className: 'moderator-removeModeratorBox' },
            react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column", alignItems: "center" }, hasMods ? (react_1.default.createElement("div", { className: 'innerBox' },
                react_1.default.createElement("div", { className: 'memberListBox' }, existingMods.map(modId => (react_1.default.createElement(MemberListItem_1.MemberListItem, { key: modId, pubkey: modId, isSelected: modsToRemove.some(m => m === modId), onSelect: (selectedMember) => {
                        const updatedList = [...modsToRemove, selectedMember];
                        setModsToRemove(updatedList);
                    }, onUnselect: (selectedMember) => {
                        const updatedList = modsToRemove.filter(m => m !== selectedMember);
                        setModsToRemove(updatedList);
                    } })))))) : (react_1.default.createElement("p", null, i18n('noModeratorsToRemove')))))));
};
exports.RemoveModeratorsDialog = RemoveModeratorsDialog;
