"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReactClearAllModal = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const styled_components_1 = __importDefault(require("styled-components"));
const modalDialog_1 = require("../../state/ducks/modalDialog");
const conversations_1 = require("../../state/selectors/conversations");
const theme_1 = require("../../state/selectors/theme");
const Flex_1 = require("../basic/Flex");
const BchatButton_1 = require("../basic/BchatButton");
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const conversations_2 = require("../../bchat/conversations");
const BchatSpinner_1 = require("../basic/BchatSpinner");
const StyledReactClearAllContainer = (0, styled_components_1.default)(Flex_1.Flex) `
  margin: var(--margins-lg);

  p {
    font-size: 18px;
    font-weight: bold;

    span {
      margin-left: 4px;
    }
  }

  .Bchat-button {
    font-size: 16px;
    height: 36px;
    padding-top: 3px;
  }
`;
const ReactClearAllModal = (props) => {
    const { reaction, messageId } = props;
    const msgProps = (0, react_redux_1.useSelector)((state) => (0, conversations_1.getMessageReactsProps)(state, messageId));
    const dispatch = (0, react_redux_1.useDispatch)();
    const darkMode = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    const [clearingInProgress, setClearingInProgress] = (0, react_1.useState)(false);
    if (!msgProps) {
        return react_1.default.createElement(react_1.default.Fragment, null);
    }
    const { convoId, serverId } = msgProps;
    const roomInfos = (0, conversations_2.getConversationController)()
        .get(convoId)
        .toOpenGroupV2();
    const handleClearAll = async () => {
        if (roomInfos && serverId) {
            setClearingInProgress(true);
            setClearingInProgress(false);
            handleClose();
        }
        else {
            window.log.warn('Error for batch removal of', reaction, 'on message', messageId);
        }
    };
    const confirmButtonColor = darkMode ? BchatButton_1.BchatButtonColor.Green : BchatButton_1.BchatButtonColor.Secondary;
    const handleClose = () => {
        dispatch((0, modalDialog_1.updateReactClearAllModal)(null));
    };
    return (react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { additionalClassName: 'reaction-list-modal', showHeader: false, onClose: handleClose },
        react_1.default.createElement(StyledReactClearAllContainer, { container: true, flexDirection: 'column', darkMode: darkMode, alignItems: "center" },
            react_1.default.createElement("p", null,
                "Are you sure you want to clear all ",
                react_1.default.createElement("p", null, window.i18n('clearAllReactions', [reaction]))),
            react_1.default.createElement("hr", null),
            react_1.default.createElement("div", { className: "Bchat-modal__button-group" },
                react_1.default.createElement(BchatButton_1.BchatButton, { text: 'Clear', buttonColor: confirmButtonColor, buttonType: BchatButton_1.BchatButtonType.BrandOutline, onClick: handleClearAll, disabled: clearingInProgress }),
                react_1.default.createElement(BchatButton_1.BchatButton, { text: 'Cancel', buttonColor: BchatButton_1.BchatButtonColor.Danger, buttonType: BchatButton_1.BchatButtonType.BrandOutline, onClick: handleClose, disabled: clearingInProgress })),
            react_1.default.createElement(BchatSpinner_1.BchatSpinner, { loading: clearingInProgress }))));
};
exports.ReactClearAllModal = ReactClearAllModal;
