"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserDetailsDialog = void 0;
const react_1 = __importDefault(require("react"));
const useKey_1 = __importDefault(require("react-use/lib/useKey"));
const conversation_1 = require("../../models/conversation");
const conversations_1 = require("../../bchat/conversations");
const utils_1 = require("../../bchat/utils");
const conversations_2 = require("../../state/ducks/conversations");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const Avatar_1 = require("../avatar/Avatar");
const Text_1 = require("../basic/Text");
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const Flex_1 = require("../basic/Flex");
const icon_1 = require("../icon");
const UserDetailsDialog = (props) => {
    const convo = (0, conversations_1.getConversationController)().get(props.conversationId);
    function closeDialog() {
        window.inboxStore?.dispatch((0, modalDialog_1.updateUserDetailsModal)(null));
    }
    async function onClickStartConversation() {
        const conversation = await (0, conversations_1.getConversationController)().getOrCreateAndWait(convo.id, conversation_1.ConversationTypeEnum.PRIVATE);
        await (0, conversations_2.openConversationWithMessages)({ conversationKey: conversation.id, messageId: null });
        closeDialog();
    }
    (0, useKey_1.default)('Enter', () => {
        void onClickStartConversation();
    }, undefined, [props.conversationId]);
    function copyBchatID(bchatID) {
        window.clipboard.writeText(bchatID);
        utils_1.ToastUtils.pushCopiedToClipBoard();
    }
    return (react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { title: '', onClose: closeDialog, showExitIcon: false, showHeader: false, additionalClassName: "user-details", okButton: {
            onClickOkHandler: () => closeDialog(),
        } },
        react_1.default.createElement("div", { style: { width: '500px', paddingTop: '20px' } },
            react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "center" },
                react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.HUGE, pubkey: props.conversationId, isBnsHolder: convo?.attributes?.isBnsHolder })),
            react_1.default.createElement(Text_1.SpacerSM, null),
            react_1.default.createElement("div", { className: "user-name" }, props.userName),
            react_1.default.createElement(Text_1.SpacerMD, null),
            react_1.default.createElement("div", { className: "user-id-wrapper" },
                react_1.default.createElement(Flex_1.Flex, { container: true, alignItems: 'baseline' },
                    react_1.default.createElement("div", null,
                        react_1.default.createElement("div", { className: "user-id-wrapper-label" }, "BChat Id"),
                        react_1.default.createElement("div", { className: "user-id" }, convo.id)),
                    react_1.default.createElement(icon_1.BchatIconButton, { iconType: "copy", iconSize: 18, iconColor: "#00A638", clipRule: "evenodd", fillRule: "evenodd", onClick: () => copyBchatID(convo.id) }))),
            react_1.default.createElement(Text_1.SpacerLG, null))));
};
exports.UserDetailsDialog = UserDetailsDialog;
