"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(require("react"));
const Text_1 = require("../basic/Text");
const BchatButton_1 = require("../basic/BchatButton");
const electron_1 = require("electron");
const storage_1 = require("../../util/storage");
const DeleteAccountModal_1 = require("./DeleteAccountModal");
const styled_components_1 = __importDefault(require("styled-components"));
function BchatUpdateInstruntion() {
    const [copied, setCopied] = (0, react_1.useState)(false);
    const [loading, setLoading] = (0, react_1.useState)(false);
    function copyToClipboard() {
        electron_1.clipboard.writeText((0, storage_1.getCurrentRecoveryPhrase)(), 'clipboard');
        setCopied(true);
    }
    async function clearData() {
        setLoading(true);
        await (0, DeleteAccountModal_1.sendConfigMessageAndDeleteEverything)("oldVersion");
        setLoading(false);
    }
    return react_1.default.createElement("div", { className: "modal modal-center" },
        loading &&
            react_1.default.createElement(Loader, null,
                react_1.default.createElement("div", { className: "modal-UpdateModal-loader" },
                    react_1.default.createElement("img", { src: 'images/bchat/Load_animation.gif', style: { width: '150px', height: '150px' } }))),
        react_1.default.createElement("section", { className: "contentUpdateModal" },
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("img", { src: 'images/bchat/Update_icon.svg', className: "modal-UpdateModal-icon" }),
            react_1.default.createElement(Text_1.SpacerMD, null),
            react_1.default.createElement("div", { className: "modal-UpdateModal-header" }, "BChat Wallet Update"),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", { className: "modal-UpdateModal-discription" },
                "The Beldex wallet has been integrated to BChat. Restore your app to gain access your BChat account. First, copy your recovery seed by clicking ",
                react_1.default.createElement("span", { className: "modal-UpdateModal-discription-fontMedium" }, "'Copy Seed'"),
                ". Save your recovery seed. Then click ",
                react_1.default.createElement("span", { className: "modal-UpdateModal-discription-fontMedium" }, "'Restore'"),
                " to restore your account using the seed."),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", { className: "modal-UpdateModal-btnBox" },
                react_1.default.createElement(BchatButton_1.BchatButton, { text: "Copy Seed", buttonColor: BchatButton_1.BchatButtonColor.Green, onClick: () => copyToClipboard() }),
                react_1.default.createElement(Text_1.SpacerMD, null),
                react_1.default.createElement(BchatButton_1.BchatButton, { text: "Restore", buttonColor: BchatButton_1.BchatButtonColor.Primary, onClick: () => clearData(), disabled: !copied })),
            react_1.default.createElement(Text_1.SpacerLG, null)));
}
exports.default = BchatUpdateInstruntion;
const Loader = styled_components_1.default.div `
    position: absolute;
    // top: 0;
    display: flex;
    // justify-content: center;
    /* width: 100%; */
    // width: 100Vw;
    // height: 100%;
    align-items: center;
    z-index: 101;
  `;
