"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatIconButton = void 0;
const react_1 = __importDefault(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const _1 = require(".");
const lodash_1 = __importDefault(require("lodash"));
const BchatNotificationCount_1 = require("./BchatNotificationCount");
const BchatIconButtonInner = react_1.default.forwardRef((props, ref) => {
    const { iconType, iconSize, iconColor, iconRotation, isSelected, notificationCount, glowDuration, glowStartDelay, noScale, isHidden, backgroundColor, borderRadius, iconPadding, margin, id, dataTestId, padding, btnBgColor, btnRadius, fillRule, clipRule, } = props;
    const clickHandler = (e) => {
        if (props.onClick) {
            e.stopPropagation();
            props.onClick(e);
        }
    };
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('bchat-icon-button', iconSize, isSelected ? 'no-opacity' : ''), role: "button", ref: ref, id: id, onClick: clickHandler, style: {
            display: isHidden ? 'none' : 'flex',
            margin: margin ? margin : '',
            padding: padding ?? '',
            alignItems: 'center',
            background: btnBgColor ?? '',
            borderRadius: btnRadius ?? ''
        }, "data-testid": dataTestId },
        react_1.default.createElement(_1.BchatIcon, { iconType: iconType, iconSize: iconSize, iconColor: iconColor, iconRotation: iconRotation, glowDuration: glowDuration, glowStartDelay: glowStartDelay, noScale: noScale, backgroundColor: backgroundColor, borderRadius: borderRadius, iconPadding: iconPadding, fillRule: fillRule, clipRule: clipRule }),
        Boolean(notificationCount) && react_1.default.createElement(BchatNotificationCount_1.BchatNotificationCount, { count: notificationCount })));
});
exports.BchatIconButton = react_1.default.memo(BchatIconButtonInner, lodash_1.default.isEqual);
