"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DropDownAndToggleButton = void 0;
const react_1 = __importDefault(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
const react_contexify_1 = require("react-contexify");
const BchatIcon_1 = require("./BchatIcon");
const call_1 = require("../../state/selectors/call");
const react_redux_1 = require("react-redux");
const StyledRoundedButton = styled_components_1.default.div `
  // background-color:var(--color-clickable-hovered);
  color: ${props => (props.isSelected ? '#FF3E3E' : '#128b17')};
  border-radius: 50%;
  cursor: pointer;
  border:1px solid #e6e6e6
  transition-duration: 0.25s;
  border:var(--bchat-border);
  background-color: ${props => props.isSelected ? '#FFBF91' : props.isCallModalExpandView ? 'var(--color-enable-btn-bg)'
    : 'var(--color-clickable-hovered)'};
  &:hover {
    // background-color: var(--color-call-option-btn-hover);
  background-color:#FFBF91;
  opacity:0.9;
  }

  display: flex;
  justify-content: center;
  align-items: center;
  position: relative;
`;
const StyledContainer = (0, styled_components_1.default)(StyledRoundedButton) `
  width: 60px;
  height: 60px;
  margin: 5px;
  opacity: 1;
  &:hover {
    tranform: scale(1.1);
  }
`;
const StyledArrowIcon = (0, styled_components_1.default)(StyledRoundedButton) `
  width: 35%;
  height: 35%;
  // position: relative;
  top: 39px;
  right: 0px;
  border: 2px solid var(--color-hop-bg);

  position: absolute;
  &:hover {
    background-color: #ffffff;
    color: #2879f9;
  }
`;
const DropDownAndToggleButton = (props) => {
    const { iconType, hidePopoverArrow, onArrowClick, onMainButtonClick, isMuted, isCallModalExpandView } = props;
    const hasOngoingCallFullScreen = (0, react_redux_1.useSelector)(call_1.getCallIsInFullScreen);
    const arrowClickHandler = (e) => {
        e.stopPropagation();
        onArrowClick(e);
    };
    const mainButtonClickHandler = (e) => {
        e.stopPropagation();
        react_contexify_1.contextMenu.hideAll();
        onMainButtonClick(e);
    };
    const fillColor = 'var(--color-text)';
    return (react_1.default.createElement(StyledContainer, { isMuted: isMuted || false, isSelected: isMuted, onClick: mainButtonClickHandler, isCallModalExpandView: isCallModalExpandView || hasOngoingCallFullScreen },
        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: iconType, iconSize: 27, iconColor: isMuted ? '#333333' : fillColor }),
        !hidePopoverArrow && (react_1.default.createElement(StyledArrowIcon, { isMuted: isMuted || false, onClick: arrowClickHandler },
            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "chevron", iconColor: fillColor, iconSize: 20 })))));
};
exports.DropDownAndToggleButton = DropDownAndToggleButton;
