"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LeftPane = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const section_1 = require("../../state/ducks/section");
const BchatTheme_1 = require("../../state/ducks/BchatTheme");
const conversations_1 = require("../../state/selectors/conversations");
const search_1 = require("../../state/selectors/search");
const section_2 = require("../../state/selectors/section");
const userConfig_1 = require("../../state/selectors/userConfig");
const ActionsPanel_1 = require("./ActionsPanel");
const LeftPaneMessageSection_1 = require("./LeftPaneMessageSection");
const LeftPaneSettingSection_1 = require("./LeftPaneSettingSection");
const OverlayOpenGroup_1 = require("./overlay/OverlayOpenGroup");
const OverlayClosedGroup_1 = require("./overlay/OverlayClosedGroup");
const conversations_2 = require("../../state/selectors/conversations");
const BchatWalletAddressBook_1 = require("../wallet/BchatWalletAddressBook");
const OverlayMessage_1 = require("./overlay/OverlayMessage");
const OverlayCallHistory_1 = require("./overlay/OverlayCallHistory");
const InnerLeftPaneMessageSection = () => {
    const showSearch = (0, react_redux_1.useSelector)(search_1.isSearching);
    const searchResults = showSearch ? (0, react_redux_1.useSelector)(search_1.getSearchResults) : undefined;
    const lists = showSearch ? undefined : (0, react_redux_1.useSelector)(conversations_1.getLeftPaneLists);
    const messageRequestsEnabled = (0, react_redux_1.useSelector)(userConfig_1.getHideMessageRequestBanner);
    const overlayMode = (0, react_redux_1.useSelector)(section_2.getOverlayMode);
    const directContact = (0, react_redux_1.useSelector)(conversations_2.getDirectContacts);
    const conversationRequestsUnread = (0, react_redux_1.useSelector)(conversations_1.getUnreadConversationRequests).length;
    return (react_1.default.createElement(LeftPaneMessageSection_1.LeftPaneMessageSection, { conversations: lists?.conversations || [], contacts: lists?.contacts || [], searchResults: searchResults, messageRequestsEnabled: messageRequestsEnabled, overlayMode: overlayMode, directContact: directContact, conversationRequestsUnread: conversationRequestsUnread }));
};
const LeftPaneSection = () => {
    const focusedSection = (0, react_redux_1.useSelector)(section_2.getFocusedSection);
    const zoomLevel = window.getSettingValue('zoom-factor-setting');
    if (focusedSection === section_1.SectionType.Message) {
        return react_1.default.createElement(InnerLeftPaneMessageSection, null);
    }
    if (focusedSection === section_1.SectionType.NewChat) {
        return react_1.default.createElement(OverlayMessage_1.OverlayMessage, null);
    }
    if (focusedSection === section_1.SectionType.Closedgroup) {
        return react_1.default.createElement(OverlayClosedGroup_1.OverlayClosedGroup, null);
    }
    if (focusedSection === section_1.SectionType.Opengroup) {
        return react_1.default.createElement(OverlayOpenGroup_1.OverlayOpenGroup, null);
    }
    if (focusedSection === section_1.SectionType.CallHistory) {
        return react_1.default.createElement(OverlayCallHistory_1.OverlayCallHistory, null);
    }
    if (focusedSection === section_1.SectionType.Wallet) {
        return react_1.default.createElement("div", { className: 'wallet-contact-left-pane-wrapper', style: { minWidth: zoomLevel > 100 ? '223px' : '', width: zoomLevel > 100 ? '20vw' : '' } },
            react_1.default.createElement(BchatWalletAddressBook_1.AddressBook, { isContact: true }));
    }
    if (focusedSection === section_1.SectionType.Settings) {
        return react_1.default.createElement(LeftPaneSettingSection_1.LeftPaneSettingSection, null);
    }
    return null;
};
const LeftPane = () => {
    return (react_1.default.createElement(BchatTheme_1.BchatTheme, null,
        react_1.default.createElement("div", { className: "module-left-pane-bchat" },
            react_1.default.createElement("div", { className: "module-left-pane" },
                react_1.default.createElement(ActionsPanel_1.ActionsPanel, null),
                react_1.default.createElement(LeftPaneSection, null)))));
};
exports.LeftPane = LeftPane;
