"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LeftPaneContactSection = void 0;
const react_1 = __importDefault(require("react"));
const ConversationListItem_1 = require("./conversation-list-item/ConversationListItem");
const react_virtualized_1 = require("react-virtualized");
const LeftPaneSectionHeader_1 = require("./LeftPaneSectionHeader");
const react_redux_1 = require("react-redux");
const conversations_1 = require("../../state/selectors/conversations");
const renderRow = (props) => {
    const { index, key, style } = props;
    const directContacts = props.parent?.props?.directContacts || [];
    const item = directContacts?.[index];
    if (!item) {
        return null;
    }
    return react_1.default.createElement(ConversationListItem_1.MemoConversationListItemWithDetails, { style: style, key: key, ...item });
};
const ContactListItemSection = () => {
    const directContacts = (0, react_redux_1.useSelector)(conversations_1.getDirectContacts);
    if (!directContacts) {
        return null;
    }
    const length = Number(directContacts.length);
    return (react_1.default.createElement("div", { className: "module-left-pane__list", key: 0 },
        react_1.default.createElement(react_virtualized_1.AutoSizer, null, ({ height, width }) => (react_1.default.createElement(react_virtualized_1.List, { className: "module-left-pane__virtual-list", height: height, directContacts: directContacts, rowCount: length, rowHeight: 64, rowRenderer: renderRow, width: width, autoHeight: false })))));
};
const LeftPaneContactSection = () => {
    return (react_1.default.createElement("div", { className: "left-pane-contact-section" },
        react_1.default.createElement(LeftPaneSectionHeader_1.LeftPaneSectionHeader, null),
        react_1.default.createElement("div", { className: "left-pane-contact-content" },
            react_1.default.createElement(ContactListItemSection, null))));
};
exports.LeftPaneContactSection = LeftPaneContactSection;
