"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageRequestsBanner = exports.CirclularIcon = void 0;
const react_1 = __importDefault(require("react"));
const react_contexify_1 = require("react-contexify");
const react_dom_1 = require("react-dom");
const react_redux_1 = require("react-redux");
const styled_components_1 = __importDefault(require("styled-components"));
const conversations_1 = require("../../state/selectors/conversations");
const userConfig_1 = require("../../state/selectors/userConfig");
const icon_1 = require("../icon");
const MessageRequestBannerContextMenu_1 = require("../menu/MessageRequestBannerContextMenu");
const StyledMessageRequestBanner = styled_components_1.default.div `
  height: 74px;
  margin-bottom: 1px;
  width: 100%;
  // max-width: 300px;
  display: flex;
  flex-direction: row;
  padding: 8px 22px; // adjusting for unread border always being active
  align-items: center;
  cursor: pointer;
  justify-content: space-between;
  background: var(--color-request-banner-background);

  transition: var(--bchat-transition-duration);
  margin-top:10px;
  border-radius:22px;

  &:hover {
    background: var(--color-clickable-hovered);
  }
`;
const StyledMessageRequestBannerHeader = styled_components_1.default.span `
font-size: 16px;
font-weight: 400;
`;
const StyledCircleIcon = styled_components_1.default.div `
  padding-left: var(--margins-xs);
`;
const StyledUnreadCounter = styled_components_1.default.div `
  color:#fff;
  font-weight: bold;
  border-radius: var(--margins-md);
  font-size: var(--font-size-xs);
  background-color: var(--color-request-banner-unread-background);
  margin-left: 40px;
  min-width: 23px;
  height: 23px;
  line-height: 25px;
  display: flex;
  flex-direction: row;
  align-items: center;
  justify-content: center;
  padding: var(--margins-xs);
`;
const StyledGridContainer = styled_components_1.default.div `
  display: flex;
  width: 42px;
  height: 42px;
  align-items: center;
  border-radius: 50%;
  justify-content: center;
  background-color: var(--color-request-banner-icon-background);
`;
const CirclularIcon = () => {
    return (react_1.default.createElement(StyledCircleIcon, null,
        react_1.default.createElement(StyledGridContainer, null,
            react_1.default.createElement("div", { style: { background: `url(images/bchat/message_request.svg) no-repeat`,
                    width: "30px",
                    height: "34px",
                    position: 'relative',
                    top: '8px',
                    left: '6px',
                } }))));
};
exports.CirclularIcon = CirclularIcon;
const MessageRequestsBanner = (props) => {
    const { handleOnClick } = props;
    const conversationRequestsUnread = (0, react_redux_1.useSelector)(conversations_1.getUnreadConversationRequests).length;
    const hideRequestBanner = (0, react_redux_1.useSelector)(userConfig_1.getHideMessageRequestBanner);
    if (hideRequestBanner || !conversationRequestsUnread) {
        return null;
    }
    const triggerId = 'msg-req-banner';
    const handleOnContextMenu = (e) => {
        react_contexify_1.contextMenu.show({
            id: triggerId,
            event: e,
        });
    };
    const openRequests = (e) => {
        if (e.button === 0) {
            handleOnClick();
        }
    };
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(StyledMessageRequestBanner, { onContextMenu: handleOnContextMenu, onClick: openRequests, onMouseUp: e => {
                e.stopPropagation();
                e.preventDefault();
            }, "data-testid": "message-request-banner" },
            react_1.default.createElement(icon_1.BchatIcon, { iconSize: "medium", iconType: "messageRequest" }),
            react_1.default.createElement(StyledMessageRequestBannerHeader, null, window.i18n('messageRequests')),
            react_1.default.createElement(StyledUnreadCounter, null,
                react_1.default.createElement("div", null, conversationRequestsUnread || 0))),
        react_1.default.createElement(Portal, null,
            react_1.default.createElement(MessageRequestBannerContextMenu_1.MemoMessageRequestBannerContextMenu, { triggerId: triggerId }))));
};
exports.MessageRequestsBanner = MessageRequestsBanner;
const Portal = ({ children }) => {
    return (0, react_dom_1.createPortal)(children, document.querySelector('.inbox.index'));
};
