"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MemoConversationListItemWithDetails = exports.ContextConversationId = void 0;
const react_1 = __importStar(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const react_contexify_1 = require("react-contexify");
const Avatar_1 = require("../../avatar/Avatar");
const react_dom_1 = require("react-dom");
const conversations_1 = require("../../../state/ducks/conversations");
const react_redux_1 = require("react-redux");
const modalDialog_1 = require("../../../state/ducks/modalDialog");
const useParamSelector_1 = require("../../../hooks/useParamSelector");
const ConversationListItemContextMenu_1 = require("../../menu/ConversationListItemContextMenu");
const HeaderItem_1 = require("./HeaderItem");
const MessageItem_1 = require("./MessageItem");
const lodash_1 = __importDefault(require("lodash"));
const Timestamp_1 = require("../../conversation/Timestamp");
exports.ContextConversationId = react_1.default.createContext('');
const Portal = ({ children }) => {
    return (0, react_dom_1.createPortal)(children, document.querySelector('.inbox.index'));
};
const AvatarItem = () => {
    const conversationId = (0, react_1.useContext)(exports.ContextConversationId);
    const userName = (0, useParamSelector_1.useConversationUsername)(conversationId);
    const isPrivate = (0, useParamSelector_1.useIsPrivate)(conversationId);
    const avatarPath = (0, useParamSelector_1.useAvatarPath)(conversationId);
    const isBnsHolder = (0, useParamSelector_1.useConversationBnsHolder)(conversationId);
    const dispatch = (0, react_redux_1.useDispatch)();
    function onPrivateAvatarClick() {
        dispatch((0, modalDialog_1.updateUserDetailsModal)({
            conversationId: conversationId,
            userName: userName || '',
            authorAvatarPath: avatarPath,
        }));
    }
    return (react_1.default.createElement("div", { className: "module-conversation-list-item__avatar-container" },
        react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.L, pubkey: conversationId, onAvatarClick: isPrivate ? onPrivateAvatarClick : undefined, isBnsHolder: isBnsHolder })));
};
const ConversationListItem = (props) => {
    const { unreadCount, id: conversationId, isSelected, isBlocked, mentionedUs, isMessageRequest, } = props;
    function useHeaderItemProps(conversationId) {
        const convoProps = (0, useParamSelector_1.useConversationPropsById)(conversationId);
        if (!convoProps) {
            return null;
        }
        return {
            isPinned: !!convoProps.isPinned,
            mentionedUs: convoProps.mentionedUs || false,
            unreadCount: convoProps.unreadCount || 0,
            activeAt: convoProps.activeAt,
        };
    }
    const convoProps = useHeaderItemProps(conversationId);
    const activeAt = convoProps?.activeAt;
    const key = `conversation-item-${conversationId}`;
    const triggerId = `${key}-ctxmenu`;
    const openConvo = (0, react_1.useCallback)(async (e) => {
        if (e.button === 0) {
            await (0, conversations_1.openConversationWithMessages)({ conversationKey: conversationId, messageId: null });
        }
    }, [conversationId]);
    return (react_1.default.createElement(exports.ContextConversationId.Provider, { value: conversationId },
        react_1.default.createElement("div", { style: { position: 'relative' } },
            react_1.default.createElement("div", { key: key },
                react_1.default.createElement("div", { role: "button", onMouseDown: openConvo, onMouseUp: e => {
                        e.stopPropagation();
                        e.preventDefault();
                    }, onContextMenu: e => {
                        react_contexify_1.contextMenu.show({
                            id: triggerId,
                            event: e,
                        });
                    }, className: (0, classnames_1.default)('module-conversation-list-item', unreadCount && unreadCount > 0 ? 'module-conversation-list-item--has-unread' : null, unreadCount && unreadCount > 0 && mentionedUs
                        ? 'module-conversation-list-item--mentioned-us'
                        : null, isSelected ? 'module-conversation-list-item--is-selected' : null, isBlocked ? 'module-conversation-list-item--is-blocked' : null) },
                    react_1.default.createElement("div", { className: "verticalLine" }),
                    react_1.default.createElement(AvatarItem, null),
                    react_1.default.createElement("div", { className: "module-conversation-list-item__content" },
                        react_1.default.createElement(HeaderItem_1.ConversationListItemHeaderItem, null),
                        react_1.default.createElement("div", { className: "module-conversation-list-item__content__messageBox" },
                            react_1.default.createElement(MessageItem_1.MessageItem, { isMessageRequest: Boolean(isMessageRequest) }),
                            react_1.default.createElement(Timestamp_1.Timestamp, { timestamp: activeAt, isConversationListItem: true, momentFromNow: true })))),
                react_1.default.createElement(Portal, null,
                    react_1.default.createElement(ConversationListItemContextMenu_1.MemoConversationListItemContextMenu, { triggerId: triggerId }))))));
};
exports.MemoConversationListItemWithDetails = react_1.default.memo(ConversationListItem, lodash_1.default.isEqual);
