"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageItem = void 0;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importStar(require("react"));
const lodash_1 = require("lodash");
const useParamSelector_1 = require("../../../hooks/useParamSelector");
const MessageBody_1 = require("../../conversation/message/message-content/MessageBody");
const TypingAnimation_1 = require("../../conversation/TypingAnimation");
const ConversationListItem_1 = require("./ConversationListItem");
const react_redux_1 = require("react-redux");
const search_1 = require("../../../state/selectors/search");
function useMessageItemProps(convoId) {
    const convoProps = (0, useParamSelector_1.useConversationPropsById)(convoId);
    if (!convoProps) {
        return null;
    }
    return {
        isTyping: !!convoProps.isTyping,
        lastMessage: convoProps.lastMessage,
        unreadCount: convoProps.unreadCount || 0,
    };
}
const MessageItem = (props) => {
    const conversationId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const convoProps = useMessageItemProps(conversationId);
    const isGroup = !!(0, useParamSelector_1.useIsPrivate)(conversationId);
    const isSearchingMode = (0, react_redux_1.useSelector)(search_1.isSearching);
    if (!convoProps) {
        return null;
    }
    const { lastMessage, isTyping, unreadCount } = convoProps;
    if (!lastMessage && unreadCount === 1) {
        return react_1.default.createElement("div", { style: { width: '81%' } });
    }
    if (!lastMessage && !isTyping) {
        return null;
    }
    const text = lastMessage?.text || '';
    if ((0, lodash_1.isEmpty)(text)) {
        return null;
    }
    return (react_1.default.createElement("div", { className: "module-conversation-list-item__message" },
        react_1.default.createElement("div", { className: (0, classnames_1.default)('module-conversation-list-item__message__text', unreadCount > 0 ? 'module-conversation-list-item__message__text--has-unread' : null) }, isTyping ? (react_1.default.createElement(TypingAnimation_1.TypingAnimation, null)) : (react_1.default.createElement(MessageBody_1.MessageBody, { text: text, disableJumbomoji: true, disableLinks: true, isGroup: isGroup }))),
        !isSearchingMode && lastMessage && lastMessage.status && !props.isMessageRequest ? (react_1.default.createElement(react_1.default.Fragment, null)) : null));
};
exports.MessageItem = MessageItem;
