"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserItem = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const useParamSelector_1 = require("../../../hooks/useParamSelector");
const types_1 = require("../../../bchat/types");
const search_1 = require("../../../state/selectors/search");
const ContactName_1 = require("../../conversation/ContactName");
const ConversationListItem_1 = require("./ConversationListItem");
const UserItem = () => {
    const conversationId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isSearchResultsMode = (0, react_redux_1.useSelector)(search_1.isSearching);
    const shortenedPubkey = types_1.PubKey.shorten(conversationId);
    const isMe = (0, useParamSelector_1.useIsMe)(conversationId);
    const username = (0, useParamSelector_1.useConversationUsername)(conversationId);
    const realName = (0, useParamSelector_1.useConversationRealName)(conversationId);
    const hasNickname = (0, useParamSelector_1.useHasNickname)(conversationId);
    const displayedPubkey = username ? shortenedPubkey : conversationId;
    const displayName = isMe
        ? window.i18n('noteToSelf')
        : isSearchResultsMode && hasNickname && realName
            ? `${realName} (${username})`
            : username;
    let shouldShowPubkey = false;
    if ((!username || username.length === 0) && (!displayName || displayName.length === 0)) {
        shouldShowPubkey = true;
    }
    return (react_1.default.createElement("div", { className: "module-conversation__user" },
        react_1.default.createElement(ContactName_1.ContactName, { pubkey: displayedPubkey, name: username, profileName: displayName, module: "module-conversation__user", boldProfileName: true, shouldShowPubkey: shouldShowPubkey })));
};
exports.UserItem = UserItem;
