"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatJoinableRooms = exports.BchatJoinableRoomAvatar = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const styled_components_1 = __importDefault(require("styled-components"));
const JoinOpenGroupV2_1 = require("../../../bchat/apis/open_group_api/opengroupV2/JoinOpenGroupV2");
const OpenGroupAPIV2_1 = require("../../../bchat/apis/open_group_api/opengroupV2/OpenGroupAPIV2");
const defaultRooms_1 = require("../../../state/ducks/defaultRooms");
const Avatar_1 = require("../../avatar/Avatar");
const Flex_1 = require("../../basic/Flex");
const PillContainer_1 = require("../../basic/PillContainer");
const BchatSpinner_1 = require("../../basic/BchatSpinner");
const Text_1 = require("../../basic/Text");
const BchatIcon_1 = require("../../icon/BchatIcon");
const BchatJoinableRoomAvatar = (props) => {
    const dispatch = (0, react_redux_1.useDispatch)();
    (0, react_1.useEffect)(() => {
        let isCancelled = false;
        try {
            const parsedInfos = (0, JoinOpenGroupV2_1.parseOpenGroupV2)(props.completeUrl);
            if (parsedInfos) {
                if (props.base64Data) {
                    return;
                }
                if (isCancelled) {
                    return;
                }
                (0, OpenGroupAPIV2_1.downloadPreviewOpenGroupV2)(parsedInfos)
                    .then(base64 => {
                    if (isCancelled) {
                        return;
                    }
                    const payload = {
                        roomId: props.roomId,
                        base64Data: base64 || '',
                    };
                    dispatch((0, defaultRooms_1.updateDefaultBase64RoomData)(payload));
                })
                    .catch(e => {
                    if (isCancelled) {
                        return;
                    }
                    window?.log?.warn('downloadPreviewOpenGroupV2 failed', e);
                    const payload = {
                        roomId: props.roomId,
                        base64Data: '',
                    };
                    dispatch((0, defaultRooms_1.updateDefaultBase64RoomData)(payload));
                });
            }
        }
        catch (e) {
            window?.log?.warn(e);
        }
        return () => {
            isCancelled = true;
        };
    }, [props.imageId, props.completeUrl]);
    return (react_1.default.createElement(react_1.default.Fragment, null, props.base64Data ? (react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.L, base64Data: props.base64Data, ...props, pubkey: "", onAvatarClick: () => props.onClick(props.completeUrl) })) : (react_1.default.createElement(IconWrapper, { direcrion: props?.direction },
        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'peopleGrp', iconSize: 40 })))));
};
exports.BchatJoinableRoomAvatar = BchatJoinableRoomAvatar;
const StyledRoomName = (0, styled_components_1.default)(Flex_1.Flex) `
  overflow: hidden;
  white-space: nowrap;
  text-overflow: ellipsis;
  padding: 0 10px;
  font-size: 13px;
`;
const Grid = styled_components_1.default.div `
  display: grid;
  grid-template-columns: 33.3% 33.3% 33.3%;
  gap: 12px 10px;
`;
const IconWrapper = styled_components_1.default.div `
  background-color: ${props => props.direcrion === 'outgoing' ? '#108d32' : 'var(--color-invite-card-icon-bg)'};
  width: 60px;
  height: 60px;
  display: flex;
  justify-content: center;
  align-items: center;
  border-radius: 10px;
`;
const BchatJoinableRoomName = (props) => {
    return react_1.default.createElement(StyledRoomName, null, props.name);
};
const BchatJoinableRoomRow = (props) => {
    return (react_1.default.createElement(PillContainer_1.PillTooltipWrapper, null,
        react_1.default.createElement(PillContainer_1.PillContainerHoverable, { onClick: () => {
                props.onClick(props.completeUrl);
            }, padding: "5px" },
            react_1.default.createElement(exports.BchatJoinableRoomAvatar, { ...props }),
            react_1.default.createElement(Text_1.SpacerXS, null),
            react_1.default.createElement(BchatJoinableRoomName, { ...props }))));
};
const BchatJoinableRooms = (props) => {
    const joinableRooms = (0, react_redux_1.useSelector)((state) => state.defaultRooms);
    const onRoomClicked = (0, react_1.useCallback)((loading) => {
        if (loading) {
            props.onRoomClicked();
        }
    }, [props.onRoomClicked]);
    if (!joinableRooms.inProgress && !joinableRooms.rooms?.length) {
        window?.log?.info('no default joinable rooms yet and not in progress');
        return null;
    }
    const componentToRender = joinableRooms.inProgress ? (react_1.default.createElement(BchatSpinner_1.BchatSpinner, { loading: false })) : (joinableRooms.rooms.map(r => {
        return (react_1.default.createElement(BchatJoinableRoomRow, { key: r.id, completeUrl: r.completeUrl, name: r.name, roomId: r.id, base64Data: r.base64Data, onClick: completeUrl => {
                void (0, JoinOpenGroupV2_1.joinOpenGroupV2WithUIEvents)(completeUrl, true, false, onRoomClicked);
            } }));
    }));
    return (react_1.default.createElement(Flex_1.Flex, { container: true, flexGrow: 1, flexDirection: "column", width: "93%" },
        react_1.default.createElement("div", { className: "module-left-pane-overlay-open-title" }, window.i18n('orJoinOneOfThese')),
        react_1.default.createElement(Grid, null, componentToRender)));
};
exports.BchatJoinableRooms = BchatJoinableRooms;
