"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OverlayCallHistory = void 0;
const react_1 = __importStar(require("react"));
const Text_1 = require("../../basic/Text");
const icon_1 = require("../../icon");
const classnames_1 = __importDefault(require("classnames"));
const useParamSelector_1 = require("../../../hooks/useParamSelector");
const Flex_1 = require("../../basic/Flex");
const react_redux_1 = require("react-redux");
const moment_1 = __importDefault(require("moment"));
const conversations_1 = require("../../../bchat/conversations");
const conversations_2 = require("../../../state/ducks/conversations");
const callHistory_1 = require("../../../state/selectors/callHistory");
const ContactEmptyIcon_1 = __importDefault(require("../../icon/ContactEmptyIcon"));
const theme_1 = require("../../../state/selectors/theme");
const styled_components_1 = __importDefault(require("styled-components"));
const call_1 = require("../../../state/selectors/call");
const conversationInteractions_1 = require("../../../interactions/conversationInteractions");
const Avatar_1 = require("../../avatar/Avatar");
const style = {
    'missed-call': {
        notificationText: 'Missed Call',
        iconType: 'callMissed',
        iconColor: '#FF3E3E',
    },
    'started-call': {
        notificationText: 'Outgoing',
        iconType: 'callOutgoing',
        iconColor: 'var(--color-text)',
    },
    'answered-a-call': {
        notificationText: 'Incoming',
        iconType: 'callIncoming',
        iconColor: 'var(--color-text)',
    },
};
const OverlayCallHistory = () => {
    const callHistoryList = (0, react_redux_1.useSelector)(callHistory_1.getCallHistoryList);
    const [currentSearchTerm, setCurrentSearchTerm] = (0, react_1.useState)('');
    const hasIncomingCall = (0, react_redux_1.useSelector)(call_1.getHasIncomingCall);
    const hasOngoingCall = (0, react_redux_1.useSelector)(call_1.getHasOngoingCall);
    const canCall = !(hasIncomingCall || hasOngoingCall);
    const filteredList = (0, react_1.useMemo)(() => {
        if (!currentSearchTerm)
            return callHistoryList;
        return callHistoryList.filter((item) => {
            const convo = (0, conversations_1.getConversationController)().get(item.conversationId);
            const memberName = convo?.getNickname() || convo?.getName() || convo?.getProfileName();
            return memberName?.toLowerCase().includes(currentSearchTerm.toLowerCase());
        });
    }, [callHistoryList, currentSearchTerm]);
    const handleSearch = (event) => {
        setCurrentSearchTerm(event.target.value);
    };
    const openConverstation = async (pubKey, messageId) => {
        await (0, conversations_2.openConversationWithMessages)({ conversationKey: pubKey, messageId: messageId });
        void (0, conversationInteractions_1.callRecipient)(pubKey, canCall);
    };
    return (react_1.default.createElement("div", { className: "module-left-pane-overlay", style: { overflow: 'hidden' } },
        react_1.default.createElement("div", { className: "module-left-pane-overlay-call-history" },
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", { className: "module-left-pane-overlay-call-history--header" },
                react_1.default.createElement("div", { className: "module-left-pane-overlay-call-history--header-txt" }, "Call History"),
                react_1.default.createElement(Text_1.SpacerMD, null),
                react_1.default.createElement("div", { className: "bchat-search-input", style: { paddingRight: '5px' } },
                    react_1.default.createElement("div", { className: "search" },
                        react_1.default.createElement(icon_1.BchatIcon, { iconSize: 20, iconType: "search" })),
                    react_1.default.createElement("input", { value: currentSearchTerm, onChange: e => {
                            handleSearch(e);
                        }, placeholder: 'Search People', maxLength: 26 }),
                    !!currentSearchTerm.length && (react_1.default.createElement(icon_1.BchatIconButton, { iconSize: 24, iconType: "exit", onClick: () => {
                            setCurrentSearchTerm('');
                        } })))),
            react_1.default.createElement(Text_1.SpacerMD, null),
            react_1.default.createElement("div", { className: "content-box-wrapper " }, filteredList.length === 0 ? (react_1.default.createElement(SearchEmptyScreen, null)) : (filteredList.map((item, key) => (react_1.default.createElement(ContactList, { key: key, openConverstation: openConverstation, ...item }))))))));
};
exports.OverlayCallHistory = OverlayCallHistory;
const ContactList = (props) => {
    const { conversationId, callNotificationType, call_details, received_at, openConverstation, } = props;
    const username = (0, useParamSelector_1.useConversationUsernameOrShorten)(conversationId);
    const isBnsHolder = (0, useParamSelector_1.useConversationBnsHolder)(conversationId);
    const styleItem = style[callNotificationType];
    const callCategoryText = styleItem.notificationText;
    const iconType = styleItem.iconType;
    const iconColor = styleItem.iconColor;
    const subtext = `${callCategoryText}${call_details.length > 1 ? ` (${call_details.length})` : ''}`;
    const lastCallMessageId = call_details[0].messageId;
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement("div", { className: (0, classnames_1.default)(`content-box`) },
            react_1.default.createElement(Flex_1.Flex, { container: true, alignItems: 'center' },
                react_1.default.createElement("div", { className: "avatarBox" },
                    react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.L, pubkey: conversationId, isBnsHolder: isBnsHolder })),
                react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column", margin: "0 15px" },
                    react_1.default.createElement("div", null,
                        react_1.default.createElement("span", { className: (0, classnames_1.default)('username') }, username)),
                    react_1.default.createElement(Text_1.SpacerXS, null),
                    react_1.default.createElement("div", { className: 'address' },
                        react_1.default.createElement(icon_1.BchatIcon, { iconType: iconType, iconSize: 14, iconColor: iconColor }),
                        react_1.default.createElement("span", { style: { margin: '0 5px', color: iconColor } }, subtext),
                        "- ",
                        formatMessageTime(received_at)))),
            react_1.default.createElement(icon_1.BchatIconButton, { iconSize: 24, iconType: 'call', onClick: () => openConverstation(conversationId, lastCallMessageId), fillRule: "evenodd", clipRule: "evenodd" })),
        react_1.default.createElement(Text_1.SpacerXS, null)));
};
const SearchEmptyScreen = () => {
    const isDark = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    return (react_1.default.createElement(SearchEmptyWrapper, null,
        react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column", justifyContent: "center", alignItems: "center" },
            react_1.default.createElement(ContactEmptyIcon_1.default, { isDark: isDark }),
            react_1.default.createElement(StyledSpan, null, "No Contact Found!"))));
};
const SearchEmptyWrapper = styled_components_1.default.div `
  height: calc(100vh - 286px);
  width: 100%;
  display: flex;
  justify-content: center;
`;
const StyledSpan = styled_components_1.default.span `
  color: #a7a7ba;
  text-align: center;
  font-family: $bchat-font-open-sans;
  font-size: 16px;
  font-style: normal;
  font-weight: 600;
  line-height: normal;
`;
const formatMessageTime = (timestamp) => {
    const m = (0, moment_1.default)(timestamp);
    const now = (0, moment_1.default)();
    if (m.isSame(now, 'day')) {
        return m.format('hh:mm A');
    }
    else if (m.isSame(now, 'year')) {
        return m.format('DD MMM');
    }
    else {
        return m.format('DD MMM YY');
    }
};
