"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OverlayClosedGroup = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const BchatIdEditable_1 = require("../../basic/BchatIdEditable");
const BchatSpinner_1 = require("../../basic/BchatSpinner");
const MemberListItem_1 = require("../../MemberListItem");
const section_1 = require("../../../state/ducks/section");
const conversations_1 = require("../../../state/selectors/conversations");
const Text_1 = require("../../basic/Text");
const MainViewController_1 = require("../../MainViewController");
const useKey_1 = __importDefault(require("react-use/lib/useKey"));
const BchatIcon_1 = require("../../icon/BchatIcon");
const conversations_2 = require("../../../bchat/conversations");
const BchatButton_1 = require("../../basic/BchatButton");
const BchatWrapperModal_1 = require("../../BchatWrapperModal");
const OverlayClosedGroup = () => {
    const dispatch = (0, react_redux_1.useDispatch)();
    const privateContactsPubkeys = (0, react_redux_1.useSelector)(conversations_1.getPrivateContactsPubkeys);
    const [groupName, setGroupName] = (0, react_1.useState)('');
    const [loading, setLoading] = (0, react_1.useState)(false);
    const [selectedMemberIds, setSelectedMemberIds] = (0, react_1.useState)([]);
    const [currentSearchTerm, setCurrentSearchTerm] = (0, react_1.useState)('');
    const [filteredNames, setFilteredNames] = (0, react_1.useState)(privateContactsPubkeys);
    const zoomLevel = window.getSettingValue('zoom-factor-setting');
    function closeOverlay() {
        dispatch((0, section_1.setOverlayMode)(undefined));
    }
    function handleSelectMember(memberId) {
        if (selectedMemberIds.includes(memberId)) {
            return;
        }
        setSelectedMemberIds([...selectedMemberIds, memberId]);
    }
    function handleUnselectMember(unselectId) {
        setSelectedMemberIds(selectedMemberIds.filter(id => {
            return id !== unselectId;
        }));
    }
    const handleSearch = (event) => {
        const value = event.target.value;
        setCurrentSearchTerm(value);
        setFilteredNames(value
            ? privateContactsPubkeys.filter((pubkey) => {
                const convo = (0, conversations_2.getConversationController)().get(pubkey);
                const memberName = convo?.getNickname() || convo?.getName() || convo?.getProfileName();
                return memberName?.toLowerCase().includes(value.toLowerCase());
            })
            : privateContactsPubkeys);
    };
    async function onEnterPressed() {
        if (loading) {
            window?.log?.warn('Closed group creation already in progress');
            return;
        }
        setLoading(true);
        const groupCreated = await MainViewController_1.MainViewController.createClosedGroup(groupName, selectedMemberIds);
        if (groupCreated) {
            closeOverlay();
            dispatch((0, section_1.showLeftPaneSection)(0));
            dispatch((0, section_1.setOverlayMode)(undefined));
            return;
        }
        setLoading(false);
    }
    (0, useKey_1.default)('Escape', closeOverlay);
    const title = window.i18n('newSecretGroup');
    const subtitle = window.i18n('createSecretGroupNamePrompt');
    const placeholder = window.i18n('createSecretGroupPlaceholder');
    const noContactsForClosedGroup = privateContactsPubkeys.length === 0;
    return (react_1.default.createElement("div", { className: "module-left-pane-overlay" },
        react_1.default.createElement("div", { style: {
                height: `calc(100% - 115px)`,
                overflowY: 'auto',
                padding: '15px',
            } },
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", { className: "module-left-pane-overlay-closed--header" }, title),
            react_1.default.createElement(Text_1.SpacerLG, null),
            !noContactsForClosedGroup && (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement("div", { className: "module-left-pane-overlay-closed--subHeader" }, subtitle),
                react_1.default.createElement(Text_1.SpacerXS, null),
                react_1.default.createElement("div", { className: "create-group-name-input" },
                    react_1.default.createElement(BchatIdEditable_1.BchatIdEditable, { editable: !noContactsForClosedGroup, placeholder: placeholder, value: groupName, isGroup: true, maxLength: 32, onChange: setGroupName, onPressEnter: onEnterPressed, dataTestId: "new-closed-group-name" })),
                react_1.default.createElement(Text_1.SpacerLG, null),
                react_1.default.createElement("div", null,
                    react_1.default.createElement("label", { className: "module-left-pane-overlay-closed--search-label" },
                        ' ',
                        "Select Contacts"),
                    react_1.default.createElement(Text_1.SpacerXS, null),
                    react_1.default.createElement("div", { className: "bchat-search-input" },
                        react_1.default.createElement("div", { className: "search" },
                            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconSize: 20, iconType: "search" })),
                        react_1.default.createElement("input", { value: currentSearchTerm, onChange: e => {
                                handleSearch(e);
                            }, placeholder: 'Search Contact', maxLength: 26 }))))),
            react_1.default.createElement(Text_1.SpacerMD, null),
            loading && (react_1.default.createElement(BchatWrapperModal_1.Loader, null,
                react_1.default.createElement(BchatSpinner_1.BchatSpinner, { loading: loading }))),
            react_1.default.createElement("div", { style: { height: '58.5%' } }, noContactsForClosedGroup ? (react_1.default.createElement("div", { className: "group-member-list__no-contacts" },
                react_1.default.createElement("div", { className: "group-member-list__addImg" }),
                react_1.default.createElement("h4", { className: "module-left-pane__empty_contact" }, window.i18n('noContactsYet')),
                react_1.default.createElement(Text_1.SpacerMD, null))) : (react_1.default.createElement("div", { className: "group-member-list__container", style: { overflow: zoomLevel > 100 ? 'unset' : 'auto' } },
                react_1.default.createElement("div", { className: "group-member-list__selection" }, filteredNames.map((memberPubkey) => (react_1.default.createElement(MemberListItem_1.MemberListItem, { pubkey: memberPubkey, isSelected: selectedMemberIds.some(m => m === memberPubkey), key: memberPubkey, onSelect: selectedMember => {
                        handleSelectMember(selectedMember);
                    }, onUnselect: unselectedMember => {
                        handleUnselectMember(unselectedMember);
                    } })))))))),
        !noContactsForClosedGroup && (react_1.default.createElement("div", { className: "buttonBox", style: { paddingTop: '5px' } },
            react_1.default.createElement(BchatButton_1.BchatButton, { buttonColor: BchatButton_1.BchatButtonColor.Primary, buttonType: BchatButton_1.BchatButtonType.Brand, text: 'Create', disabled: noContactsForClosedGroup || groupName.trim().length === 0, dataTestId: "next-button", onClick: onEnterPressed })))));
};
exports.OverlayClosedGroup = OverlayClosedGroup;
