"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OverlayMessageRequest = void 0;
const react_1 = __importDefault(require("react"));
const Text_1 = require("../../basic/Text");
const react_redux_1 = require("react-redux");
const conversations_1 = require("../../../state/selectors/conversations");
const ConversationListItem_1 = require("../conversation-list-item/ConversationListItem");
const styled_components_1 = __importDefault(require("styled-components"));
const BchatButton_1 = require("../../basic/BchatButton");
const section_1 = require("../../../state/ducks/section");
const conversations_2 = require("../../../bchat/conversations");
const syncUtils_1 = require("../../../bchat/utils/syncUtils");
const util_1 = require("../../../util");
const useKey_1 = __importDefault(require("react-use/lib/useKey"));
const conversations_3 = require("../../../state/ducks/conversations");
const modalDialog_1 = require("../../../state/ducks/modalDialog");
const MessageRequestInSettings_1 = require("../../settings/MessageRequestInSettings");
const BchatIconButton_1 = require("../../icon/BchatIconButton");
const Flex_1 = require("../../basic/Flex");
const OverlayMessageRequest = (props) => {
    (0, useKey_1.default)('Escape', closeOverlay);
    const dispatch = (0, react_redux_1.useDispatch)();
    function closeOverlay() {
        dispatch((0, section_1.setOverlayMode)(undefined));
    }
    const convoRequestCount = (0, react_redux_1.useSelector)(conversations_1.getConversationRequests).length;
    const messageRequests = (0, react_redux_1.useSelector)(conversations_1.getConversationRequests);
    const selectedConversation = (0, react_redux_1.useSelector)(conversations_1.getSelectedConversation);
    const { leftPane } = props;
    const buttonText = window.i18n('clearAll');
    function handleClearAllRequestsClick(convoRequests) {
        const { i18n } = window;
        const title = i18n('clearAllConfirmationTitle');
        const message = i18n('clearAllConfirmationBody');
        const onClose = dispatch((0, modalDialog_1.updateConfirmModal)(null));
        dispatch((0, modalDialog_1.updateConfirmModal)({
            title,
            message,
            onClose,
            okTheme: BchatButton_1.BchatButtonColor.Danger,
            onClickOk: async () => {
                window?.log?.info('Blocking all conversations');
                if (!convoRequests) {
                    window?.log?.info('No conversation requests to block.');
                    return;
                }
                let newConvosBlocked = [];
                const convoController = (0, conversations_2.getConversationController)();
                await Promise.all((newConvosBlocked = convoRequests.filter(async (convo) => {
                    const { id } = convo;
                    const convoModel = convoController.get(id);
                    if (!convoModel.isBlocked()) {
                        await util_1.BlockedNumberController.block(id);
                        await convoModel.commit();
                    }
                    await convoModel.setIsApproved(false);
                    if (selectedConversation?.id === id) {
                        dispatch((0, conversations_3.resetConversationExternal)());
                    }
                    return true;
                })));
                if (newConvosBlocked) {
                    await (0, syncUtils_1.forceSyncConfigurationNowIfNeeded)();
                }
                if (convoRequestCount === newConvosBlocked.length) {
                    dispatch((0, section_1.setOverlayMode)(undefined));
                    dispatch((0, section_1.showLeftPaneSection)(section_1.SectionType.Message));
                    dispatch((0, conversations_3.resetConversationExternal)());
                }
            },
        }));
    }
    const VerifyScreen = () => {
        if (props.settings) {
            return react_1.default.createElement(MessageRequestListForSetting, null);
        }
        else {
            return react_1.default.createElement(MessageRequestList, null);
        }
    };
    return (react_1.default.createElement("div", { className: "module-left-pane-overlay", style: {
            width: props?.settings ? '100%' : '',
            maxWidth: props?.settings ? '100%' : '',
            backgroundColor: 'unset'
        } }, convoRequestCount ? (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(VerifyScreen, null),
        react_1.default.createElement(Text_1.SpacerLG, null),
        react_1.default.createElement(Text_1.SpacerLG, null),
        react_1.default.createElement("div", { className: "messageRequestButton" },
            react_1.default.createElement(BchatButton_1.BchatButton, { style: {
                    height: '55px',
                    fontSize: '16px',
                    fontWeight: '500',
                }, buttonColor: BchatButton_1.BchatButtonColor.Danger, buttonType: BchatButton_1.BchatButtonType.Brand, text: buttonText, onClick: () => {
                    handleClearAllRequestsClick(messageRequests);
                } })))) : (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(Text_1.SpacerLG, null),
        react_1.default.createElement("div", { className: "bchat-noMsgRequest-box" },
            react_1.default.createElement("div", { className: leftPane ? 'bchat-noMsgRequest-leftPane' : 'bchat-noMsgRequest' }),
            react_1.default.createElement("div", { className: "content-txt" }, window.i18n('noMessageRequestsPending')))))));
};
exports.OverlayMessageRequest = OverlayMessageRequest;
const MessageRequestListContainer = styled_components_1.default.div `
  padding: 15px;
  max-height:75vh;
  overflow-y: auto;
  // margin-bottom: auto;
`;
const MessageRequestList = () => {
    const conversationRequests = (0, react_redux_1.useSelector)(conversations_1.getConversationRequests);
    const dispatch = (0, react_redux_1.useDispatch)();
    return (react_1.default.createElement(MessageRequestListContainer, null,
        react_1.default.createElement(Text_1.SpacerLG, null),
        react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: 'row', alignItems: 'center', className: "module-left-pane-overlay-closed--header" },
            ' ',
            react_1.default.createElement(BchatIconButton_1.BchatIconButton, { onClick: () => {
                    dispatch((0, section_1.setOverlayMode)(undefined));
                }, iconType: "chevron", iconRotation: 90, iconSize: "large" }),
            react_1.default.createElement("span", null, window.i18n('messageRequests'))),
        react_1.default.createElement(Text_1.SpacerLG, null),
        conversationRequests.map(conversation => {
            return (react_1.default.createElement(ConversationListItem_1.MemoConversationListItemWithDetails, { key: conversation.id, isMessageRequest: true, ...conversation }));
        })));
};
const MessageRequestListForSetting = () => {
    const conversationRequests = (0, react_redux_1.useSelector)(conversations_1.getConversationRequests);
    return (react_1.default.createElement(MessageRequestListContainer, null, conversationRequests.map(conversation => {
        return (react_1.default.createElement(MessageRequestInSettings_1.MemoMessageRequestListSetting, { key: conversation.id, isMessageRequest: true, ...conversation }));
    })));
};
