"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MemoConversationListItemContextMenu = void 0;
const react_1 = __importDefault(require("react"));
const react_contexify_1 = require("react-contexify");
const lodash_1 = __importDefault(require("lodash"));
const Menu_1 = require("./Menu");
const ConversationListItemContextMenu = (props) => {
    const { triggerId } = props;
    return (react_1.default.createElement(react_contexify_1.Menu, { id: triggerId, animation: react_contexify_1.animation.fade, className: 'convoListContextMenu' },
        react_1.default.createElement(Menu_1.AcceptMenuItem, null),
        react_1.default.createElement(Menu_1.DeclineMenuItem, null),
        react_1.default.createElement(Menu_1.NotificationForConvoMenuItem, null),
        react_1.default.createElement(Menu_1.PinConversationMenuItem, null),
        react_1.default.createElement(Menu_1.BlockMenuItem, null),
        react_1.default.createElement(Menu_1.CopyMenuItem, null),
        react_1.default.createElement(Menu_1.MarkAllReadMenuItem, null),
        react_1.default.createElement(Menu_1.ChangeNicknameMenuItem, null),
        react_1.default.createElement(Menu_1.ClearNicknameMenuItem, null),
        react_1.default.createElement(Menu_1.DeleteMessagesMenuItem, null),
        react_1.default.createElement(Menu_1.BanMenuItem, null),
        react_1.default.createElement(Menu_1.UnbanMenuItem, null),
        react_1.default.createElement(Menu_1.InviteContactMenuItem, null),
        react_1.default.createElement(Menu_1.DeleteContactMenuItem, null),
        react_1.default.createElement(Menu_1.LeaveGroupMenuItem, null)));
};
function propsAreEqual(prev, next) {
    return lodash_1.default.isEqual(prev, next);
}
exports.MemoConversationListItemContextMenu = react_1.default.memo(ConversationListItemContextMenu, propsAreEqual);
