"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeclineMenuItem = exports.AcceptMenuItem = exports.HideBannerMenuItem = exports.DeleteMessagesMenuItem = exports.ChangeNicknameMenuItem = exports.ClearNicknameMenuItem = exports.BlockMenuItem = exports.isRtlBody = exports.NotificationForConvoMenuItem = exports.DisappearingMessageMenuItem = exports.MarkAllReadMenuItem = exports.CopyMenuItem = exports.BanMenuItem = exports.UnbanMenuItem = exports.AddModeratorsMenuItem = exports.RemoveModeratorsMenuItem = exports.UpdateGroupNameMenuItem = exports.LeaveGroupMenuItem = exports.DeleteContactMenuItem = exports.PinConversationMenuItem = exports.InviteContactMenuItem = exports.MenuWrapper = void 0;
const react_1 = __importStar(require("react"));
const react_contexify_1 = require("react-contexify");
const react_redux_1 = require("react-redux");
const useParamSelector_1 = require("../../hooks/useParamSelector");
const conversationInteractions_1 = require("../../interactions/conversationInteractions");
const conversation_1 = require("../../models/conversation");
const conversations_1 = require("../../bchat/conversations");
const utils_1 = require("../../bchat/utils");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const section_1 = require("../../state/ducks/section");
const userConfig_1 = require("../../state/ducks/userConfig");
const conversations_2 = require("../../state/selectors/conversations");
const section_2 = require("../../state/selectors/section");
const timerOptions_1 = require("../../state/selectors/timerOptions");
const BchatButton_1 = require("../basic/BchatButton");
const ConversationListItem_1 = require("../leftpane/conversation-list-item/ConversationListItem");
const user_1 = require("../../state/selectors/user");
const BchatIcon_1 = require("../icon/BchatIcon");
const styled_components_1 = __importDefault(require("styled-components"));
const DeclineMessageRequest_1 = __importDefault(require("../icon/DeclineMessageRequest"));
const maxNumberOfPinnedConversations = 5;
function showTimerOptions(isPublic, isKickedFromGroup, left, isBlocked, isRequest) {
    return !isPublic && !left && !isKickedFromGroup && !isBlocked && !isRequest;
}
function showNotificationConvo(isKickedFromGroup, left, isBlocked, isRequest, isMe) {
    return !left && !isKickedFromGroup && !isBlocked && !isRequest && !isMe;
}
function showBlock(isMe, isPrivate, isRequest) {
    return !isMe && isPrivate && !isRequest;
}
function showClearNickname(isMe, hasNickname, isPrivate, isRequest) {
    return !isMe && hasNickname && isPrivate && isRequest;
}
function showChangeNickname(isMe, isPrivate, isRequest) {
    return !isMe && isPrivate && !isRequest;
}
function showCopyId(isPublic, isPrivate) {
    return isPrivate || isPublic;
}
function showDeleteContact(isGroup, isPublic, isGroupLeft, isKickedFromGroup, isRequest) {
    return (!isGroup && !isRequest) || (isGroup && (isGroupLeft || isKickedFromGroup || isPublic));
}
const showUnbanUser = (weAreAdmin, isPublic, isKickedFromGroup) => {
    return !isKickedFromGroup && weAreAdmin && isPublic;
};
const showBanUser = (weAreAdmin, isPublic, isKickedFromGroup) => {
    return !isKickedFromGroup && weAreAdmin && isPublic;
};
function showAddModerators(weAreAdmin, isPublic, isKickedFromGroup) {
    return !isKickedFromGroup && weAreAdmin && isPublic;
}
function showRemoveModerators(weAreAdmin, isPublic, isKickedFromGroup) {
    return !isKickedFromGroup && weAreAdmin && isPublic;
}
function showUpdateGroupName(weAreAdmin, isKickedFromGroup, left) {
    return !isKickedFromGroup && !left && weAreAdmin;
}
function showLeaveGroup(isKickedFromGroup, left, isGroup, isPublic) {
    return !isKickedFromGroup && !left && isGroup && !isPublic;
}
function showInviteContact(isPublic) {
    return isPublic;
}
exports.MenuWrapper = styled_components_1.default.span `
  margin-left: 12px;
  margin-right: 10px;
`;
const InviteContactMenuItem = () => {
    const convoId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isPublic = (0, useParamSelector_1.useIsPublic)(convoId);
    if (showInviteContact(isPublic)) {
        return (react_1.default.createElement(react_contexify_1.Item, { onClick: () => {
                (0, conversationInteractions_1.showInviteContactByConvoId)(convoId);
            } },
            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'inviteContact', iconSize: 20, fillRule: "evenodd", clipRule: "evenodd" }),
            react_1.default.createElement(exports.MenuWrapper, null, window.i18n('inviteContacts'))));
    }
    return null;
};
exports.InviteContactMenuItem = InviteContactMenuItem;
const PinConversationMenuItem = () => {
    const conversationId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isMessagesSection = (0, react_redux_1.useSelector)(section_2.getFocusedSection) === section_1.SectionType.Message;
    const nbOfAlreadyPinnedConvos = (0, react_redux_1.useSelector)(conversations_2.getNumberOfPinnedConversations);
    const isRequest = (0, useParamSelector_1.useIsRequest)(conversationId);
    if (isMessagesSection && !isRequest) {
        const conversation = (0, conversations_1.getConversationController)().get(conversationId);
        const isPinned = conversation?.isPinned() || false;
        const togglePinConversation = async () => {
            if ((!isPinned && nbOfAlreadyPinnedConvos < maxNumberOfPinnedConversations) || isPinned) {
                await conversation?.setIsPinned(!isPinned);
            }
            else {
                utils_1.ToastUtils.pushToastWarning('pinConversationLimitToast', window.i18n('pinConversationLimitTitle'), window.i18n('pinConversationLimitToastDescription', [`${maxNumberOfPinnedConversations}`]));
            }
        };
        const menuText = isPinned ? window.i18n('unpinConversation') : window.i18n('pinConversation');
        return (react_1.default.createElement(react_contexify_1.Item, { onClick: togglePinConversation },
            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "pinSubMenu", iconSize: 20, fillRule: "evenodd", clipRule: "evenodd" }),
            ' ',
            react_1.default.createElement(exports.MenuWrapper, null, menuText)));
    }
    return null;
};
exports.PinConversationMenuItem = PinConversationMenuItem;
const DeleteContactMenuItem = () => {
    const dispatch = (0, react_redux_1.useDispatch)();
    const convoId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isPublic = (0, useParamSelector_1.useIsPublic)(convoId);
    const isLeft = (0, useParamSelector_1.useIsLeft)(convoId);
    const isKickedFromGroup = (0, useParamSelector_1.useIsKickedFromGroup)(convoId);
    const isPrivate = (0, useParamSelector_1.useIsPrivate)(convoId);
    const isRequest = (0, useParamSelector_1.useIsRequest)(convoId);
    const ourNumber = (0, react_redux_1.useSelector)(user_1.getOurNumber);
    const username = String((0, useParamSelector_1.useConversationUsername)(convoId));
    if (showDeleteContact(!isPrivate, isPublic, isLeft, isKickedFromGroup, isRequest)) {
        let menuItemText;
        if (isPublic) {
            menuItemText = window.i18n('leaveGroup');
        }
        else {
            menuItemText = isPrivate
                ? window.i18n('editMenuDeleteContact')
                : window.i18n('editMenuDeleteGroup');
        }
        const onClickClose = () => {
            dispatch((0, modalDialog_1.updateConfirmModal)(null));
        };
        const showConfirmationModal = () => {
            let notetoSelf = {
                title: menuItemText,
                message: "This chat is for your self reference.So can't be deleted.",
                onClickClose,
                okTheme: BchatButton_1.BchatButtonColor.Primary,
                onClickOk: async () => {
                    onClickClose;
                },
                okText: 'OK',
                hideCancel: true,
            };
            let contactDelete = {
                title: menuItemText,
                message: isPrivate
                    ? 'Permanently delete the Contact?'
                    : window.i18n('leaveGroupConfirmation', [username]),
                onClickClose,
                onClickOk: async () => {
                    await (0, conversations_1.getConversationController)().deleteContact(convoId);
                    utils_1.ToastUtils.pushToastSuccess('', 'Contact has been successfully deleted.');
                },
                okText: menuItemText.slice(0, 5) === 'Leave' ? 'Leave' : 'Delete',
                okTheme: BchatButton_1.BchatButtonColor.Danger,
            };
            dispatch((0, modalDialog_1.updateConfirmModal)(ourNumber === convoId ? notetoSelf : contactDelete));
        };
        return (react_1.default.createElement(react_contexify_1.Item, { onClick: showConfirmationModal },
            ' ',
            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: window.i18n('leaveGroup') === menuItemText ? 'leaveGroup' : 'deleteContact', iconSize: 20, iconColor: "#FF3E3E", fillRule: "evenodd", clipRule: "evenodd" }),
            ' ',
            react_1.default.createElement(exports.MenuWrapper, { style: { color: '#FF3E3E' } }, menuItemText)));
    }
    return null;
};
exports.DeleteContactMenuItem = DeleteContactMenuItem;
const LeaveGroupMenuItem = () => {
    const convoId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isPublic = (0, useParamSelector_1.useIsPublic)(convoId);
    const isLeft = (0, useParamSelector_1.useIsLeft)(convoId);
    const isKickedFromGroup = (0, useParamSelector_1.useIsKickedFromGroup)(convoId);
    const isPrivate = (0, useParamSelector_1.useIsPrivate)(convoId);
    const username = String((0, useParamSelector_1.useConversationUsername)(convoId));
    if (showLeaveGroup(isKickedFromGroup, isLeft, !isPrivate, isPublic)) {
        return (react_1.default.createElement(react_contexify_1.Item, { onClick: () => {
                (0, conversationInteractions_1.showLeaveGroupByConvoId)(convoId, username, react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "leaveGroup", iconColor: "#FF3E3E", iconSize: 30 }));
            } },
            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'leave', iconSize: 20, fillRule: "evenodd", clipRule: "evenodd", iconColor: "#FF3E3E" }),
            react_1.default.createElement(exports.MenuWrapper, { style: { color: '#FF3E3E' } },
                " ",
                window.i18n('leaveGroup'))));
    }
    return null;
};
exports.LeaveGroupMenuItem = LeaveGroupMenuItem;
const UpdateGroupNameMenuItem = () => {
    const convoId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const left = (0, useParamSelector_1.useIsLeft)(convoId);
    const isKickedFromGroup = (0, useParamSelector_1.useIsKickedFromGroup)(convoId);
    const weAreAdmin = (0, useParamSelector_1.useWeAreAdmin)(convoId);
    if (showUpdateGroupName(weAreAdmin, isKickedFromGroup, left)) {
        return (react_1.default.createElement(react_contexify_1.Item, { onClick: async () => {
                await (0, conversationInteractions_1.showUpdateGroupNameByConvoId)(convoId);
            } },
            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'editNotes', iconSize: 20, fillRule: "evenodd", clipRule: "evenodd" }),
            ' ',
            react_1.default.createElement(exports.MenuWrapper, null, window.i18n('editGroup'))));
    }
    return null;
};
exports.UpdateGroupNameMenuItem = UpdateGroupNameMenuItem;
const RemoveModeratorsMenuItem = () => {
    const convoId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isPublic = (0, useParamSelector_1.useIsPublic)(convoId);
    const isKickedFromGroup = (0, useParamSelector_1.useIsKickedFromGroup)(convoId);
    const weAreAdmin = (0, useParamSelector_1.useWeAreAdmin)(convoId);
    if (showRemoveModerators(weAreAdmin, Boolean(isPublic), Boolean(isKickedFromGroup))) {
        return (react_1.default.createElement(react_contexify_1.Item, { onClick: () => {
                (0, conversationInteractions_1.showRemoveModeratorsByConvoId)(convoId);
            } },
            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'removeFromModerators', iconSize: 20, fillRule: "evenodd", clipRule: "evenodd", iconColor: "#FF3E3E" }),
            react_1.default.createElement(exports.MenuWrapper, null, window.i18n('removeModerators'))));
    }
    return null;
};
exports.RemoveModeratorsMenuItem = RemoveModeratorsMenuItem;
const AddModeratorsMenuItem = () => {
    const convoId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isPublic = (0, useParamSelector_1.useIsPublic)(convoId);
    const isKickedFromGroup = (0, useParamSelector_1.useIsKickedFromGroup)(convoId);
    const weAreAdmin = (0, useParamSelector_1.useWeAreAdmin)(convoId);
    if (showAddModerators(weAreAdmin, isPublic, isKickedFromGroup)) {
        return (react_1.default.createElement(react_contexify_1.Item, { onClick: () => {
                (0, conversationInteractions_1.showAddModeratorsByConvoId)(convoId);
            } },
            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'addModerator', iconSize: 20, fillRule: "evenodd", clipRule: "evenodd" }),
            react_1.default.createElement(exports.MenuWrapper, null, window.i18n('addModerators'))));
    }
    return null;
};
exports.AddModeratorsMenuItem = AddModeratorsMenuItem;
const UnbanMenuItem = () => {
    const convoId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isPublic = (0, useParamSelector_1.useIsPublic)(convoId);
    const isKickedFromGroup = (0, useParamSelector_1.useIsKickedFromGroup)(convoId);
    const weAreAdmin = (0, useParamSelector_1.useWeAreAdmin)(convoId);
    if (showUnbanUser(weAreAdmin, isPublic, isKickedFromGroup)) {
        return (react_1.default.createElement(react_contexify_1.Item, { onClick: () => {
                (0, conversationInteractions_1.showUnbanUserByConvoId)(convoId);
            } },
            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'unBanIcon', iconSize: 20, fillRule: "evenodd", clipRule: "evenodd" }),
            react_1.default.createElement(exports.MenuWrapper, null, window.i18n('unbanUser'))));
    }
    return null;
};
exports.UnbanMenuItem = UnbanMenuItem;
const BanMenuItem = () => {
    const convoId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isPublic = (0, useParamSelector_1.useIsPublic)(convoId);
    const isKickedFromGroup = (0, useParamSelector_1.useIsKickedFromGroup)(convoId);
    const weAreAdmin = (0, useParamSelector_1.useWeAreAdmin)(convoId);
    if (showBanUser(weAreAdmin, isPublic, isKickedFromGroup)) {
        return (react_1.default.createElement(react_contexify_1.Item, { onClick: () => {
                (0, conversationInteractions_1.showBanUserByConvoId)(convoId);
            } },
            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconColor: "#FF3E3E", iconType: 'banIcon', iconSize: 20, fillRule: "evenodd", clipRule: "evenodd" }),
            react_1.default.createElement(exports.MenuWrapper, { style: { color: '#FF3E3E' } }, window.i18n('banUser'))));
    }
    return null;
};
exports.BanMenuItem = BanMenuItem;
const CopyMenuItem = () => {
    const convoId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isPublic = (0, useParamSelector_1.useIsPublic)(convoId);
    const isPrivate = (0, useParamSelector_1.useIsPrivate)(convoId);
    if (showCopyId(isPublic, isPrivate)) {
        const copyIdLabel = isPublic ? window.i18n('copySocialGroupURL') : window.i18n('copyBchatID');
        return (react_1.default.createElement(react_contexify_1.Item, { onClick: () => (0, conversationInteractions_1.copyPublicKeyByConvoId)(convoId) },
            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'copy', iconSize: 20, fillRule: "evenodd", clipRule: "evenodd" }),
            react_1.default.createElement(exports.MenuWrapper, null, copyIdLabel)));
    }
    return null;
};
exports.CopyMenuItem = CopyMenuItem;
const MarkAllReadMenuItem = () => {
    const convoId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isRequest = (0, useParamSelector_1.useIsRequest)(convoId);
    const isMe = (0, useParamSelector_1.useIsMe)(convoId);
    if (!isRequest && !isMe) {
        return (react_1.default.createElement(react_contexify_1.Item, { onClick: () => (0, conversationInteractions_1.markAllReadByConvoId)(convoId) },
            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'markRead', iconSize: 20, fillRule: "evenodd", clipRule: "evenodd" }),
            ' ',
            react_1.default.createElement(exports.MenuWrapper, null,
                " ",
                window.i18n('markAllAsRead'))));
    }
    else {
        return null;
    }
};
exports.MarkAllReadMenuItem = MarkAllReadMenuItem;
const DisappearingMessageMenuItem = () => {
    const convoId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isBlocked = (0, useParamSelector_1.useIsBlocked)(convoId);
    const isPublic = (0, useParamSelector_1.useIsPublic)(convoId);
    const isLeft = (0, useParamSelector_1.useIsLeft)(convoId);
    const isKickedFromGroup = (0, useParamSelector_1.useIsKickedFromGroup)(convoId);
    const timerOptions = (0, react_redux_1.useSelector)(timerOptions_1.getTimerOptions).timerOptions;
    const isRequest = (0, useParamSelector_1.useIsRequest)(convoId);
    const ourNumber = (0, react_redux_1.useSelector)(user_1.getOurNumber);
    if (ourNumber === convoId) {
        return null;
    }
    if (showTimerOptions(Boolean(isPublic), Boolean(isKickedFromGroup), Boolean(isLeft), Boolean(isBlocked), isRequest)) {
        return (react_1.default.createElement(react_contexify_1.Submenu, { label: react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'chatTimer', iconSize: 20, fillRule: "evenodd", clipRule: "evenodd" }),
                ' ',
                react_1.default.createElement(exports.MenuWrapper, null, window.i18n('disappearingMessages'))), arrow: react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "chevron", iconSize: "small", iconRotation: 268 }) }, timerOptions.map(item => (react_1.default.createElement("div", { className: "submenu" },
            react_1.default.createElement(react_contexify_1.Item, { style: { width: '100%' }, key: item.value, onClick: async () => {
                    await (0, conversationInteractions_1.setDisappearingMessagesByConvoId)(convoId, item.value);
                } }, item.name))))));
    }
    return null;
};
exports.DisappearingMessageMenuItem = DisappearingMessageMenuItem;
const NotificationForConvoMenuItem = () => {
    const convoId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isKickedFromGroup = (0, useParamSelector_1.useIsKickedFromGroup)(convoId);
    const left = (0, useParamSelector_1.useIsLeft)(convoId);
    const isBlocked = (0, useParamSelector_1.useIsBlocked)(convoId);
    const isPrivate = (0, useParamSelector_1.useIsPrivate)(convoId);
    const isRequest = (0, useParamSelector_1.useIsRequest)(convoId);
    const currentNotificationSetting = (0, useParamSelector_1.useNotificationSetting)(convoId);
    const isMe = (0, useParamSelector_1.useIsMe)(convoId);
    if (showNotificationConvo(Boolean(isKickedFromGroup), Boolean(left), Boolean(isBlocked), isRequest, isMe)) {
        const notificationForConvoOptions = conversation_1.ConversationNotificationSetting.filter(n => isPrivate ? n !== 'mentions_only' : true).map((n) => {
            const keyToUse = n === 'all' || !n
                ? 'notificationForConvo_all'
                : n === 'disabled'
                    ? 'notificationForConvo_disabled'
                    : 'notificationForConvo_mentions_only';
            return { value: n, name: window.i18n(keyToUse) };
        });
        return (react_1.default.createElement(react_contexify_1.Submenu, { label: react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'notifyBell', iconSize: 20, fillRule: "evenodd", clipRule: "evenodd" }),
                ' ',
                react_1.default.createElement(exports.MenuWrapper, null, window.i18n('notificationForConvo'))), arrow: react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "chevron", iconSize: "small", iconRotation: 268 }) }, (notificationForConvoOptions || []).map(item => {
            const disabled = item.value === currentNotificationSetting;
            return (react_1.default.createElement("div", { className: "submenu" },
                react_1.default.createElement(react_contexify_1.Item, { style: { width: '100%' }, key: item.value, onClick: async () => {
                        await (0, conversationInteractions_1.setNotificationForConvoId)(convoId, item.value);
                    } },
                    react_1.default.createElement("div", { style: {
                            marginRight: '10px',
                            color: disabled ? '#108D32' : ' var(--color-action-btn-icon)',
                        } },
                        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconSize: 10, iconType: "circle" })),
                    item.name)));
        })));
    }
    return null;
};
exports.NotificationForConvoMenuItem = NotificationForConvoMenuItem;
function isRtlBody() {
    const body = document.getElementsByTagName('body').item(0);
    return body?.classList.contains('rtl') || false;
}
exports.isRtlBody = isRtlBody;
const BlockMenuItem = () => {
    const convoId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isMe = (0, useParamSelector_1.useIsMe)(convoId);
    const isBlocked = (0, useParamSelector_1.useIsBlocked)(convoId);
    const isPrivate = (0, useParamSelector_1.useIsPrivate)(convoId);
    const isRequest = (0, useParamSelector_1.useIsRequest)(convoId);
    if (showBlock(Boolean(isMe), Boolean(isPrivate), Boolean(isRequest))) {
        const blockTitle = isBlocked ? window.i18n('unblockUser') : window.i18n('blockUser');
        const blockHandler = isBlocked
            ? () => (0, conversationInteractions_1.unblockConvoById)(convoId)
            : () => (0, conversationInteractions_1.blockConvoById)(convoId);
        return (react_1.default.createElement(react_contexify_1.Item, { onClick: blockHandler },
            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'blockSubmenu', iconSize: 20, fillRule: "evenodd", clipRule: "evenodd" }),
            ' ',
            react_1.default.createElement(exports.MenuWrapper, null, blockTitle)));
    }
    return null;
};
exports.BlockMenuItem = BlockMenuItem;
const ClearNicknameMenuItem = () => {
    const convoId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isMe = (0, useParamSelector_1.useIsMe)(convoId);
    const hasNickname = (0, useParamSelector_1.useHasNickname)(convoId);
    const isPrivate = (0, useParamSelector_1.useIsPrivate)(convoId);
    const isRequest = Boolean((0, useParamSelector_1.useIsRequest)(convoId));
    if (showClearNickname(Boolean(isMe), Boolean(hasNickname), Boolean(isPrivate), isRequest)) {
        return (react_1.default.createElement(react_contexify_1.Item, { onClick: () => (0, conversationInteractions_1.clearNickNameByConvoId)(convoId) }, window.i18n('clearNickname')));
    }
    return null;
};
exports.ClearNicknameMenuItem = ClearNicknameMenuItem;
const ChangeNicknameMenuItem = () => {
    const convoId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isMe = (0, useParamSelector_1.useIsMe)(convoId);
    const isPrivate = (0, useParamSelector_1.useIsPrivate)(convoId);
    const isRequest = (0, useParamSelector_1.useIsRequest)(convoId);
    const dispatch = (0, react_redux_1.useDispatch)();
    if (showChangeNickname(isMe, isPrivate, isRequest)) {
        return (react_1.default.createElement(react_contexify_1.Item, { onClick: () => {
                dispatch((0, modalDialog_1.changeNickNameModal)({ conversationId: convoId }));
            } },
            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'editNotes', iconSize: 20, fillRule: "evenodd", clipRule: "evenodd" }),
            ' ',
            react_1.default.createElement(exports.MenuWrapper, null, window.i18n('changeNickname'))));
    }
    return null;
};
exports.ChangeNicknameMenuItem = ChangeNicknameMenuItem;
const DeleteMessagesMenuItem = () => {
    const convoId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isRequest = (0, useParamSelector_1.useIsRequest)(convoId);
    if (isRequest) {
        return null;
    }
    return (react_1.default.createElement(react_contexify_1.Item, { onClick: () => {
            (0, conversationInteractions_1.deleteAllMessagesByConvoIdWithConfirmation)(convoId);
        } },
        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'delete', iconSize: 20, iconColor: "#FF3E3E" }),
        react_1.default.createElement(exports.MenuWrapper, { style: { color: '#FF3E3E' } },
            " ",
            window.i18n('deleteMessages'))));
};
exports.DeleteMessagesMenuItem = DeleteMessagesMenuItem;
const HideBannerMenuItem = () => {
    const dispatch = (0, react_redux_1.useDispatch)();
    return (react_1.default.createElement(react_contexify_1.Item, { onClick: () => {
            dispatch((0, userConfig_1.hideMessageRequestBanner)());
        } }, window.i18n('hideBanner')));
};
exports.HideBannerMenuItem = HideBannerMenuItem;
const AcceptMenuItem = () => {
    const convoId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isRequest = (0, useParamSelector_1.useIsRequest)(convoId);
    const convo = (0, conversations_1.getConversationController)().get(convoId);
    if (isRequest) {
        return (react_1.default.createElement(react_contexify_1.Item, { onClick: async () => {
                await convo.setDidApproveMe(true);
                await convo.addOutgoingApprovalMessage(Date.now());
                await (0, conversationInteractions_1.approveConvoAndSendResponse)(convoId, true);
            } },
            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'accept', iconSize: 20, iconColor: "#108D32", clipRule: "evenodd", fillRule: "evenodd" }),
            react_1.default.createElement(exports.MenuWrapper, { style: { color: '#108D32' } },
                " ",
                window.i18n('accept'))));
    }
    return null;
};
exports.AcceptMenuItem = AcceptMenuItem;
const DeclineMenuItem = () => {
    const convoId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isRequest = (0, useParamSelector_1.useIsRequest)(convoId);
    const customIcon = react_1.default.createElement(DeclineMessageRequest_1.default, { iconSize: 30 });
    if (isRequest) {
        return (react_1.default.createElement(react_contexify_1.Item, { onClick: () => {
                (0, conversationInteractions_1.declineConversationWithConfirm)(convoId, true, customIcon);
            } },
            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'accept', iconSize: 20, iconColor: "#FF3E3E", clipRule: "evenodd", fillRule: "evenodd" }),
            react_1.default.createElement(exports.MenuWrapper, { style: { color: '#FF3E3E' } },
                " ",
                window.i18n('decline'))));
    }
    return null;
};
exports.DeclineMenuItem = DeclineMenuItem;
