"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DisplaySeed = exports.ClearIcon = void 0;
const react_1 = __importDefault(require("react"));
const BchatButton_1 = require("../basic/BchatButton");
const ActionsPanel_1 = require("../leftpane/ActionsPanel");
const PasteIcon_1 = __importDefault(require("../icon/PasteIcon"));
const Flex_1 = require("../basic/Flex");
const SignUpTab_1 = require("./SignUpTab");
const ClearIcon = (props) => (react_1.default.createElement("div", { onClick: () => props.removeRecoveryPhrase(), "data-tip": "Clear", "data-place": "top", className: "paste-icon", "data-offset": "{'right':35,'left':5}", style: {
        background: `url(images/bchat/clear.svg) no-repeat`,
        width: '10px',
        height: '10px',
        position: 'relative',
        top: '8px',
        marginLeft: '408px',
        cursor: 'pointer',
        backgroundSize: 'cover',
    } }));
exports.ClearIcon = ClearIcon;
const DisplaySeed = (props) => {
    const handlePaste = (event) => {
        event.clipboardData.getData('text');
    };
    return (react_1.default.createElement("div", { className: "bchat-restore-seed__address-container" },
        react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(Flex_1.Flex, { flexDirection: "row", container: true, alignItems: "center", padding: "20px 0px" },
                react_1.default.createElement("div", { className: "bchat-registration-goback-icon" },
                    react_1.default.createElement(SignUpTab_1.GoBackMainMenuButton, { assent: props.backArrow })),
                react_1.default.createElement(Flex_1.Flex, { className: "bchat-registration__welcome-bchat" }, window.i18n('restoreFromSeed'))),
            react_1.default.createElement("div", { className: "bchat-restore-seed-parent-box" },
                react_1.default.createElement("div", { className: "bchat-restore-seed-text-box" },
                    react_1.default.createElement("textarea", { className: "bchat-restore-seed-text-area", name: "text", onPaste: handlePaste, value: props.recoveryPhrase, placeholder: "Enter your recover seed", onChange: e => props.assignRecoveryPhase(e.target.value) }),
                    react_1.default.createElement("div", { className: "bchat-restore-seed-icon-box" },
                        react_1.default.createElement("div", { onClick: () => props.paste(), className: "paste-icon", "data-tip": "Paste", "data-offset": "{'top':30,'left':15}", "data-place": "right" },
                            react_1.default.createElement(PasteIcon_1.default, { iconSize: 18 })))))),
        react_1.default.createElement("div", { style: { width: '95.5%' } },
            react_1.default.createElement(BchatButton_1.BchatButton, { onClick: props.onNext, buttonType: BchatButton_1.BchatButtonType.Default, buttonColor: BchatButton_1.BchatButtonColor.Primary, text: window.i18n('next') })),
        react_1.default.createElement(ActionsPanel_1.BchatToolTip, { effect: "solid" })));
};
exports.DisplaySeed = DisplaySeed;
