"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SignUpTab = exports.GoBackMainMenuButton = exports.SignUpMode = void 0;
const react_1 = __importStar(require("react"));
const String_1 = require("../../bchat/utils/String");
const Flex_1 = require("../basic/Flex");
const BchatButton_1 = require("../basic/BchatButton");
const icon_1 = require("../icon");
const RegistrationStages_1 = require("./RegistrationStages");
const RegistrationUserDetails_1 = require("./RegistrationUserDetails");
const SignInTab_1 = require("./SignInTab");
const ShowIdAndAddress_1 = require("./ShowIdAndAddress");
const utils_1 = require("../../bchat/utils");
const wallet_rpc_1 = require("../../wallet/wallet-rpc");
const mnemonic_1 = require("../../bchat/crypto/mnemonic");
const accountManager_1 = require("../../util/accountManager");
const WalletPass_1 = require("./WalletPass");
var SignUpMode;
(function (SignUpMode) {
    SignUpMode[SignUpMode["Default"] = 0] = "Default";
    SignUpMode[SignUpMode["BchatIDShown"] = 1] = "BchatIDShown";
    SignUpMode[SignUpMode["EnterDetails"] = 2] = "EnterDetails";
})(SignUpMode = exports.SignUpMode || (exports.SignUpMode = {}));
const CreateBchatIdButton = ({ createBchatID }) => {
    return (react_1.default.createElement("div", { className: 'signUp-btn' },
        react_1.default.createElement(BchatButton_1.BchatButton, { onClick: createBchatID, buttonType: BchatButton_1.BchatButtonType.Default, buttonColor: BchatButton_1.BchatButtonColor.Primary, text: window.i18n('createAccount') })));
};
const SignUpDefault = (props) => {
    return (react_1.default.createElement("div", { className: "bchat-registration__content" },
        react_1.default.createElement(CreateBchatIdButton, { createBchatID: props.createBchatID })));
};
const GoBackMainMenuButton = (props) => {
    const { setRegistrationPhase, setSignInMode, setSignUpMode } = (0, react_1.useContext)(RegistrationStages_1.RegistrationContext);
    return (react_1.default.createElement(icon_1.BchatIconButton, { iconSize: "huge", iconType: "KeyboardBackspaceArrow", iconColor: "#A9AEBA", onClick: () => {
            setRegistrationPhase(RegistrationStages_1.RegistrationPhase.Start);
            setSignInMode(SignInTab_1.SignInMode.Default);
            setSignUpMode(SignUpMode.Default);
            props.assent ? props.assent() : '';
            props.goBack ? props.goBack() : '';
        } }));
};
exports.GoBackMainMenuButton = GoBackMainMenuButton;
const SignUpTab = (props) => {
    const { signUpMode, setRegistrationPhase, setSignUpMode } = (0, react_1.useContext)(RegistrationStages_1.RegistrationContext);
    const [displayName, setDisplayName] = (0, react_1.useState)('');
    const [displayNameError, setDisplayNameError] = (0, react_1.useState)('');
    const [displayNameScreen, setDisplayNameScreen] = (0, react_1.useState)(0);
    const [password, setPassword] = (0, react_1.useState)('');
    const [repassword, setRepassword] = (0, react_1.useState)('');
    const [generatedRecoveryPhrase, setGeneratedRecoveryPhrase] = (0, react_1.useState)('');
    const [showSeedLoading, setShowSeedLoading] = (0, react_1.useState)(false);
    const [hexGeneratedPubKey, setHexGeneratedPubKey] = (0, react_1.useState)('');
    (0, react_1.useEffect)(() => {
        if (signUpMode === SignUpMode.BchatIDShown) {
            window.bchat.setNewBchatID(hexGeneratedPubKey);
        }
    }, [signUpMode]);
    const generateMnemonicAndKeyPairCreate = async (props) => {
        if (generatedRecoveryPhrase === '') {
            const mnemonic = await wallet_rpc_1.wallet.generateMnemonic(props);
            let seedHex = (0, mnemonic_1.mn_decode)(mnemonic);
            const privKeyHexLength = 32 * 2;
            if (seedHex.length !== privKeyHexLength) {
                seedHex = seedHex.concat('0'.repeat(32));
                seedHex = seedHex.substring(0, privKeyHexLength);
            }
            const seed = (0, String_1.fromHex)(seedHex);
            const keyPair = await (0, accountManager_1.bchatGenerateKeyPair)(seed);
            const newHexPubKey = utils_1.StringUtils.decode(keyPair.pubKey, 'hex');
            setGeneratedRecoveryPhrase(mnemonic);
            setHexGeneratedPubKey(newHexPubKey);
        }
    };
    if (signUpMode === SignUpMode.Default) {
        return (react_1.default.createElement(SignUpDefault, { createBchatID: () => {
                setRegistrationPhase(RegistrationStages_1.RegistrationPhase.SignUp);
                setSignUpMode(SignUpMode.EnterDetails);
                props.assent(false);
            } }));
    }
    const displayNameOK = !displayNameError && !!displayName;
    const enableCompleteSignUp = displayNameOK;
    const signUpWithDetails = async () => {
        setShowSeedLoading(true);
        localStorage.setItem('walletUserName', displayName);
        await (0, RegistrationStages_1.signUp)({
            displayName,
            generatedRecoveryPhrase: generatedRecoveryPhrase,
        });
        setShowSeedLoading(false);
    };
    const LoaderGif = () => {
        return (react_1.default.createElement("div", { className: "bchat-registration-loadingGif" },
            react_1.default.createElement("div", { style: {
                    background: 'url(images/bchat/Load_animation.gif) no-repeat',
                    width: '120px',
                    height: '120px',
                    margin: '0px auto',
                    backgroundSize: '102px',
                } })));
    };
    const clickGoBack = () => {
        setDisplayName('');
        setDisplayNameScreen(0);
        props.imageValidator(RegistrationStages_1.LeftImage.registration);
    };
    const verifyUserName = () => {
        if (!displayName) {
            window?.log?.warn('invalid trimmed name for registration');
            utils_1.ToastUtils.pushToastError('invalidDisplayName', window.i18n('displayNameEmpty'));
        }
        else {
            setDisplayNameScreen(1);
            props.imageValidator(RegistrationStages_1.LeftImage.password);
        }
    };
    const passValid = () => {
        if (!password || !repassword) {
            utils_1.ToastUtils.pushToastError('invalidPassword', 'Please Enter Password !');
        }
        else if ((password.length < 4 && repassword.length < 4) ||
            (password.length > 13 && repassword.length > 13)) {
            utils_1.ToastUtils.pushToastError('walletPasswordLengthError', window.i18n('walletPasswordLengthError'));
        }
        else if (password !== repassword) {
            window?.log?.warn('invalid password');
            utils_1.ToastUtils.pushToastError('invalidPassword', 'Please Enter Same Password !');
        }
        else {
            const walletData = { displayName, password };
            void generateMnemonicAndKeyPairCreate(walletData);
            setDisplayNameScreen(2);
            props.imageValidator(RegistrationStages_1.LeftImage.address);
            setRepassword('');
            setPassword('');
        }
    };
    const goback = () => {
        props.assent(true);
        clickGoBack();
        if (displayNameScreen === 1) {
            setPassword('');
            setRepassword('');
            props.imageValidator(RegistrationStages_1.LeftImage.registration);
        }
    };
    const handleInputChange = (setter, e) => {
        const newValue = e.replace(/\s+/g, '');
        setter(newValue);
    };
    if (displayNameScreen === 1) {
        return (react_1.default.createElement(WalletPass_1.WalletPassword, { password: password, repassword: repassword, setPassword: (e) => handleInputChange(setPassword, e), setRepassword: (e) => handleInputChange(setRepassword, e), backArrow: goback, submit: passValid }));
    }
    if (displayNameScreen === 0) {
        return (react_1.default.createElement("div", { className: "bchat-registration__content", style: { paddingTop: '0px' } },
            react_1.default.createElement(Flex_1.Flex, { flexDirection: "row", container: true, alignItems: "center" },
                react_1.default.createElement("div", { className: "bchat-registration-goback-icon" },
                    react_1.default.createElement(exports.GoBackMainMenuButton, { assent: goback })),
                react_1.default.createElement(Flex_1.Flex, { className: "bchat-registration__welcome-bchat" }, window.i18n('displayName'))),
            react_1.default.createElement(RegistrationUserDetails_1.RegistrationUserDetails, { showDisplayNameField: true, showSeedField: false, displayName: displayName, handlePressEnter: () => {
                    verifyUserName();
                }, onDisplayNameChanged: (name) => {
                    const sanitizedName = (0, String_1.sanitizeBchatUsername)(name);
                    const trimName = sanitizedName.trim();
                    setDisplayName(sanitizedName);
                    setDisplayNameError(!trimName ? window.i18n('displayNameEmpty') : undefined);
                }, stealAutoFocus: true }),
            react_1.default.createElement("div", { style: { width: '450px' } },
                react_1.default.createElement(BchatButton_1.BchatButton, { onClick: () => {
                        verifyUserName();
                    }, buttonType: BchatButton_1.BchatButtonType.Default, buttonColor: BchatButton_1.BchatButtonColor.Primary, text: window.i18n('continue'), disabled: !displayName }))));
    }
    if (displayNameScreen === 2) {
        return (react_1.default.createElement(react_1.default.Fragment, null,
            !localStorage.getItem('userAddress') || !hexGeneratedPubKey ? react_1.default.createElement(LoaderGif, null) : null,
            react_1.default.createElement(ShowIdAndAddress_1.DisplayIdAndAddress, { nextFunc: () => {
                    setDisplayNameScreen(3);
                    props.imageValidator(RegistrationStages_1.LeftImage.recoveryseed);
                }, pubKey: hexGeneratedPubKey, walletAddress: localStorage.getItem('userAddress'), assentAndGoBack: () => {
                    props.assent(true);
                    clickGoBack();
                } })));
    }
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(ShowIdAndAddress_1.ShowRecoveryPhase, { assentAndGoBack: () => {
                props.assent(true);
                clickGoBack();
            }, mnemonic: generatedRecoveryPhrase, nextFunc: signUpWithDetails, enableCompleteSignUp: enableCompleteSignUp, loading: showSeedLoading })));
};
exports.SignUpTab = SignUpTab;
