"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WalletPassword = void 0;
const react_1 = __importDefault(require("react"));
const BchatButton_1 = require("../basic/BchatButton");
const BchatInput_1 = require("../basic/BchatInput");
const Flex_1 = require("../basic/Flex");
const SignUpTab_1 = require("./SignUpTab");
const Text_1 = require("../basic/Text");
const WalletPassword = (props) => {
    return (react_1.default.createElement("div", null,
        react_1.default.createElement("div", { className: "bchat-registration__content", style: { paddingTop: '0px' } },
            react_1.default.createElement(Flex_1.Flex, { flexDirection: "row", container: true, alignItems: "center", padding: "10px 0px" },
                react_1.default.createElement("div", { className: "bchat-registration-goback-icon" },
                    react_1.default.createElement(SignUpTab_1.GoBackMainMenuButton, { assent: props.backArrow })),
                react_1.default.createElement(Flex_1.Flex, { className: "bchat-registration__welcome-bchat" }, "Wallet Password")),
            react_1.default.createElement("p", { className: "bchat-registration-container-walletHintText" }, "Create New Wallet Password "),
            react_1.default.createElement(BchatInput_1.BchatInput, { type: "password", value: props.password, autoFocus: false, placeholder: 'Enter wallet password', enableShowHide: true, onValueChanged: props.setPassword, minLength: 4, maxLength: 13 }),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement(BchatInput_1.BchatInput, { type: "password", value: props.repassword, autoFocus: false, placeholder: 'Re-enter wallet password', enableShowHide: true, onValueChanged: props.setRepassword, minLength: 4, maxLength: 13 }),
            react_1.default.createElement("div", { style: { height: '25px' } }),
            react_1.default.createElement("div", { style: { width: '450px' } },
                react_1.default.createElement(BchatButton_1.BchatButton, { onClick: () => props.submit(), buttonType: BchatButton_1.BchatButtonType.Default, buttonColor: BchatButton_1.BchatButtonColor.Primary, text: window.i18n('continue') }))),
        react_1.default.createElement("p", { className: "warning-notes" },
            react_1.default.createElement("span", null, "Note:"),
            " Your wallet password will be used to authenticate transactions on BChat.",
            react_1.default.createElement("strong", null, "Keep Your Wallet Password Safe."),
            " If you forget the password, you can reset it only by restoring your BChat account using your Recovery Seed.")));
};
exports.WalletPassword = WalletPassword;
