"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageSearchResult = void 0;
const react_1 = __importDefault(require("react"));
const User_1 = require("../../bchat/utils/User");
const conversations_1 = require("../../state/ducks/conversations");
const ContactName_1 = require("../conversation/ContactName");
const Avatar_1 = require("../avatar/Avatar");
const Timestamp_1 = require("../conversation/Timestamp");
const MessageBodyHighlight_1 = require("../basic/MessageBodyHighlight");
const styled_components_1 = __importDefault(require("styled-components"));
const useParamSelector_1 = require("../../hooks/useParamSelector");
const utils_1 = require("../../bchat/utils");
const StyledConversationTitleResults = styled_components_1.default.div `
  flex-grow: 1;
  flex-shrink: 1;
  font-size: 14px;
  line-height: 18px;
  overflow-x: hidden;
  white-space: nowrap;
  text-overflow: ellipsis;
  color: var(--color-text);
`;
const StyledConversationFromUserInGroup = (0, styled_components_1.default)(StyledConversationTitleResults) `
  display: inline;
  font-size: 12px;
  line-height: 14px;
  overflow-x: hidden;
  font-weight: 700;
  color: var(--color-text-subtle);
`;
const StyledSearchResulsts = styled_components_1.default.div `
  padding: 8px;
  padding-inline-start: 16px;
  padding-inline-end: 16px;
  min-height: 64px;
  // max-width: 300px;

  display: flex;
  flex-direction: row;
  align-items: flex-start;
  cursor: pointer;
  &:hover {
    background-color: var(--color-clickable-hovered);
    border-radius:16px;
  }
`;
const StyledResultText = styled_components_1.default.div `
  flex-grow: 1;
  margin-inline-start: 12px;
  display: inline-flex;
  flex-direction: column;
  align-items: stretch;
`;
const ResultsHeader = styled_components_1.default.div `
  display: flex;
  flex-direction: column;  
`;
const StyledMessageResultsHeaderName = styled_components_1.default.span `
  font-weight: 300;
`;
const FromName = (props) => {
    const { conversationId, source } = props;
    const isNoteToSelf = conversationId === (0, User_1.getOurPubKeyStrFromCache)() && source === conversationId;
    if (isNoteToSelf) {
        return (react_1.default.createElement(StyledMessageResultsHeaderName, null, window.i18n('noteToSelf')));
    }
    if (source === (0, User_1.getOurPubKeyStrFromCache)()) {
        return react_1.default.createElement(StyledMessageResultsHeaderName, null, window.i18n('you'));
    }
    return (react_1.default.createElement(ContactName_1.ContactName, { pubkey: conversationId, module: "module-message-search-result__header__name", shouldShowPubkey: false }));
};
const ConversationHeader = (props) => {
    const { source, conversationId } = props;
    const ourKey = (0, User_1.getOurPubKeyStrFromCache)();
    if (conversationId !== ourKey) {
        return (react_1.default.createElement(StyledConversationTitleResults, null,
            react_1.default.createElement(StyledMessageResultsHeaderName, null,
                react_1.default.createElement(ContactName_1.ContactName, { pubkey: conversationId, shouldShowPubkey: false, boldProfileName: false }))));
    }
    return (react_1.default.createElement(StyledConversationTitleResults, null,
        react_1.default.createElement(FromName, { source: source, conversationId: conversationId })));
};
const FromUserInGroup = (props) => {
    const { authorPubkey, conversationId } = props;
    const ourKey = (0, User_1.getOurPubKeyStrFromCache)();
    const convoIsPrivate = (0, useParamSelector_1.useIsPrivate)(conversationId);
    const authorConvoName = (0, useParamSelector_1.useConversationUsername)(authorPubkey);
    if (convoIsPrivate) {
        return null;
    }
    if (authorPubkey === ourKey) {
        return (react_1.default.createElement(StyledConversationFromUserInGroup, null,
            window.i18n('you'),
            ": "));
    }
    return react_1.default.createElement(StyledConversationFromUserInGroup, null,
        authorConvoName,
        ": ");
};
const ResultBody = styled_components_1.default.div `
  margin-top: 1px;
  flex-shrink: 1;

  font-size: 13px;

  color: var(--color-text-subtle);

  max-height: 3.6em;

  overflow: hidden;
  display: -webkit-box;
  -webkit-line-clamp: 1;
  -webkit-box-orient: vertical;
`;
const StyledTimestampContaimer = styled_components_1.default.div `
  flex-shrink: 0;
  // margin-inline-start: 6px;

  font-size: 11px;
  line-height: 16px;
  letter-spacing: 0.3px;

  overflow-x: hidden;
  white-space: nowrap;
  text-overflow: ellipsis;

  text-transform: uppercase;

  color: var(--color-text-subtle);
`;
const MessageSearchResult = (props) => {
    const { id, conversationId, received_at, snippet, source, sent_at, serverTimestamp, timestamp, direction, } = props;
    const me = utils_1.UserUtils.getOurPubKeyStrFromCache();
    const convoIsPrivate = (0, useParamSelector_1.useIsPrivate)(conversationId);
    const destination = direction === 'incoming' ? conversationId : convoIsPrivate ? me : conversationId;
    const isBnsHolder = (0, useParamSelector_1.useConversationBnsHolder)(destination);
    if (!source && !destination) {
        return null;
    }
    return (react_1.default.createElement(StyledSearchResulsts, { key: `div-msg-searchresult-${id}`, role: "button", onClick: () => {
            void (0, conversations_1.openConversationToSpecificMessage)({
                conversationKey: conversationId,
                messageIdToNavigateTo: id,
                shouldHighlightMessage: true,
            });
        } },
        react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.L, pubkey: conversationId, isBnsHolder: isBnsHolder }),
        react_1.default.createElement(StyledResultText, null,
            react_1.default.createElement(ResultsHeader, null,
                react_1.default.createElement(ConversationHeader, { source: destination, conversationId: conversationId }),
                react_1.default.createElement(StyledTimestampContaimer, null,
                    react_1.default.createElement(Timestamp_1.Timestamp, { timestamp: serverTimestamp || timestamp || sent_at || received_at, momentFromNow: false }))),
            react_1.default.createElement(ResultBody, null,
                react_1.default.createElement(FromUserInGroup, { authorPubkey: source, conversationId: conversationId }),
                react_1.default.createElement(MessageBodyHighlight_1.MessageBodyHighlight, { text: snippet || '', isGroup: !convoIsPrivate })))));
};
exports.MessageSearchResult = MessageSearchResult;
