"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatRecoverySeed = void 0;
const react_1 = __importDefault(require("react"));
const BchatSeedModal_1 = require("../dialog/BchatSeedModal");
const react_redux_1 = require("react-redux");
const modal_1 = require("../../state/selectors/modal");
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const BchatSettings_1 = require("./BchatSettings");
const section_1 = require("../../state/ducks/section");
const CategoryPrivacy_1 = require("./section/CategoryPrivacy");
const Text_1 = require("../basic/Text");
const BchatButton_1 = require("../basic/BchatButton");
const BchatIcon_1 = require("../icon/BchatIcon");
const BchatRecoverySeed = (props) => {
    const recoveryPhraseModalState = (0, react_redux_1.useSelector)(modal_1.getRecoveryPhraseDialog);
    if (props.passwordLock) {
        return react_1.default.createElement(BchatSeedModal_1.BchatSeedModal, { ...recoveryPhraseModalState });
    }
    const onClickOkHandler = () => {
        window.inboxStore?.dispatch((0, section_1.showSettingsSection)(BchatSettings_1.BchatSettingCategory.Privacy));
        (0, CategoryPrivacy_1.displayPasswordModal)('set', props.onPasswordUpdated);
    };
    const onClickCancelHandler = () => {
        window.inboxStore?.dispatch((0, section_1.showSettingsSection)(BchatSettings_1.BchatSettingCategory.Chat));
    };
    return (react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { title: '', showExitIcon: false, showHeader: false, okButton: {
            text: window.i18n('ok'),
            onClickOkHandler,
            color: BchatButton_1.BchatButtonColor.Primary,
        }, cancelButton: {
            text: window.i18n('cancel'),
            status: true,
            onClickCancelHandler
        }, iconShow: true, customIcon: react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "enablePasswordIcon", iconSize: 26 }) },
        react_1.default.createElement("div", { className: "bchat-modal-setPasswordAccess" },
            react_1.default.createElement("div", { className: "contentbox" },
                react_1.default.createElement("div", { className: "header" }, window.i18n('setPassword')),
                react_1.default.createElement(Text_1.SpacerLG, null),
                react_1.default.createElement("div", { className: 'fontSemiBold' },
                    "Set a Password before accessing the Recovery Phrase. You can set your password from",
                    ' ',
                    react_1.default.createElement("span", { className: 'span' }, "Settings -> Privacy -> Set Account Password."))))));
};
exports.BchatRecoverySeed = BchatRecoverySeed;
