"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatSettingButtonItem = exports.BchatToggleWithDescription = exports.BchatSettingsItemWrapper = void 0;
const react_1 = __importDefault(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const BchatButton_1 = require("../basic/BchatButton");
const BchatToggle_1 = require("../basic/BchatToggle");
const Avatar_1 = require("../avatar/Avatar");
const icon_1 = require("../icon");
const Flex_1 = require("../basic/Flex");
const RemovePasswordIcon_1 = __importDefault(require("../icon/RemovePasswordIcon"));
const SettingsTitleAndDescription = (props) => {
    return (react_1.default.createElement("div", { className: "bchat-settings-item__info" },
        props.bchatId ? (react_1.default.createElement("div", { className: "bchat-settings-item__dFlex" },
            react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.M, pubkey: props.bchatId, dataTestId: "leftpane-primary-avatar" }),
            react_1.default.createElement("div", { className: "bchat-settings-item__title", style: { marginLeft: '10px' } }, props.title))) : (react_1.default.createElement("div", { className: "bchat-settings-item__title" },
            " ",
            props.title)),
        props.description && (react_1.default.createElement("div", { className: "bchat-settings-item__description" }, props.description))));
};
const BchatSettingsContent = (props) => {
    return react_1.default.createElement("div", { className: "bchat-settings-item__content" }, props.children);
};
const BchatSettingsItemWrapper = (props) => {
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('bchat-settings-item', props.inline && 'inline') },
        react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "center", alignItems: "center", flexDirection: "row" },
            react_1.default.createElement("span", { style: { marginRight: '15px' } }, props.title === window.i18n('removeAccountPasswordTitle') ? (react_1.default.createElement(RemovePasswordIcon_1.default, null)) : (react_1.default.createElement(icon_1.BchatIcon, { iconType: props.iconType || 'beldexCoinLogo', iconSize: 24, fillRule: "evenodd", clipRule: "evenodd" }))),
            react_1.default.createElement(SettingsTitleAndDescription, { title: props.title, description: props.description, bchatId: props.bchatId })),
        react_1.default.createElement(BchatSettingsContent, null, props.children)));
};
exports.BchatSettingsItemWrapper = BchatSettingsItemWrapper;
const BchatToggleWithDescription = (props) => {
    const { title, description, active, onClickToggle, confirmationDialogParams, iconType } = props;
    return (react_1.default.createElement(exports.BchatSettingsItemWrapper, { title: title, description: description, inline: true, iconType: iconType },
        react_1.default.createElement(BchatToggle_1.BchatToggle, { active: active, onClick: onClickToggle, confirmationDialogParams: confirmationDialogParams })));
};
exports.BchatToggleWithDescription = BchatToggleWithDescription;
const BchatSettingButtonItem = (props) => {
    const { title, description, buttonColor, buttonText, dataTestId, bchatId, iconType, onClick, } = props;
    return (react_1.default.createElement(exports.BchatSettingsItemWrapper, { title: title, description: description, inline: true, bchatId: bchatId, iconType: iconType },
        react_1.default.createElement(BchatButton_1.BchatButton, { dataTestId: dataTestId, text: buttonText, buttonColor: buttonColor, onClick: onClick, buttonType: BchatButton_1.BchatButtonType.Brand })));
};
exports.BchatSettingButtonItem = BchatSettingButtonItem;
