"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatSettingsView = exports.PasswordLock = exports.BchatSettingCategory = exports.getCallMediaPermissionsSettings = exports.getMediaPermissionsSettings = void 0;
const react_1 = __importDefault(require("react"));
const BchatSettingsHeader_1 = require("./BchatSettingsHeader");
const auto_bind_1 = __importDefault(require("auto-bind"));
const BeldexNotificationGroupSettings_1 = require("./BeldexNotificationGroupSettings");
const BlockedUserSettings_1 = require("./BlockedUserSettings");
const CategoryPrivacy_1 = require("./section/CategoryPrivacy");
const CategoryAppearance_1 = require("./section/CategoryAppearance");
const BchatButton_1 = require("../basic/BchatButton");
const data_1 = require("../../data/data");
const passwordUtils_1 = require("../../util/passwordUtils");
const BchatRecoverySeed_1 = require("./BchatRecoverySeed");
const OverlayMessageRequest_1 = require("../leftpane/overlay/OverlayMessageRequest");
const BchatOnionPathScreen_1 = require("./BchatOnionPathScreen");
const utils_1 = require("../../bchat/utils");
const BchatWalletMainPanel_1 = require("../wallet/BchatWalletMainPanel");
const BchatWalletHelper_1 = require("../../wallet/BchatWalletHelper");
const categoryChat_1 = require("./section/categoryChat");
const BchatWalletSettings_1 = require("../wallet/BchatWalletSettings");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const react_redux_1 = require("react-redux");
const theme_1 = require("../../state/selectors/theme");
function getMediaPermissionsSettings() {
    return window.getSettingValue('media-permissions');
}
exports.getMediaPermissionsSettings = getMediaPermissionsSettings;
function getCallMediaPermissionsSettings() {
    return window.getSettingValue('call-media-permissions');
}
exports.getCallMediaPermissionsSettings = getCallMediaPermissionsSettings;
var BchatSettingCategory;
(function (BchatSettingCategory) {
    BchatSettingCategory["Chat"] = "chat";
    BchatSettingCategory["Appearance"] = "appearance";
    BchatSettingCategory["Privacy"] = "privacy";
    BchatSettingCategory["Notifications"] = "notifications";
    BchatSettingCategory["MessageRequests"] = "messageRequests";
    BchatSettingCategory["Blocked"] = "blocked";
    BchatSettingCategory["RecoverySeed"] = "recoverySeed";
    BchatSettingCategory["RecoveryKey"] = "recoveryKey";
    BchatSettingCategory["Hops"] = "hops";
    BchatSettingCategory["Wallet"] = "wallet";
    BchatSettingCategory["WalletSettings"] = "walletSettings";
    BchatSettingCategory["ClearData"] = "clearData";
})(BchatSettingCategory = exports.BchatSettingCategory || (exports.BchatSettingCategory = {}));
const PasswordLock = ({ validatePasswordLock, }) => {
    const darkMode = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    return (react_1.default.createElement("div", { className: "bchat-settings__password-lock" },
        react_1.default.createElement("div", { className: 'bchat-settings__password-lock-box' },
            react_1.default.createElement("div", { style: { borderRadius: '16px', overflow: 'hidden' } },
                react_1.default.createElement("div", { className: "subBox" },
                    react_1.default.createElement("img", { src: darkMode ? 'images/bchat/passwordIcon.svg' : 'images/bchat/passwordIconWhite.svg', width: "130px", height: "130px" }),
                    react_1.default.createElement("div", { className: 'subtext' }, window.i18n('password')),
                    react_1.default.createElement("input", { type: "password", id: "password-lock-input", defaultValue: "", placeholder: "Enter your password", "data-testid": "password-lock-input" })),
                react_1.default.createElement("div", { className: 'bchat-modal-footer' },
                    react_1.default.createElement(BchatButton_1.BchatButton, { text: window.i18n('ok'), buttonType: BchatButton_1.BchatButtonType.Brand, buttonColor: BchatButton_1.BchatButtonColor.Primary, onClick: validatePasswordLock }))))));
};
exports.PasswordLock = PasswordLock;
class BchatSettingsView extends react_1.default.Component {
    settingsViewRef;
    constructor(props) {
        super(props);
        this.state = {
            hasPassword: null,
            pwdLockError: null,
            mediaSetting: null,
            callMediaSetting: null,
            shouldLockSettings: true,
            nodeSetting: false,
        };
        this.settingsViewRef = react_1.default.createRef();
        (0, auto_bind_1.default)(this);
        void this.hasPassword();
    }
    componentDidMount() {
        window.addEventListener('keyup', this.onKeyUp);
        (0, BchatWalletHelper_1.deamonvalidation)();
        const mediaSetting = getMediaPermissionsSettings();
        const callMediaSetting = getCallMediaPermissionsSettings();
        this.setState({ mediaSetting, callMediaSetting });
        setTimeout(() => document.getElementById('password-lock-input')?.focus(), 100);
    }
    componentWillUnmount() {
        window.removeEventListener('keyup', this.onKeyUp);
        (0, BchatWalletHelper_1.deamonvalidation)();
    }
    renderSettingInCategory(passwordLock) {
        const { category } = this.props;
        if (category !== BchatSettingCategory.RecoverySeed && !this.state.shouldLockSettings) {
            this.setState({
                hasPassword: true,
                shouldLockSettings: true,
                pwdLockError: null,
            });
        }
        if (this.state.hasPassword === null) {
            return null;
        }
        if (category === BchatSettingCategory.Chat) {
            return react_1.default.createElement(categoryChat_1.SettingsCategoryChat, { hasPassword: this.state.hasPassword });
        }
        if (category === BchatSettingCategory.Blocked) {
            return react_1.default.createElement(BlockedUserSettings_1.BlockedUserSettings, null);
        }
        if (category === BchatSettingCategory.Appearance) {
            return react_1.default.createElement(CategoryAppearance_1.SettingsCategoryAppearance, { hasPassword: this.state.hasPassword });
        }
        if (category === BchatSettingCategory.RecoverySeed) {
            if (passwordLock) {
                return (react_1.default.createElement(exports.PasswordLock, { pwdLockError: this.state.pwdLockError, validatePasswordLock: this.validatePasswordLock }));
            }
            else {
                return (react_1.default.createElement(BchatRecoverySeed_1.BchatRecoverySeed, { onPasswordUpdated: this.onPasswordUpdated, passwordLock: this.state.hasPassword, onClickCancel: () => this.onClickCancel() }));
            }
        }
        if (category === BchatSettingCategory.MessageRequests) {
            return react_1.default.createElement(OverlayMessageRequest_1.OverlayMessageRequest, { settings: 'true' });
        }
        if (category === BchatSettingCategory.Hops) {
            return react_1.default.createElement(BchatOnionPathScreen_1.BchatOnionPathScreen, null);
        }
        if (category === BchatSettingCategory.Wallet) {
            return react_1.default.createElement(BchatWalletMainPanel_1.WalletMainPanel, null);
        }
        if (category === BchatSettingCategory.WalletSettings) {
            return (react_1.default.createElement("div", null,
                react_1.default.createElement(BchatWalletSettings_1.WalletSettings, null)));
        }
        if (category === BchatSettingCategory.Notifications) {
            return react_1.default.createElement(BeldexNotificationGroupSettings_1.BchatNotificationGroupSettings, { hasPassword: this.state.hasPassword });
        }
        if (category === BchatSettingCategory.Privacy) {
            return (react_1.default.createElement(CategoryPrivacy_1.SettingsCategoryPrivacy, { onPasswordUpdated: this.onPasswordUpdated, hasPassword: this.state.hasPassword }));
        }
        return null;
    }
    async validatePasswordLock() {
        const enteredPassword = String(document.getElementById('password-lock-input')?.value);
        if (!enteredPassword) {
            this.setState({
                pwdLockError: 'emptyPassword',
            });
            utils_1.ToastUtils.pushToastError('emptyPassword', window.i18n('emptyPassword'));
            return false;
        }
        const hash = await (0, data_1.getPasswordHash)();
        if (hash && !(0, passwordUtils_1.matchesHash)(enteredPassword, hash)) {
            this.setState({
                pwdLockError: window.i18n('invalidPassword'),
            });
            utils_1.ToastUtils.pushToastError('invalidPassword', window.i18n('invalidPassword'));
            return false;
        }
        this.setState({
            shouldLockSettings: false,
            pwdLockError: null,
        });
        return true;
    }
    render() {
        const { category } = this.props;
        const shouldRenderPasswordLock = this.state.shouldLockSettings && this.state.hasPassword;
        const categoryLocalized = category === BchatSettingCategory.Appearance
            ? 'appearanceSettingsTitle'
            : category === BchatSettingCategory.Blocked
                ? 'blockedSettingsTitle'
                : category === BchatSettingCategory.RecoverySeed
                    ? 'recoveryPhrase'
                    : category === BchatSettingCategory.MessageRequests
                        ? 'messageRequests'
                        : category === BchatSettingCategory.Hops
                            ? 'hops'
                            : category === BchatSettingCategory.Chat
                                ? 'Chat'
                                : category === BchatSettingCategory.WalletSettings
                                    ? 'WalletSettingsTitle'
                                    : category === BchatSettingCategory.Wallet
                                        ? 'WalletSettingsTitle'
                                        : category === BchatSettingCategory.Notifications
                                            ? 'notificationsSettingsTitle'
                                            : 'privacySettingsTitle';
        return (react_1.default.createElement("div", { className: "bchat-settings" },
            react_1.default.createElement(BchatSettingsHeader_1.SettingsHeader, { category: category, categoryTitle: window.i18n(categoryLocalized) }),
            react_1.default.createElement("div", { className: "bchat-settings-view" },
                react_1.default.createElement("div", { ref: this.settingsViewRef, className: "bchat-settings-list" }, this.renderSettingInCategory(shouldRenderPasswordLock)))));
    }
    async hasPassword() {
        const hash = await (0, data_1.getPasswordHash)();
        this.setState({
            hasPassword: !!hash,
        });
    }
    onPasswordUpdated(action) {
        if (action === 'set' || action === 'change') {
            this.setState({
                hasPassword: true,
                shouldLockSettings: true,
                pwdLockError: null,
            });
        }
        if (action === 'remove') {
            this.setState({
                hasPassword: false,
            });
        }
    }
    onClickCancel() {
        window.inboxStore?.dispatch((0, modalDialog_1.updateBchatAlertConfirmModal)(null));
    }
    async onKeyUp(event) {
        const lockPasswordVisible = Boolean(document.getElementById('password-lock-input'));
        if (event.key === 'Enter' && lockPasswordVisible) {
            await this.validatePasswordLock();
        }
        event.preventDefault();
    }
}
exports.BchatSettingsView = BchatSettingsView;
