"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingsHeader = void 0;
const react_1 = __importDefault(require("react"));
const BchatSettings_1 = require("./BchatSettings");
const react_redux_1 = require("react-redux");
const BchatIconButton_1 = require("../icon/BchatIconButton");
const userConfig_1 = require("../../state/ducks/userConfig");
const userConfig_2 = require("../../state/selectors/userConfig");
const conversations_1 = require("../../state/selectors/conversations");
const SettingsHeader = (props) => {
    const { categoryTitle, category } = props;
    const dispatch = (0, react_redux_1.useDispatch)();
    const multipleSelectionValue = (0, react_redux_1.useSelector)(userConfig_2.getMultipleSelection);
    const blockedNumbers = (0, react_redux_1.useSelector)(conversations_1.getBlockedPubkeys);
    if (category === BchatSettings_1.BchatSettingCategory.Wallet) {
        return react_1.default.createElement(react_1.default.Fragment, null);
    }
    return (react_1.default.createElement("div", { className: "bchat-settings-header" },
        react_1.default.createElement("div", { className: "bchat-settings-header-title" }, categoryTitle),
        window.i18n('blockedSettingsTitle') === categoryTitle && blockedNumbers.length != 0 && (react_1.default.createElement("div", { className: "bchat-settings-header-selectionBox" }, multipleSelectionValue ? (react_1.default.createElement(BchatIconButton_1.BchatIconButton, { iconSize: "large", iconType: "markAllDone", onClick: () => {
                dispatch((0, userConfig_1.toggleMultipleSelection)());
            } })) : (react_1.default.createElement(BchatIconButton_1.BchatIconButton, { iconSize: "large", iconType: "markAll", onClick: () => {
                dispatch((0, userConfig_1.toggleMultipleSelection)());
            } }))))));
};
exports.SettingsHeader = SettingsHeader;
