"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BlockedMemberList = exports.BlockedUserSettings = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const conversationInteractions_1 = require("../../interactions/conversationInteractions");
const conversations_1 = require("../../state/selectors/conversations");
const useSet_1 = require("../../hooks/useSet");
const util_1 = require("../../util");
const utils_1 = require("../../bchat/utils");
const useUpdate_1 = __importDefault(require("react-use/lib/useUpdate"));
const styled_components_1 = __importDefault(require("styled-components"));
const BchatButton_1 = require("../basic/BchatButton");
const Avatar_1 = require("../avatar/Avatar");
const useParamSelector_1 = require("../../hooks/useParamSelector");
const classnames_1 = __importDefault(require("classnames"));
const icon_1 = require("../icon");
const userConfig_1 = require("../../state/selectors/userConfig");
const userConfig_2 = require("../../state/ducks/userConfig");
const Text_1 = require("../basic/Text");
const BlockedUserSettings = () => {
    const blockedNumbers = (0, react_redux_1.useSelector)(conversations_1.getBlockedPubkeys);
    const forceUpdate = (0, useUpdate_1.default)();
    const multipleSelection = (0, react_redux_1.useSelector)(userConfig_1.getMultipleSelection);
    const dispatch = (0, react_redux_1.useDispatch)();
    const { uniqueValues: selectedIds, addTo: addToSelected, removeFrom: removeFromSelected, empty: emptySelected, } = (0, useSet_1.useSet)([]);
    async function unBlockThoseUsers() {
        if (selectedIds.length) {
            await util_1.BlockedNumberController.unblockAll(selectedIds);
            emptySelected();
            utils_1.ToastUtils.pushToastSuccess('unblocked', window.i18n('unblocked'));
            forceUpdate();
            dispatch((0, userConfig_2.hideMultipleSelection)());
        }
    }
    if (!blockedNumbers || blockedNumbers.length === 0) {
        return (react_1.default.createElement("div", { className: "noBlockedContacts" },
            react_1.default.createElement("div", { className: "noBlockedContacts-img" }),
            window.i18n('noBlockedContacts')));
    }
    return (react_1.default.createElement("div", null,
        react_1.default.createElement("div", { style: multipleSelection ? { height: 'calc( 100vh - 137px)' } : {} },
            react_1.default.createElement(BlockedEntries, { blockedNumbers: blockedNumbers, selectedIds: selectedIds, addToSelected: addToSelected, removeFromSelected: removeFromSelected, multipleSelection: multipleSelection }),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement(Text_1.SpacerLG, null),
            multipleSelection && (react_1.default.createElement(UnBlockedBox, null,
                react_1.default.createElement(BchatButton_1.BchatButton, { buttonColor: BchatButton_1.BchatButtonColor.Danger, style: {
                        height: '55px', fontSize: '16px',
                        fontWeight: '500'
                    }, text: window.i18n('unblockUserSelect'), onClick: unBlockThoseUsers, dataTestId: "unblock-button-settings-screen" }))))));
};
exports.BlockedUserSettings = BlockedUserSettings;
const BlockedEntriesContainer = styled_components_1.default.div `
  flex-shrink: 1;
  overflow: auto;
  min-height: 40px;
  max-height: 100%;
`;
const UnBlockedBox = styled_components_1.default.div `
  display: flex;
  justify-content: center;
 `;
const BlockedEntriesRoundedContainer = styled_components_1.default.div `
  overflow: hidden;
  background: var(--background-secondary-color);
  border: 1px solid var(--border-color);
  border-radius: 16px;
  // padding: var(--margins-lg);
  // margin: 0 var(--margins-lg);
`;
const BlockedEntries = (props) => {
    const { addToSelected, blockedNumbers, removeFromSelected, selectedIds, multipleSelection, } = props;
    return (react_1.default.createElement(BlockedEntriesRoundedContainer, null,
        react_1.default.createElement(BlockedEntriesContainer, null, blockedNumbers.map(blockedEntry => {
            return (react_1.default.createElement(exports.BlockedMemberList, { pubkey: blockedEntry, isSelected: selectedIds.includes(blockedEntry), key: blockedEntry, onSelect: addToSelected, onUnselect: removeFromSelected, disableBg: false, multipleSelection: multipleSelection }));
        }))));
};
const AvatarContainer = styled_components_1.default.div `
  position: relative;
`;
const AvatarItem = (props) => {
    const { memberPubkey, isAdmin, isBnsHolder } = props;
    return (react_1.default.createElement(AvatarContainer, null,
        react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.M, pubkey: memberPubkey, isBnsHolder: isBnsHolder }),
        isAdmin && react_1.default.createElement(Avatar_1.CrownIcon, null)));
};
const BlockedMemberList = (props) => {
    const { isSelected, pubkey, isZombie, isAdmin, onSelect, onUnselect, disableBg, dataTestId, multipleSelection, } = props;
    const memberName = (0, useParamSelector_1.useConversationUsernameOrShorten)(pubkey);
    const isBnsHolder = (0, useParamSelector_1.useConversationBnsHolder)(pubkey);
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('bchat-blockedMember-item', isSelected && 'selected', isZombie && 'zombie', disableBg && 'compact'), onClick: () => {
            multipleSelection && isSelected ? onUnselect?.(pubkey) : onSelect?.(pubkey);
        }, style: !disableBg ? {} : {}, role: "button", "data-testid": dataTestId },
        react_1.default.createElement("div", { className: "bchat-member-item__info", style: { width: '100%' } },
            react_1.default.createElement("span", { className: "bchat-member-item__avatar" },
                react_1.default.createElement(AvatarItem, { memberPubkey: pubkey, isAdmin: isAdmin || false, isBnsHolder: isBnsHolder })),
            react_1.default.createElement("span", { className: "bchat-blockedMember-item__name" }, memberName)),
        react_1.default.createElement("div", { className: "bchat-blockedMember-item-selectionBox" }, !multipleSelection ? (react_1.default.createElement("div", { className: "bchat-blockedMember-item-btnBox" },
            react_1.default.createElement(BchatButton_1.BchatButton, { style: { minWidth: '45px', height: '45px', fontWeight: '400', fontSize: '16px', fontFamily: 'Poppins' }, buttonColor: BchatButton_1.BchatButtonColor.Danger, text: window.i18n('unblockUser'), onClick: () => (0, conversationInteractions_1.unblockConvoById)(pubkey), dataTestId: "unblock-button-settings-screen" }))) : (react_1.default.createElement("div", null,
            react_1.default.createElement(icon_1.BchatIconButton, { iconType: isSelected ? "checkBoxTick" : 'checkBox', iconSize: 23 }))))));
};
exports.BlockedMemberList = BlockedMemberList;
