"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ZoomingBchatSlider = void 0;
const react_1 = __importStar(require("react"));
const useUpdate_1 = __importDefault(require("react-use/lib/useUpdate"));
const BchatSettingListItem_1 = require("./BchatSettingListItem");
const react_redux_1 = require("react-redux");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const icon_1 = require("../icon");
const option = ['50%', '75%', '100%', '125%', '150%'];
const ZoomingBchatSlider = (props) => {
    const currentValueFromSettings = window.getSettingValue('zoom-factor-setting') || 100;
    const forceUpdate = (0, useUpdate_1.default)();
    const [value, setValue] = (0, react_1.useState)(currentValueFromSettings);
    const dispatch = (0, react_redux_1.useDispatch)();
    const handleSlider = (valueToForward) => {
        let value = valueToForward.substring(0, valueToForward.length - 1);
        props?.onSliderChange?.(value);
        window.setSettingValue('zoom-factor-setting', value);
        setValue(value);
        window.updateZoomFactor();
        dispatch((0, modalDialog_1.walletSettingMiniModal)(null));
        forceUpdate();
    };
    function displayPopUp() {
        dispatch((0, modalDialog_1.walletSettingMiniModal)({
            headerName: 'Zoom Level',
            content: option,
            currency: value + '%',
            onClose: () => dispatch((0, modalDialog_1.walletSettingMiniModal)(null)),
            onClick: (e) => {
                handleSlider(e);
            },
        }));
    }
    return (react_1.default.createElement(BchatSettingListItem_1.BchatSettingsItemWrapper, { title: window.i18n('zoomFactorSettingTitle'), inline: true, iconType: 'zoom' },
        react_1.default.createElement("div", { className: "bchat-settings-item__dropdownValue", onClick: () => displayPopUp() },
            react_1.default.createElement("div", null,
                value,
                "%"),
            react_1.default.createElement(icon_1.BchatIcon, { iconSize: "small", iconType: "chevron", iconRotation: 270 }))));
};
exports.ZoomingBchatSlider = ZoomingBchatSlider;
