"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingsCategoryAppearance = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const useUpdate_1 = __importDefault(require("react-use/lib/useUpdate"));
const os_1 = __importDefault(require("os"));
const settings_key_1 = require("../../../data/settings-key");
const utils_1 = require("../../../bchat/utils");
const BchatSettingListItem_1 = require("../BchatSettingListItem");
const ZoomingBchatSlider_1 = require("../ZoomingBchatSlider");
const BchatTheme_1 = require("../../../state/ducks/BchatTheme");
const theme_1 = require("../../../state/ducks/theme");
async function toggleStartInTray() {
    try {
        const newValue = !(await window.getStartInTray());
        window.setSettingValue(settings_key_1.SettingsKey.settingsStartInTray, newValue);
        await window.setStartInTray(newValue);
        if (!newValue) {
            utils_1.ToastUtils.pushRestartNeeded();
        }
    }
    catch (e) {
        window.log.warn('start in tray change error:', e);
    }
}
const SettingsCategoryAppearance = (props) => {
    const dispatch = (0, react_redux_1.useDispatch)();
    const forceUpdate = (0, useUpdate_1.default)();
    const darktheme = (0, react_redux_1.useSelector)((state) => state.theme);
    if (props.hasPassword !== null) {
        const isdark = darktheme === "dark" ? true : false;
        const isStartInTrayActive = Boolean(window.getSettingValue(settings_key_1.SettingsKey.settingsStartInTray));
        function handleClick() {
            const themeFromSettings = window.Events.getThemeSetting();
            const updatedTheme = themeFromSettings === 'dark' ? 'light' : 'dark';
            dispatch((0, theme_1.applyTheme)(updatedTheme));
            window.setTheme(updatedTheme);
            if (updatedTheme === 'dark') {
                (0, BchatTheme_1.switchHtmlToDarkTheme)();
            }
            else {
                (0, BchatTheme_1.switchHtmlToLightTheme)();
            }
        }
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement("div", { className: "bgWrapper " },
                react_1.default.createElement(BchatSettingListItem_1.BchatToggleWithDescription, { onClickToggle: () => {
                        handleClick();
                        forceUpdate();
                    }, title: "Dark Mode", active: isdark, iconType: 'sun' }),
                os_1.default.platform() !== "darwin" &&
                    react_1.default.createElement(BchatSettingListItem_1.BchatToggleWithDescription, { onClickToggle: async () => {
                            await toggleStartInTray();
                            forceUpdate();
                        }, title: window.i18n('startInTrayTitle'), description: "After closing the window, BChat runs in the background", active: isStartInTrayActive, iconType: 'bgProcess' }),
                react_1.default.createElement(ZoomingBchatSlider_1.ZoomingBchatSlider, null))));
    }
    return null;
};
exports.SettingsCategoryAppearance = SettingsCategoryAppearance;
