"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingsCategoryPrivacy = exports.displayPasswordModal = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const useUpdate_1 = __importDefault(require("react-use/lib/useUpdate"));
const settings_key_1 = require("../../../data/settings-key");
const utils_1 = require("../../../bchat/utils");
const modalDialog_1 = require("../../../state/ducks/modalDialog");
const userConfig_1 = require("../../../state/ducks/userConfig");
const userConfig_2 = require("../../../state/selectors/userConfig");
const BchatButton_1 = require("../../basic/BchatButton");
const BchatSettingListItem_1 = require("../BchatSettingListItem");
const icon_1 = require("../../icon");
const toggleCallMediaPermissions = async (triggerUIUpdate) => {
    const currentValue = window.getCallMediaPermissions();
    if (!currentValue) {
        window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)({
            title: 'Turn on Voice/Video Call',
            message: window.i18n('callMediaPermissionsDialogContent'),
            okTheme: BchatButton_1.BchatButtonColor.Primary,
            onClickOk: async () => {
                await window.toggleCallMediaPermissionsTo(true);
                triggerUIUpdate();
                utils_1.CallManager.onTurnedOnCallMediaPermissions();
            },
            onClickCancel: async () => {
                await window.toggleCallMediaPermissionsTo(false);
                triggerUIUpdate();
            },
            iconShow: true,
            customIcon: react_1.default.createElement(icon_1.BchatIcon, { iconType: 'videoCall', iconSize: 30 })
        }));
    }
    else {
        await window.toggleCallMediaPermissionsTo(false);
        triggerUIUpdate();
    }
};
function displayPasswordModal(passwordAction, onPasswordUpdated) {
    window.inboxStore?.dispatch((0, modalDialog_1.bchatPassword)({
        passwordAction,
        onOk: () => {
            onPasswordUpdated(passwordAction);
        },
    }));
}
exports.displayPasswordModal = displayPasswordModal;
async function toggleOpengroupPruning() {
    try {
        const newValue = !(await window.getOpengroupPruning());
        window.setSettingValue(settings_key_1.SettingsKey.settingsOpengroupPruning, newValue);
        await window.setOpengroupPruning(newValue);
        utils_1.ToastUtils.pushRestartNeeded();
    }
    catch (e) {
        window.log.warn('toggleOpengroupPruning change error:', e);
    }
}
const SettingsCategoryPrivacy = (props) => {
    const forceUpdate = (0, useUpdate_1.default)();
    const dispatch = (0, react_redux_1.useDispatch)();
    const isOpengroupPruningEnabled = Boolean(window.getSettingValue(settings_key_1.SettingsKey.settingsOpengroupPruning));
    if (props.hasPassword !== null) {
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement("div", { className: "bgWrapper " },
                react_1.default.createElement(BchatSettingListItem_1.BchatToggleWithDescription, { onClickToggle: () => {
                        const old = Boolean(window.getSettingValue(settings_key_1.SettingsKey.settingsTypingIndicator));
                        window.setSettingValue(settings_key_1.SettingsKey.settingsTypingIndicator, !old);
                        forceUpdate();
                    }, title: window.i18n('typingIndicatorsSettingTitle'), description: window.i18n('typingIndicatorsSettingDescription'), active: Boolean(window.getSettingValue(settings_key_1.SettingsKey.settingsTypingIndicator)), iconType: "chatDots" }),
                react_1.default.createElement(BchatSettingListItem_1.BchatToggleWithDescription, { onClickToggle: async () => {
                        await window.toggleMediaPermissions();
                        forceUpdate();
                    }, title: window.i18n('mediaPermissionsTitle'), description: window.i18n('mediaPermissionsDescription'), active: Boolean(window.getSettingValue('media-permissions')), iconType: "microphone" }),
                react_1.default.createElement(BchatSettingListItem_1.BchatToggleWithDescription, { onClickToggle: async () => {
                        await toggleCallMediaPermissions(forceUpdate);
                        forceUpdate();
                    }, title: window.i18n('callMediaPermissionsTitle'), description: window.i18n('callMediaPermissionsDescription'), active: Boolean(window.getCallMediaPermissions()), iconType: "privacyvideoCam" }),
                react_1.default.createElement(BchatSettingListItem_1.BchatToggleWithDescription, { onClickToggle: () => {
                        dispatch((0, userConfig_1.toggleMessageRequests)());
                    }, title: window.i18n('hideRequestBanner'), description: window.i18n('hideRequestBannerDescription'), active: (0, react_redux_1.useSelector)(userConfig_2.getHideMessageRequestBanner), iconType: "eye_closed" }),
                react_1.default.createElement(BchatSettingListItem_1.BchatToggleWithDescription, { onClickToggle: () => {
                        const old = Boolean(window.getSettingValue(settings_key_1.SettingsKey.settingsReadReceipt));
                        window.setSettingValue(settings_key_1.SettingsKey.settingsReadReceipt, !old);
                        forceUpdate();
                    }, title: window.i18n('readReceiptSettingTitle'), description: window.i18n('readReceiptSettingDescription'), active: window.getSettingValue(settings_key_1.SettingsKey.settingsReadReceipt), iconType: "receipt" }),
                react_1.default.createElement(BchatSettingListItem_1.BchatToggleWithDescription, { onClickToggle: async () => {
                        await toggleOpengroupPruning();
                        forceUpdate();
                    }, title: window.i18n('pruneSettingTitle'), description: window.i18n('pruneSettingDescription'), active: isOpengroupPruningEnabled, iconType: "members" }),
                react_1.default.createElement(BchatSettingListItem_1.BchatToggleWithDescription, { onClickToggle: () => {
                        const old = Boolean(window.getSettingValue(settings_key_1.SettingsKey.settingsAutoUpdate));
                        window.setSettingValue(settings_key_1.SettingsKey.settingsAutoUpdate, !old);
                        forceUpdate();
                    }, title: window.i18n('autoUpdateSettingTitle'), description: window.i18n('autoUpdateSettingDescription'), active: Boolean(window.getSettingValue(settings_key_1.SettingsKey.settingsAutoUpdate)), iconType: "rotatedArrow" }),
                !props.hasPassword && (react_1.default.createElement(BchatSettingListItem_1.BchatSettingButtonItem, { title: window.i18n('setAccountPasswordTitle'), description: window.i18n('setAccountPasswordDescription'), onClick: () => {
                        displayPasswordModal('set', props.onPasswordUpdated);
                    }, buttonColor: BchatButton_1.BchatButtonColor.Secondary, buttonText: window.i18n('setPassword'), dataTestId: 'set-password-button', iconType: "lockWithDots" })),
                props.hasPassword && (react_1.default.createElement(BchatSettingListItem_1.BchatSettingButtonItem, { title: window.i18n('changeAccountPasswordTitle'), description: window.i18n('changeAccountPasswordDescription'), onClick: () => {
                        displayPasswordModal('change', props.onPasswordUpdated);
                    }, buttonColor: BchatButton_1.BchatButtonColor.Primary, buttonText: window.i18n('changePassword'), iconType: "changePasswordSettings" })),
                props.hasPassword && (react_1.default.createElement(BchatSettingListItem_1.BchatSettingButtonItem, { title: window.i18n('removeAccountPasswordTitle'), description: window.i18n('removeAccountPasswordDescription'), onClick: () => {
                        displayPasswordModal('remove', props.onPasswordUpdated);
                    }, buttonColor: BchatButton_1.BchatButtonColor.Red, buttonText: window.i18n('removePassword'), iconType: "changePasswordSettings" })))));
    }
    return null;
};
exports.SettingsCategoryPrivacy = SettingsCategoryPrivacy;
