"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddressBook = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const classnames_1 = __importDefault(require("classnames"));
const walletConfig_1 = require("../../state/ducks/walletConfig");
const walletSection_1 = require("../../state/ducks/walletSection");
const conversations_1 = require("../../state/selectors/conversations");
const Flex_1 = require("../basic/Flex");
const Text_1 = require("../basic/Text");
const EditProfileDialog_1 = require("../dialog/EditProfileDialog");
const icon_1 = require("../icon");
const useParamSelector_1 = require("../../hooks/useParamSelector");
const Avatar_1 = require("../avatar/Avatar");
const modal_1 = require("../../state/selectors/modal");
const conversations_2 = require("../../bchat/conversations");
const AddressBook = (props) => {
    const { isContact } = props;
    const dispatch = (0, react_redux_1.useDispatch)();
    const privateContactsPubkeys = (0, react_redux_1.useSelector)(conversations_1.getPrivateContactsPubkeys);
    const BchatWalletPasswordModal = (0, react_redux_1.useSelector)(modal_1.getBchatWalletPasswordModal);
    const [currentSearchTerm, setCurrentSearchTerm] = (0, react_1.useState)('');
    const [filteredNames, setFilteredNames] = (0, react_1.useState)(privateContactsPubkeys);
    const zoomLevel = window.getSettingValue('zoom-factor-setting');
    async function send(address) {
        dispatch((0, walletConfig_1.updateSendAddress)(address));
    }
    const handleSearch = (event) => {
        const value = event.target.value;
        setCurrentSearchTerm(value);
        setFilteredNames(value
            ? privateContactsPubkeys.filter((pubkey) => {
                const convo = (0, conversations_2.getConversationController)().get(pubkey);
                const memberName = convo?.getNickname() || convo?.getName() || convo?.getProfileName();
                return memberName?.toLowerCase().includes(value.toLowerCase());
            })
            : privateContactsPubkeys);
    };
    return (react_1.default.createElement("div", { className: "addressBook" },
        isContact && (react_1.default.createElement("div", { className: (0, classnames_1.default)(BchatWalletPasswordModal && 'blurBg') },
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", { className: "bchat-search-input" },
                react_1.default.createElement("div", { className: "search" },
                    react_1.default.createElement(icon_1.BchatIcon, { iconSize: 20, iconType: "search" })),
                react_1.default.createElement("input", { value: currentSearchTerm, onChange: e => {
                        console.log(e);
                        handleSearch(e);
                    }, placeholder: 'Search Contact', maxLength: 26 })),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", { className: "addressBook-header-txt" }, window.i18n('contact')))),
        !isContact && (react_1.default.createElement("div", { style: { cursor: 'pointer' } },
            react_1.default.createElement(Flex_1.Flex, { container: true, alignItems: "center" },
                react_1.default.createElement(icon_1.BchatIconButton, { iconType: "KeyboardBackspaceArrow", iconSize: 'huge', iconColor: '#A9AEBA', onClick: () => dispatch((0, walletSection_1.dashboard)()) }),
                react_1.default.createElement(Text_1.SpacerMD, null),
                react_1.default.createElement("div", { className: "addressBook-header-txt" }, window.i18n('addressBook'))))),
        react_1.default.createElement("div", { className: (0, classnames_1.default)('addressBook-wholeBox ', BchatWalletPasswordModal && 'blurBg'), style: { height: !isContact && zoomLevel > 100 ? '' : !isContact ? 'calc( 100vh - 548px )' : 'calc( 100vh - 153px )' } },
            filteredNames.length > 0 &&
                filteredNames.map(item => (react_1.default.createElement(AddressContent, { pubkey: item, isContact: isContact, send: (e) => send(e) }))),
            filteredNames.length === 0 ? (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "center", alignItems: "center", flexDirection: "column", height: isContact ? '80%' : '100%' },
                    react_1.default.createElement("div", { className: "addressBook-emptyAddressBook", style: { height: isContact ? '186px' : '170px' } }),
                    react_1.default.createElement(Text_1.SpacerSM, null),
                    react_1.default.createElement("div", { className: "addressBook-emptyAddressBook-content" }, isContact ? (react_1.default.createElement("div", { className: "address-hint-txt" },
                        " ",
                        window.i18n('emptyContact'),
                        " ")) : (react_1.default.createElement(react_1.default.Fragment, null,
                        react_1.default.createElement("div", { className: "address-txt" }, "No Addresses!"),
                        react_1.default.createElement("div", { className: "address-hint-txt" }, "Save address to show!"))))))) : (''))));
};
exports.AddressBook = AddressBook;
const AddressContent = (props) => {
    const dispatch = (0, react_redux_1.useDispatch)();
    const username = (0, useParamSelector_1.useConversationUsernameOrShorten)(props.pubkey);
    const belAddress = (0, useParamSelector_1.useConversationBeldexAddress)(props.pubkey);
    const isBnsHolder = (0, useParamSelector_1.useConversationBnsHolder)(props.pubkey);
    async function copyBtn(address) {
        (0, EditProfileDialog_1.copyBchatID)(address);
    }
    return belAddress ? (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement("div", { className: (0, classnames_1.default)(`addressBook-wholeBox-contentBox`, !props.isContact && 'partition'), style: props.isContact ? { cursor: 'pointer' } : {}, onClick: () => props.isContact && dispatch((0, walletConfig_1.updateSendAddress)(belAddress)) },
            react_1.default.createElement("div", { className: "avatarBox" },
                react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.M, pubkey: props.pubkey, isBnsHolder: isBnsHolder })),
            react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column" },
                react_1.default.createElement("div", null,
                    react_1.default.createElement("span", { className: (0, classnames_1.default)('contact') }, username)),
                react_1.default.createElement(Text_1.SpacerXS, null),
                react_1.default.createElement("div", { className: 'addressBook-wholeBox-contentBox-addresstxt', style: props.isContact ? { cursor: 'pointer' } : {}, onClick: () => {
                        props.isContact &&
                            dispatch((0, walletConfig_1.updateSendAddress)(belAddress));
                    } }, props.isContact ? belAddress.slice(0, 50) + '...' : belAddress)),
            !props.isContact && (react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row", alignItems: "center", margin: "0 0 0 15px" },
                react_1.default.createElement(icon_1.BchatIconButton, { iconType: "copy", iconSize: 20, btnBgColor: "var(--color-clickable-hovered)", padding: "15px", btnRadius: "16px", clipRule: "evenodd", fillRule: "evenodd", onClick: () => copyBtn(belAddress) }),
                react_1.default.createElement(Text_1.SpacerSM, null),
                react_1.default.createElement(icon_1.BchatIconButton, { iconType: "send", iconSize: 20, iconColor: '#FFF', btnBgColor: "#108D32", padding: "15px", btnRadius: "16px", onClick: () => props.send(belAddress) })))),
        react_1.default.createElement(Text_1.SpacerXS, null))) : (react_1.default.createElement(react_1.default.Fragment, null));
};
